/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.suggest.analyzing.BlendedInfixSuggester;
import org.apache.lucene.store.Directory;

public class AutocompleteSuggester
extends BlendedInfixSuggester {
    public AutocompleteSuggester(Directory dir, Analyzer analyzer) throws IOException {
        super(dir, analyzer);
    }

    public AutocompleteSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, BlendedInfixSuggester.BlenderType blenderType, int numFactor, boolean commitOnBuild) throws IOException {
        super(dir, indexAnalyzer, queryAnalyzer, minPrefixChars, blenderType, numFactor, commitOnBuild);
    }

    public AutocompleteSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, BlendedInfixSuggester.BlenderType blenderType, int numFactor, Double exponent, boolean commitOnBuild, boolean allTermsRequired, boolean highlight) throws IOException {
        super(dir, indexAnalyzer, queryAnalyzer, minPrefixChars, blenderType, numFactor, exponent, commitOnBuild, allTermsRequired, highlight);
    }

    protected IndexWriterConfig getIndexWriterConfig(Analyzer indexAnalyzer, IndexWriterConfig.OpenMode openMode) {
        IndexWriterConfig iwConfig = super.getIndexWriterConfig(indexAnalyzer, openMode);
        iwConfig.setCommitOnClose(false);
        return iwConfig;
    }

    protected void addPrefixMatch(StringBuilder sb, String surface, String analyzed, String prefixToken) {
        if (prefixToken.length() >= surface.length()) {
            this.addWholeMatch(sb, surface, analyzed);
            return;
        }
        sb.append(AutocompleteSuggester.getOpeningHighlightTag());
        sb.append(surface.substring(0, prefixToken.length()));
        sb.append(AutocompleteSuggester.getClosingHighlightingTag());
        sb.append(surface.substring(prefixToken.length()));
    }

    protected void addWholeMatch(StringBuilder sb, String surface, String analyzed) {
        sb.append(AutocompleteSuggester.getOpeningHighlightTag());
        sb.append(surface);
        sb.append(AutocompleteSuggester.getClosingHighlightingTag());
    }

    private static String getOpeningHighlightTag() {
        return "\u0002";
    }

    private static String getClosingHighlightingTag() {
        return "\u0003";
    }

    public static String htmlifyHighlight(Object highlight) {
        return StringEscapeUtils.escapeHtml4((String)highlight.toString()).replace(AutocompleteSuggester.getOpeningHighlightTag(), "<b>").replace(AutocompleteSuggester.getClosingHighlightingTag(), "</b>");
    }
}

