/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.ontotext.trree.plugin.autocomplete.LabelConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutocompletePluginUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AutocompletePluginUtils.class);
    private static final String VERSION = "2";
    private static final String LEGACY_VERSION = "";
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final String PLUGIN_CONFIG_FILENAME = "config.properties";
    public static final String AUTOCOMPLETE_ENABLED_PROPERTY = "autocomplete.enabled";
    public static final String AUTOCOMPLETE_CONFIGURED_INDEX_IRIS_PROPERTY = "autocomplete.indexiris.configured";
    public static final String AUTOCOMPLETE_ACTUAL_INDEX_IRIS_PROPERTY = "autocomplete.indexiris.actual";
    public static final String AUTOCOMPLETE_CONFIGURED_LABELS_PROPERTY = "autocomplete.labels.configured";
    public static final String AUTOCOMPLETE_ACTUAL_LABELS_PROPERTY = "autocomplete.labels.actual";

    AutocompletePluginUtils() {
    }

    public static void migrateConfig(File pluginDataDir, Logger logger) {
        File legacyConfigFile;
        Path configPath = AutocompletePluginUtils.resolveConfigDirectory(pluginDataDir, false).resolve(PLUGIN_CONFIG_FILENAME);
        if (!Files.exists(configPath, new LinkOption[0]) && Files.isReadable((legacyConfigFile = AutocompletePluginUtils.resolveConfigDirectory(pluginDataDir, true).resolve(PLUGIN_CONFIG_FILENAME).toFile()).toPath())) {
            try {
                Properties properties = new Properties();
                AutocompletePluginUtils.loadPropertyFile(properties, legacyConfigFile);
                if (AutocompletePluginUtils.isPluginEnabledFromProperties(properties)) {
                    logger.warn("Detected incompatible index from a previous version. Please rebuild the index manually.");
                    AutocompletePluginUtils.setPluginEnabledInProperties(properties, false);
                }
                AutocompletePluginUtils.updatePluginConfiguration(AutocompletePluginUtils.resolveConfigDirectory(pluginDataDir, false).toFile(), properties);
            }
            catch (IOException e) {
                LOG.error("Cannot load legacy configuration file!", (Throwable)e);
            }
        }
    }

    public static Properties loadConfig(File pluginDataDir) {
        Properties properties = new Properties();
        File pluginConfigFile = AutocompletePluginUtils.resolveConfigDirectory(pluginDataDir, false).resolve(PLUGIN_CONFIG_FILENAME).toFile();
        boolean wasLoaded = false;
        if (pluginConfigFile.exists()) {
            try {
                AutocompletePluginUtils.loadPropertyFile(properties, pluginConfigFile);
                if (properties.getProperty(AUTOCOMPLETE_CONFIGURED_INDEX_IRIS_PROPERTY) == null) {
                    properties.setProperty(AUTOCOMPLETE_CONFIGURED_INDEX_IRIS_PROPERTY, "true");
                }
                if (properties.getProperty(AUTOCOMPLETE_ACTUAL_INDEX_IRIS_PROPERTY) == null) {
                    properties.setProperty(AUTOCOMPLETE_ACTUAL_INDEX_IRIS_PROPERTY, "true");
                }
                if (properties.getProperty(AUTOCOMPLETE_CONFIGURED_LABELS_PROPERTY) == null) {
                    properties.setProperty(AUTOCOMPLETE_CONFIGURED_LABELS_PROPERTY, LEGACY_VERSION);
                }
                if (properties.getProperty(AUTOCOMPLETE_ACTUAL_LABELS_PROPERTY) == null) {
                    properties.setProperty(AUTOCOMPLETE_ACTUAL_LABELS_PROPERTY, LEGACY_VERSION);
                }
                wasLoaded = true;
            }
            catch (IOException e) {
                LOG.error("Cannot load plugin configuration file!", (Throwable)e);
            }
        }
        if (!wasLoaded) {
            LOG.debug(">>>>>>>> AutocompletePlugin: No configuration file found at {}. Assuming default options for plugin.", (Object)pluginConfigFile);
            properties.setProperty(AUTOCOMPLETE_ENABLED_PROPERTY, "false");
        }
        return properties;
    }

    private static void loadPropertyFile(Properties properties, File file) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            properties.load(in);
        }
    }

    public static void updatePluginConfiguration(File pluginDataDir, Properties properties) {
        try {
            File pluginConfigFile = new File(pluginDataDir, PLUGIN_CONFIG_FILENAME);
            if (!pluginConfigFile.exists()) {
                FileUtils.forceMkdir((File)pluginDataDir);
            }
            try (FileWriter writer = new FileWriter(pluginConfigFile);){
                properties.store(writer, "Autocomplete plugin config");
            }
        }
        catch (IOException e) {
            LOG.error("Cannot update plugin configuration", (Throwable)e);
        }
    }

    public static boolean isPluginEnabledFromProperties(Properties properties) {
        return XMLDatatypeUtil.parseBoolean((String)properties.getProperty(AUTOCOMPLETE_ENABLED_PROPERTY, "false"));
    }

    public static void setPluginEnabledInProperties(Properties properties, boolean isPluginEnabled) {
        properties.setProperty(AUTOCOMPLETE_ENABLED_PROPERTY, Boolean.toString(isPluginEnabled));
    }

    public static boolean configuredShouldIndexIRIsFromProperties(Properties properties) {
        return XMLDatatypeUtil.parseBoolean((String)properties.getProperty(AUTOCOMPLETE_CONFIGURED_INDEX_IRIS_PROPERTY, "true"));
    }

    public static void setConfiguredShouldIndexIRIsInProperties(Properties properties, boolean shouldIndexIRIs) {
        properties.setProperty(AUTOCOMPLETE_CONFIGURED_INDEX_IRIS_PROPERTY, Boolean.toString(shouldIndexIRIs));
    }

    public static boolean actualShouldIndexIRIsFromProperties(Properties properties) {
        return XMLDatatypeUtil.parseBoolean((String)properties.getProperty(AUTOCOMPLETE_ACTUAL_INDEX_IRIS_PROPERTY, "true"));
    }

    public static void setActualShouldIndexIRIsInProperties(Properties properties, boolean shouldIndexIRIs) {
        properties.setProperty(AUTOCOMPLETE_ACTUAL_INDEX_IRIS_PROPERTY, Boolean.toString(shouldIndexIRIs));
    }

    public static Map<IRI, LabelConfig> getConfiguredLabelsFromProperties(Properties properties) {
        return AutocompletePluginUtils.getLabelsFromProperties(properties, AUTOCOMPLETE_CONFIGURED_LABELS_PROPERTY);
    }

    public static void setConfiguredLabelsInProperties(Properties properties, Map<IRI, LabelConfig> labelConfigs) {
        AutocompletePluginUtils.setLabelsInProperties(properties, AUTOCOMPLETE_CONFIGURED_LABELS_PROPERTY, labelConfigs.values());
    }

    public static void setActualLabelsInProperties(Properties properties, LabelConfig[] labelConfigs) {
        AutocompletePluginUtils.setLabelsInProperties(properties, AUTOCOMPLETE_ACTUAL_LABELS_PROPERTY, Arrays.asList(labelConfigs));
    }

    public static Map<IRI, LabelConfig> getActualLabelsFromProperties(Properties properties) {
        return AutocompletePluginUtils.getLabelsFromProperties(properties, AUTOCOMPLETE_ACTUAL_LABELS_PROPERTY);
    }

    private static Map<IRI, LabelConfig> getLabelsFromProperties(Properties properties, String propertyName) {
        HashMap<IRI, LabelConfig> labelConfigs = new HashMap<IRI, LabelConfig>();
        String propertyValue = properties.getProperty(propertyName, RDFS.LABEL.stringValue() + "@");
        if (!propertyValue.isEmpty()) {
            String[] labelStrings;
            for (String labelString : labelStrings = propertyValue.split("\n")) {
                String[] labelData = labelString.split("@", 2);
                IRI labelIri = VF.createIRI(labelData[0]);
                labelConfigs.put(labelIri, new LabelConfig(labelIri, 0L, labelData[1]));
            }
        }
        return labelConfigs;
    }

    private static void setLabelsInProperties(Properties properties, String propertyName, Collection<LabelConfig> labelConfigs) {
        String propertiesValue = labelConfigs.stream().map(lc -> lc.labelIRI.stringValue() + "@" + String.join((CharSequence)",", lc.languages)).collect(Collectors.joining("\n"));
        properties.setProperty(propertyName, propertiesValue);
    }

    static Path resolveConfigDirectory(File pluginDataDir, boolean legacy) {
        return pluginDataDir.toPath().resolve(legacy ? LEGACY_VERSION : "v2");
    }

    static Path resolveIndexDirectory(File pluginDataDir) {
        return pluginDataDir.toPath().resolve("v2").resolve("index");
    }
}

