/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.ontotext.trree.plugin.autocomplete.AutocompleteIndex;
import com.ontotext.trree.plugin.autocomplete.AutocompletePluginUtils;
import com.ontotext.trree.plugin.autocomplete.AutocompleteUpdateListener;
import com.ontotext.trree.plugin.autocomplete.IndexStatus;
import com.ontotext.trree.plugin.autocomplete.LabelConfig;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.EntityListener;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginDependency;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginLocator;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatelessPlugin;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class AutocompletePlugin
extends PluginBase
implements PatternInterpreter,
UpdateInterpreter,
PluginDependency,
StatelessPlugin,
EntityListener,
PluginTransactionListener,
StatementListener {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final int RESULTS_COUNT = 100;
    private static final String AUTOCOMPLETE_NAMESPACE = "http://www.ontotext.com/plugins/autocomplete#%s";
    private static final IRI AUTOCOMPLETE_CONTROL_CONTEXT = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "control"));
    private static final IRI AUTOCOMPLETE_QUERY_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "query"));
    private static final IRI AUTOCOMPLETE_REINDEX_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "reIndex"));
    private static final IRI AUTOCOMPLETE_ENABLED_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "enabled"));
    private static final IRI AUTOCOMPLETE_INDEX_IRIS_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "indexIRIs"));
    private static final IRI AUTOCOMPLETE_PRESENT_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "present"));
    private static final IRI AUTOCOMPLETE_STATUS_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "status"));
    private static final IRI AUTOCOMPLETE_INDEXING_INTERRUPT_PREDICATE = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "interruptIndexing"));
    private static final IRI AUTOCOMPLETE_LABEL_CONFIG = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "labelConfig"));
    private static final IRI AUTOCOMPLETE_ADD_LABEL_CONFIG = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "addLabelConfig"));
    private static final IRI AUTOCOMPLETE_REMOVE_LABEL_CONFIG = VF.createIRI(String.format("http://www.ontotext.com/plugins/autocomplete#%s", "removeLabelConfig"));
    private long controlContextId;
    private long queryPredicateId;
    private long reIndexPredicateId;
    private long enabledPredicateId;
    private long indexIRIsPredicateId;
    private long presentPredicateId;
    private long indexStatusPredicateId;
    private long interruptIndexingPredicateId;
    private long labelConfigId;
    private long addLabelConfigId;
    private long removeLabelConfigId;
    private Map<IRI, LabelConfig> configuredLabelConfigs;
    boolean configuredAndActualConfigsDiffer;
    LabelConfig[] labelConfigs;
    Properties pluginConfig;
    boolean isPluginEnabled;
    boolean configuredShouldIndexIRIs;
    boolean actualShouldIndexIRIs;
    AutocompleteIndex autocompleteIndex;
    private AutocompleteUpdateListener autocompleteUpdateLister;
    private PluginLocator pluginLocator;

    public String getName() {
        return "autocomplete";
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        AutocompletePluginUtils.migrateConfig(this.getDataDir(), this.getLogger());
        this.pluginConfig = AutocompletePluginUtils.loadConfig(this.getDataDir());
        this.isPluginEnabled = AutocompletePluginUtils.isPluginEnabledFromProperties(this.pluginConfig);
        this.configuredShouldIndexIRIs = AutocompletePluginUtils.configuredShouldIndexIRIsFromProperties(this.pluginConfig);
        this.actualShouldIndexIRIs = AutocompletePluginUtils.actualShouldIndexIRIsFromProperties(this.pluginConfig);
        this.configuredLabelConfigs = AutocompletePluginUtils.getConfiguredLabelsFromProperties(this.pluginConfig);
        this.labelConfigs = this.labelConfigMapToArray(AutocompletePluginUtils.getActualLabelsFromProperties(this.pluginConfig));
        this.updateConfiguredVsActualConfig();
        this.autocompleteUpdateLister = new AutocompleteUpdateListener(this);
        this.registerPredicates(pluginConnection.getEntities());
        if (this.isPluginEnabled) {
            this.initAutocompleteIndex();
        }
    }

    private void registerPredicates(Entities entities) {
        this.controlContextId = entities.put((Value)AUTOCOMPLETE_CONTROL_CONTEXT, Entities.Scope.SYSTEM);
        this.queryPredicateId = entities.put((Value)AUTOCOMPLETE_QUERY_PREDICATE, Entities.Scope.SYSTEM);
        this.reIndexPredicateId = entities.put((Value)AUTOCOMPLETE_REINDEX_PREDICATE, Entities.Scope.SYSTEM);
        this.enabledPredicateId = entities.put((Value)AUTOCOMPLETE_ENABLED_PREDICATE, Entities.Scope.SYSTEM);
        this.indexIRIsPredicateId = entities.put((Value)AUTOCOMPLETE_INDEX_IRIS_PREDICATE, Entities.Scope.SYSTEM);
        this.presentPredicateId = entities.put((Value)AUTOCOMPLETE_PRESENT_PREDICATE, Entities.Scope.SYSTEM);
        this.indexStatusPredicateId = entities.put((Value)AUTOCOMPLETE_STATUS_PREDICATE, Entities.Scope.SYSTEM);
        this.interruptIndexingPredicateId = entities.put((Value)AUTOCOMPLETE_INDEXING_INTERRUPT_PREDICATE, Entities.Scope.SYSTEM);
        this.labelConfigId = entities.put((Value)AUTOCOMPLETE_LABEL_CONFIG, Entities.Scope.SYSTEM);
        this.addLabelConfigId = entities.put((Value)AUTOCOMPLETE_ADD_LABEL_CONFIG, Entities.Scope.SYSTEM);
        this.removeLabelConfigId = entities.put((Value)AUTOCOMPLETE_REMOVE_LABEL_CONFIG, Entities.Scope.SYSTEM);
        this.resolveActualLabelConfig(entities);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.queryPredicateId || context == this.controlContextId) {
            if (subject == 0L) {
                return Double.MIN_VALUE;
            }
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (context == this.controlContextId) {
            this.processControlRequest(subject, predicate, object, pluginConnection);
            return StatementIterator.TRUE();
        }
        if (predicate == this.presentPredicateId) {
            return StatementIterator.TRUE();
        }
        if (predicate == this.enabledPredicateId) {
            return this.isPluginEnabled ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        if (predicate == this.indexIRIsPredicateId) {
            return this.configuredShouldIndexIRIs ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        if (predicate == this.indexStatusPredicateId) {
            long statusRequestEntity = pluginConnection.getEntities().put((Value)VF.createLiteral(this.getIndexStatus()), Entities.Scope.REQUEST);
            return StatementIterator.create((long)subject, (long)predicate, (long)statusRequestEntity, (long)context);
        }
        if (predicate == this.labelConfigId) {
            long[][] resultStatements = new long[this.configuredLabelConfigs.size()][];
            int i = 0;
            for (LabelConfig config : this.configuredLabelConfigs.values()) {
                long labelPredicateId = pluginConnection.getEntities().put((Value)config.labelIRI, Entities.Scope.REQUEST);
                long labelLanguagesId = pluginConnection.getEntities().put((Value)VF.createLiteral(String.join((CharSequence)", ", config.languages)), Entities.Scope.REQUEST);
                resultStatements[i] = new long[]{labelPredicateId, predicate, labelLanguagesId, 0L};
                ++i;
            }
            return StatementIterator.create((long[][])resultStatements);
        }
        if (!this.isPluginEnabled) {
            return null;
        }
        if (predicate != this.queryPredicateId) {
            return null;
        }
        if (object == 0L) {
            return StatementIterator.FALSE();
        }
        String queryStr = pluginConnection.getEntities().get(object).stringValue();
        String namespace = null;
        String query = "";
        if (!queryStr.contains(";")) {
            query = queryStr;
        } else if (queryStr.endsWith(";")) {
            namespace = queryStr.substring(0, queryStr.length() - 1);
            query = "";
        } else {
            String[] split = queryStr.split(";");
            if (split.length > 1) {
                namespace = split[0];
                query = split[1];
            }
        }
        Collection<AutocompleteIndex.Result> foundEntities = this.autocompleteIndex.findEntities(namespace, query, pluginConnection.getEntities(), 100);
        long[][] resultStatements = new long[foundEntities.size()][];
        int i = 0;
        for (AutocompleteIndex.Result result : foundEntities) {
            long id = result.id;
            if (id == 0L) {
                id = pluginConnection.getEntities().put((Value)result.resource, Entities.Scope.REQUEST);
            }
            resultStatements[i] = new long[]{id, predicate, object, pluginConnection.getEntities().put((Value)VF.createLiteral(result.highlight), Entities.Scope.REQUEST)};
            ++i;
        }
        return StatementIterator.create((long[][])resultStatements);
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.reIndexPredicateId, this.enabledPredicateId, this.indexIRIsPredicateId, this.interruptIndexingPredicateId, this.addLabelConfigId, this.removeLabelConfigId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        this.processControlRequest(subject, predicate, object, pluginConnection);
        return true;
    }

    private void processControlRequest(long subject, long predicate, long object, PluginConnection pluginConnection) {
        LabelConfig previousLabelConfig;
        IRI labelPredicate;
        LabelConfig labelConfig;
        String pluginEnabledStringLiteral;
        boolean isPluginEnabledNew;
        if (predicate == this.reIndexPredicateId) {
            if (!this.isPluginEnabled) {
                throw new PluginException("Autocomplete is not enabled.");
            }
            try {
                this.autocompleteIndex.buildIndex(pluginConnection);
            }
            catch (Exception e) {
                throw new PluginException("Unable to start index rebuilding.", (Throwable)e);
            }
        }
        if (predicate == this.interruptIndexingPredicateId) {
            this.autocompleteIndex.interrupt();
        }
        if (predicate == this.enabledPredicateId && (isPluginEnabledNew = XMLDatatypeUtil.parseBoolean((String)(pluginEnabledStringLiteral = pluginConnection.getEntities().get(object).stringValue()))) != this.isPluginEnabled) {
            this.isPluginEnabled = isPluginEnabledNew;
            this.savePluginConfig();
            if (this.isPluginEnabled) {
                this.initAutocompleteIndex();
                if (!this.autocompleteIndex.hasBuiltIndex) {
                    this.autocompleteIndex.buildIndex(pluginConnection);
                }
            }
        }
        if (predicate == this.indexIRIsPredicateId) {
            String pluginIndexIRIsStringLiteral = pluginConnection.getEntities().get(object).stringValue();
            boolean previousValue = this.configuredShouldIndexIRIs;
            this.configuredShouldIndexIRIs = XMLDatatypeUtil.parseBoolean((String)pluginIndexIRIsStringLiteral);
            if (this.configuredShouldIndexIRIs != previousValue) {
                this.savePluginConfig();
                this.updateConfiguredVsActualConfig();
            }
        }
        if (predicate == this.addLabelConfigId && !(labelConfig = new LabelConfig(labelPredicate = (IRI)pluginConnection.getEntities().get(subject), subject, pluginConnection.getEntities().get(object).stringValue())).equals(previousLabelConfig = this.configuredLabelConfigs.put(labelPredicate, labelConfig))) {
            this.autocompleteUpdateLister.notifyAboutLabelConfig(labelConfig);
            this.savePluginConfig();
            this.updateConfiguredVsActualConfig();
        }
        if (predicate == this.removeLabelConfigId && this.configuredLabelConfigs.remove(labelPredicate = (IRI)pluginConnection.getEntities().get(subject)) != null) {
            this.savePluginConfig();
            this.updateConfiguredVsActualConfig();
        }
    }

    private void initAutocompleteIndex() {
        if (this.autocompleteIndex == null) {
            this.autocompleteIndex = new AutocompleteIndex(this);
        }
    }

    public PluginLocator getPluginLocator() {
        return this.pluginLocator;
    }

    private String getIndexStatus() {
        if (this.isPluginEnabled) {
            IndexStatus status = this.autocompleteIndex.status();
            if (status == IndexStatus.ERROR) {
                return status.name() + ": " + this.autocompleteIndex.error();
            }
            return status.name();
        }
        return IndexStatus.NONE.name();
    }

    public void shutdown(ShutdownReason shutdownReason) {
        if (this.autocompleteIndex != null) {
            this.autocompleteIndex.shutDown();
            this.autocompleteIndex = null;
        }
    }

    public void setLocator(PluginLocator pluginLocator) {
        this.pluginLocator = pluginLocator;
    }

    private void savePluginConfig() {
        AutocompletePluginUtils.setPluginEnabledInProperties(this.pluginConfig, this.isPluginEnabled);
        AutocompletePluginUtils.setConfiguredShouldIndexIRIsInProperties(this.pluginConfig, this.configuredShouldIndexIRIs);
        AutocompletePluginUtils.setActualShouldIndexIRIsInProperties(this.pluginConfig, this.configuredShouldIndexIRIs);
        AutocompletePluginUtils.setConfiguredLabelsInProperties(this.pluginConfig, this.configuredLabelConfigs);
        AutocompletePluginUtils.setActualLabelsInProperties(this.pluginConfig, this.labelConfigs);
        AutocompletePluginUtils.updatePluginConfiguration(AutocompletePluginUtils.resolveConfigDirectory(this.getDataDir(), false).toFile(), this.pluginConfig);
    }

    private LabelConfig[] labelConfigMapToArray(Map<IRI, LabelConfig> labels) {
        return labels.values().toArray(new LabelConfig[labels.size()]);
    }

    void updateActualConfig(Entities entities) {
        this.configuredAndActualConfigsDiffer = false;
        this.actualShouldIndexIRIs = this.configuredShouldIndexIRIs;
        this.labelConfigs = this.labelConfigMapToArray(this.configuredLabelConfigs);
        this.resolveActualLabelConfig(entities);
        this.savePluginConfig();
    }

    private void resolveActualLabelConfig(Entities entities) {
        for (LabelConfig labelConfig : this.labelConfigs) {
            labelConfig.labelId = entities.resolve((Value)labelConfig.labelIRI);
            this.autocompleteUpdateLister.notifyAboutLabelConfig(labelConfig);
        }
    }

    private void updateConfiguredVsActualConfig() {
        this.configuredAndActualConfigsDiffer = this.configuredShouldIndexIRIs != this.actualShouldIndexIRIs || !Arrays.deepEquals(this.configuredLabelConfigs.values().toArray(), this.labelConfigs);
    }

    public void entityAdded(long id, Value value, PluginConnection pluginConnection) {
        this.autocompleteUpdateLister.entityAdded(id, value, pluginConnection);
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.autocompleteUpdateLister.transactionCommit(pluginConnection);
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        return this.autocompleteUpdateLister.statementAdded(subject, predicate, object, context, explicit, pluginConnection);
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        return this.autocompleteUpdateLister.statementRemoved(subject, predicate, object, context, explicit, pluginConnection);
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.autocompleteUpdateLister.transactionStarted(pluginConnection);
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        this.autocompleteUpdateLister.transactionCompleted(pluginConnection);
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        this.autocompleteUpdateLister.transactionAborted(pluginConnection);
    }

    public void transactionAbortedByUser(PluginConnection pluginConnection) {
        this.autocompleteUpdateLister.transactionAbortedByUser(pluginConnection);
    }
}

