/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.sparql.AbstractTransactionPolicy;
import com.ontotext.sparql.TransactionBeginRequest;
import com.ontotext.sparql.TransactionCommitRequest;
import com.ontotext.sparql.TransactionControlRequest;
import com.ontotext.sparql.TransactionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class TransactionPolicies {
    private TransactionPolicies() {
    }

    public static TransactionPolicy getSingleTxWithoutSelects() {
        return new SingleTxPolicy();
    }

    public static TransactionPolicy getSingleTxWithSelects() {
        return new SingleTxWithSelectPolicy();
    }

    public static TransactionPolicy getTxPerUpdate() {
        return new TxPerUpdatePolicy();
    }

    private static class SingleTxPolicy
    extends AbstractTransactionPolicy {
        private AtomicInteger active = new AtomicInteger();

        private SingleTxPolicy() {
        }

        @Override
        public TransactionControlRequest onBeforeFirst(String requestId) {
            if (this.active.getAndIncrement() == 0) {
                return new TransactionBeginRequest(requestId);
            }
            return null;
        }

        @Override
        public TransactionControlRequest onAfterLast(String requestId) {
            if (this.active.decrementAndGet() == 0) {
                return new TransactionCommitRequest(requestId);
            }
            return null;
        }

        @Override
        public boolean rollBackOnSingleUpdateFailure() {
            return true;
        }
    }

    private static class SingleTxWithSelectPolicy
    extends AbstractTransactionPolicy {
        private AtomicInteger active = new AtomicInteger();

        private SingleTxWithSelectPolicy() {
        }

        @Override
        public TransactionControlRequest onBeforeFirst(String requestId) {
            if (this.active.getAndIncrement() == 0) {
                return new TransactionBeginRequest(requestId);
            }
            return null;
        }

        @Override
        public TransactionControlRequest onRequestComplete(String requestId) {
            if (this.active.decrementAndGet() == 0) {
                return new TransactionCommitRequest(requestId);
            }
            return null;
        }

        @Override
        public boolean executeReadsInTx() {
            return true;
        }

        @Override
        public boolean rollBackOnSingleUpdateFailure() {
            return true;
        }
    }

    private static class TxPerUpdatePolicy
    extends AbstractTransactionPolicy {
        private TxPerUpdatePolicy() {
        }

        @Override
        public TransactionControlRequest onBeforeEach(String requestId) {
            return new TransactionBeginRequest(requestId);
        }

        @Override
        public TransactionControlRequest onAfterEach(String requestId) {
            return new TransactionCommitRequest(requestId);
        }

        @Override
        public boolean rollBackOnSingleUpdateFailure() {
            return false;
        }
    }
}

