/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.TransactionControlRequest;

public class TransactionCommitRequest
extends TransactionControlRequest {
    public TransactionCommitRequest(String requestId) {
        super(requestId);
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        if (!connection.isTxActive()) {
            return (E)ExecutionResponse.ofError((String)this.getRequestId(), (Throwable)new RuntimeException("Cannot commit transaction. Transaction not active for request: " + this.getRequestId()));
        }
        try {
            Loggers.sparqlUpdateLogger().trace("Transaction commit: {}", (Object)this.getRequestId());
            connection.commit();
        }
        catch (RuntimeException re) {
            return (E)ExecutionResponse.ofError((String)this.getRequestId(), (Throwable)re);
        }
        return (E)ExecutionResponse.of(null, (String)this.getRequestId());
    }
}

