/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.UpdateResultDiff;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TrackChangesLoaderOptimized {
    private static final String PREFIXES = "prefix res: <http://www.ontotext.com/semantic-object/result/>\n";
    private static final String BEGIN_ADD_QUERY = "prefix res: <http://www.ontotext.com/semantic-object/result/>\nconstruct { res: res:added ?s. ?s ?p ?o.}\n";
    private static final String BEGIN_REMOVE_QUERY = "prefix res: <http://www.ontotext.com/semantic-object/result/>\nconstruct { res: res:removed ?s. ?s ?p ?o.}\n";
    private static final String QUERY_END = " where \n{ ?s ?p ?o }";

    public LoaderResponse fetchChanges(String requestId, List<String> requestIds, SomlSchema schema, SparqlEndpoint endpoint, SparqlQueryInvoker invoker) {
        QueryRequest addedQueryRequest = QueryRequestBuilder.createAddedQueryRequest(requestId, requestIds, schema);
        QueryRequest removedQueryRequest = QueryRequestBuilder.createRemovedQueryRequest(requestId, requestIds, schema);
        List<ExecutionResponse<RdfTree>> responses = invoker.invoke(Arrays.asList(addedQueryRequest, removedQueryRequest), endpoint);
        UpdateResultDiff resultDiff = new UpdateResultDiff();
        LinkedList<Serializable> errors = new LinkedList<Serializable>();
        if (TrackChangesLoaderOptimized.isChangesFetchingSuccessful(responses)) {
            RdfTree addedData = (RdfTree)responses.get(0).getData();
            RdfTree removedData = (RdfTree)responses.get(1).getData();
            QueryRequestBuilder.removeDuplicates(addedData, removedData);
            resultDiff = new UpdateResultDiff(addedData, removedData);
        } else {
            for (ExecutionResponse<RdfTree> response : responses) {
                if (response.getError() == null) continue;
                errors.add((Serializable)((Object)response.getError().getMessage()));
            }
        }
        return new LoaderResponse(resultDiff, errors);
    }

    private static boolean isChangesFetchingSuccessful(List<ExecutionResponse<RdfTree>> responses) {
        return responses.stream().allMatch(ExecutionResponse::isSuccessful) && responses.size() == 2;
    }

    static class QueryRequestBuilder {
        private QueryRequestBuilder() {
        }

        static QueryRequest createAddedQueryRequest(String requestId, Collection<String> requestIds, SomlSchema schema) {
            String fetchAddedStatementsQuery = requestIds.stream().distinct().map(QueryRequestBuilder::toAddedEndpoint).collect(Collectors.joining("\n", TrackChangesLoaderOptimized.BEGIN_ADD_QUERY, TrackChangesLoaderOptimized.QUERY_END));
            QueryRequest queryRequest = (QueryRequest)new QueryRequest(requestId, fetchAddedStatementsQuery, Collections.emptyMap(), schema).disableRequestLogging();
            queryRequest.setIncludeInferred(false);
            return queryRequest;
        }

        private static String toAddedEndpoint(String id) {
            return String.format("from <http://www.ontotext.com/added/%s> ", id);
        }

        static QueryRequest createRemovedQueryRequest(String requestId, Collection<String> requestIds, SomlSchema schema) {
            String fetchRemovedStatementsQuery = requestIds.stream().distinct().map(QueryRequestBuilder::toRemovedEndpoint).collect(Collectors.joining("\n", TrackChangesLoaderOptimized.BEGIN_REMOVE_QUERY, TrackChangesLoaderOptimized.QUERY_END));
            QueryRequest queryRequest = (QueryRequest)new QueryRequest(requestId, fetchRemovedStatementsQuery, Collections.emptyMap(), schema).disableRequestLogging();
            queryRequest.setIncludeInferred(false);
            return queryRequest;
        }

        private static String toRemovedEndpoint(String id) {
            return String.format("from <http://www.ontotext.com/removed/%s> ", id);
        }

        static void removeDuplicates(RdfTree addedStatements, RdfTree removedStatements) {
            Collection allAdded = addedStatements.getAllTriples();
            Collection allRemoved = removedStatements.getAllTriples();
            HashSet<Triple> uniqueAdded = new HashSet<Triple>(allAdded);
            uniqueAdded.removeAll(allRemoved);
            HashSet<Triple> uniqueRemoved = new HashSet<Triple>(allRemoved);
            uniqueRemoved.removeAll(allAdded);
            QueryRequestBuilder.removeDuplicateStatements(addedStatements, uniqueAdded, "added");
            QueryRequestBuilder.removeDuplicateStatements(removedStatements, uniqueRemoved, "removed");
        }

        private static void removeDuplicateStatements(RdfTree target, Collection<Triple> uniqueTriples, String targetType) {
            uniqueTriples.stream().collect(Collectors.groupingBy(QueryRequestBuilder.getSubject(), Collectors.counting())).forEach((subject, count) -> {
                if (count == 1L) {
                    target.remove("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + targetType, subject);
                }
            });
        }

        private static Function<Triple, String> getSubject() {
            return triple -> {
                if ("http://www.ontotext.com/semantic-object/result/".equals(triple.getSubject())) {
                    return triple.getObject().toString();
                }
                return triple.getSubject();
            };
        }
    }

    public static class LoaderResponse {
        private final UpdateResultDiff resultDiff;
        private final List<Serializable> errors;

        LoaderResponse(UpdateResultDiff resultDiff, List<Serializable> errors) {
            this.resultDiff = resultDiff;
            this.errors = errors;
        }

        public UpdateResultDiff getResultDiff() {
            return this.resultDiff;
        }

        public List<Serializable> getErrors() {
            return this.errors;
        }
    }
}

