/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.TrackChangesLoaderOptimized;
import com.ontotext.sparql.UpdateResultDiff;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TrackChangesLoader {
    public TrackChangesLoaderOptimized.LoaderResponse fetchChanges(String requestId, List<String> requestIds, SomlSchema schema, SparqlEndpoint endpoint, SparqlQueryInvoker invoker) {
        TrackChangesLoaderOptimized.LoaderResponse result = new TrackChangesLoaderOptimized.LoaderResponse(new UpdateResultDiff(), new ArrayList<Serializable>());
        for (String id : requestIds) {
            QueryRequest addedQueryRequest = TrackChangesLoaderOptimized.QueryRequestBuilder.createAddedQueryRequest(requestId, Collections.singleton(id), schema);
            QueryRequest removedQueryRequest = TrackChangesLoaderOptimized.QueryRequestBuilder.createRemovedQueryRequest(requestId, Collections.singleton(id), schema);
            List<ExecutionResponse<RdfTree>> responses = invoker.invoke(Arrays.asList(addedQueryRequest, removedQueryRequest), endpoint);
            TrackChangesLoaderOptimized.LoaderResponse loaderResponse = this.accumolateData(responses);
            result.getResultDiff().merge(loaderResponse.getResultDiff());
            result.getErrors().addAll(loaderResponse.getErrors());
        }
        return result;
    }

    private TrackChangesLoaderOptimized.LoaderResponse accumolateData(List<ExecutionResponse<RdfTree>> responses) {
        UpdateResultDiff resultDiff;
        LinkedList<Serializable> errors = new LinkedList<Serializable>();
        if (responses.stream().allMatch(ExecutionResponse::isSuccessful) && responses.size() == 2) {
            RdfTree addedData = (RdfTree)responses.get(0).getData();
            RdfTree removedData = (RdfTree)responses.get(1).getData();
            TrackChangesLoaderOptimized.QueryRequestBuilder.removeDuplicates(addedData, removedData);
            resultDiff = new UpdateResultDiff(addedData, removedData);
        } else {
            resultDiff = new UpdateResultDiff();
            for (ExecutionResponse<RdfTree> response : responses) {
                if (response.getError() == null) continue;
                errors.add((Serializable)((Object)response.getError().getMessage()));
            }
        }
        return new TrackChangesLoaderOptimized.LoaderResponse(resultDiff, errors);
    }
}

