/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.exceptions.SerializableException;
import com.ontotext.sparql.AutoLoadingSparqlConnectionFactory;
import com.ontotext.sparql.ConnectionReusePolicies;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.DatatypeConversionException;
import com.ontotext.sparql.InterruptedQueryException;
import com.ontotext.sparql.QueryInvocationException;
import com.ontotext.sparql.QueryInvocationExceptionMappers;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.SparqlResponse;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.http.HTTPQueryEvaluationException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQueryInvoker
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_CONCURRENT_REQUESTS = Integer.MAX_VALUE;
    private int maxConcurrentRequests = Integer.MAX_VALUE;
    private final SparqlConnectionFactory connectionFactory;
    private final boolean managedConnectionFactory;
    private ExecutorService executor = SparqlQueryInvoker.createExecutorService(Integer.MAX_VALUE);

    public SparqlQueryInvoker() {
        this(new AutoLoadingSparqlConnectionFactory(), true);
    }

    public SparqlQueryInvoker(SparqlConnectionFactory connectionFactory) {
        this(connectionFactory, false);
    }

    private SparqlQueryInvoker(SparqlConnectionFactory connectionFactory, boolean managedConnectionFactory) {
        this.connectionFactory = connectionFactory;
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public <D> CompletableFuture<ExecutionResponse<D>> invokeAsync(SparqlRequest queryRequest, SparqlEndpoint repositoryInfo) {
        return this.invokeAsync(queryRequest, repositoryInfo, ConnectionReusePolicies.noConnectionReuse());
    }

    public <D> CompletableFuture<ExecutionResponse<D>> invokeAsync(SparqlRequest queryRequest, SparqlEndpoint repositoryInfo, ConnectionReusePolicy connectionReusePolicy) {
        ConnectionReusePolicy policy = ThreadLocalContextManager.wrap(connectionReusePolicy);
        return CompletableFuture.supplyAsync(() -> this.invoke(queryRequest, repositoryInfo, policy), this.executor);
    }

    public <D> ExecutionResponse<D> invoke(SparqlRequest<?> queryRequest, SparqlEndpoint repositoryInfo) {
        return this.invoke(queryRequest, repositoryInfo, ConnectionReusePolicies.noConnectionReuse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D> ExecutionResponse<D> invoke(SparqlRequest<?> queryRequest, SparqlEndpoint endpoint, ConnectionReusePolicy connectionReusePolicy) {
        Throwable executionError;
        Object exceptionMessage;
        ConnectionReusePolicy policy = ThreadLocalContextManager.wrap(connectionReusePolicy);
        SparqlConnection connection = null;
        try {
            connection = policy.acquireConnection(queryRequest.getRequestId(), this.connectionFactory, endpoint);
            connection.setShaclEnabled(queryRequest.isShaclEnabled());
            Object e = queryRequest.execute(connection);
            return e;
        }
        catch (DatatypeConversionException dce) {
            exceptionMessage = String.format("Could not execute query due to: %s: %s", SparqlQueryInvoker.getCause(dce), dce.getMessage());
            executionError = dce;
        }
        catch (HTTPQueryEvaluationException httpqee) {
            executionError = httpqee.getCause();
            exceptionMessage = this.handleQueryEvaluationError(queryRequest, executionError, httpqee);
        }
        catch (InterruptedQueryException iqe) {
            throw iqe;
        }
        catch (RuntimeException re) {
            RuntimeException ex = QueryInvocationExceptionMappers.map(re);
            SparqlQueryInvoker.logMaxTupleResultsError(ex, queryRequest);
            exceptionMessage = ex instanceof UnauthorizedException ? "Could not execute request due to missing or incorrect SPARQL authorization" : "Could not execute query due to: " + SparqlQueryInvoker.getCauseMessage(ex);
            executionError = ex;
        }
        finally {
            policy.releaseConnection(connection, queryRequest.getRequestId(), endpoint);
        }
        return ExecutionResponse.ofError((String)queryRequest.getRequestId(), (Throwable)new RuntimeException((String)exceptionMessage, executionError));
    }

    public <D> List<ExecutionResponse<D>> invoke(List<SparqlRequest> queries, SparqlEndpoint sparqlEndpoint) {
        if (queries.size() == 1) {
            return Collections.singletonList(this.invoke(queries.get(0), sparqlEndpoint));
        }
        ExecutionResponse[] results = new ExecutionResponse[queries.size()];
        ArrayList futures = new ArrayList(queries.size());
        for (int i = 0; i < queries.size(); ++i) {
            SparqlRequest query = queries.get(i);
            futures.add(this.executor.submit(this.createInvoker(query, sparqlEndpoint, results, i)));
        }
        SparqlQueryInvoker.waitForAll(futures);
        this.checkForExecutionFailures(futures);
        return Arrays.asList(results);
    }

    @NotNull
    private String handleQueryEvaluationError(SparqlRequest<?> queryRequest, Throwable executionError, HTTPQueryEvaluationException httpqee) {
        Object exceptionMessage;
        boolean knownError = true;
        if (httpqee.isCausedByMalformedQueryException()) {
            exceptionMessage = "Tried to execute malformed query";
        } else if (httpqee.getCause() instanceof UnauthorizedException) {
            exceptionMessage = "Could not execute request due to missing or incorrect SPARQL authorization";
        } else if (executionError.getMessage() != null && (executionError.getMessage().contains("403") || executionError.getMessage().contains("Forbidden"))) {
            exceptionMessage = "Could not execute request due to: insufficient permissions";
        } else if (httpqee.isCausedByRepositoryException()) {
            exceptionMessage = "Could not execute request due to: " + SparqlQueryInvoker.getCauseMessage(executionError);
        } else {
            knownError = false;
            exceptionMessage = "Could not execute request due to communication problems";
        }
        if (knownError) {
            LOGGER.error("{} for {}", exceptionMessage, queryRequest.getQuery());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to execute request {} due to:", queryRequest.getQuery(), (Object)httpqee);
            }
        } else {
            LOGGER.error("Failed to execute request {} due to:", queryRequest.getQuery(), (Object)httpqee);
        }
        return exceptionMessage;
    }

    private static void logMaxTupleResultsError(RuntimeException ex, SparqlRequest<?> queryRequest) {
        if (!(ex instanceof SerializableException)) {
            if (ex instanceof TupleQueryResultHandlerException && ex.getMessage() != null && ex.getMessage().contains("maxTupleResults")) {
                LOGGER.error("Failed to execute query '{}' due to: {}", queryRequest.getQuery(), (Object)ex.getMessage());
            } else {
                LOGGER.error("Failed to execute query '{}' due to:", queryRequest.getQuery(), (Object)ex);
            }
        }
    }

    public <R> R invokeRaw(SparqlEndpoint endpoint, ConnectionReusePolicy connectionPolicy, RawRequest<R> rawRequest) {
        return this.invokeRaw(UUID.randomUUID().toString(), endpoint, connectionPolicy, rawRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R invokeRaw(String requestId, SparqlEndpoint endpoint, ConnectionReusePolicy connectionPolicy, RawRequest<R> rawRequest) {
        ThreadLocalContextManager policy = new ThreadLocalContextManager(connectionPolicy);
        SparqlConnection connection = policy.acquireConnection(requestId, this.connectionFactory, endpoint);
        try {
            R r = rawRequest.execute(connection);
            return r;
        }
        finally {
            policy.releaseConnection(connection, requestId, endpoint);
        }
    }

    public List<Statement> fetchStatements(String requestId, SparqlEndpoint endpoint, ConnectionReusePolicy connectionReusePolicy, Resource subject, IRI predicate, Value object, Resource ... contexts) {
        return this.invokeRaw(requestId, endpoint, connectionReusePolicy, connection -> connection.fetchStatements(subject, predicate, object, contexts));
    }

    private static String getCause(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable.getClass().getName();
        }
        return SparqlQueryInvoker.getCause(throwable.getCause());
    }

    private static String getCauseMessage(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable.getMessage();
        }
        return SparqlQueryInvoker.getCauseMessage(throwable.getCause());
    }

    private QueryInvoker createInvoker(SparqlRequest query, SparqlEndpoint endpoint, ExecutionResponse[] results, int resultIndex) {
        String requestId = query.getRequestId();
        Consumer<ExecutionResponse> dataConsumer = responseData -> {
            results[resultIndex] = responseData;
        };
        Consumer<Throwable> errorConsumer = error -> {
            results[resultIndex] = new SparqlResponse(requestId, (Throwable)error);
        };
        return new QueryInvoker<ExecutionResponse>(this::invoke, query, endpoint, dataConsumer, errorConsumer);
    }

    public SparqlQueryInvoker setMaxConcurrentRequests(int concurrentRequests) {
        if (concurrentRequests <= 0) {
            throw new IllegalArgumentException("Cannot set concurrent execution with zero or negative value: " + concurrentRequests);
        }
        if (this.maxConcurrentRequests != concurrentRequests) {
            ExecutorService oldService = this.executor;
            this.executor = SparqlQueryInvoker.createExecutorService(concurrentRequests);
            this.maxConcurrentRequests = concurrentRequests;
            oldService.shutdown();
        }
        return this;
    }

    @Override
    public void close() {
        try {
            if (this.managedConnectionFactory) {
                this.connectionFactory.close();
            }
        }
        finally {
            this.executor.shutdownNow();
        }
    }

    private static void waitForAll(Collection<? extends Future<?>> futures) {
        LinkedList copy = new LinkedList(futures);
        while (!copy.isEmpty()) {
            SparqlQueryInvoker.sleepForAWhile();
            copy.removeIf(Future::isDone);
        }
    }

    private static void sleepForAWhile() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private void checkForExecutionFailures(List<Future<?>> futures) {
        QueryInvocationException invocationException = new QueryInvocationException((Serializable)((Object)"One or more parallel query executions completed with errors!"));
        boolean hasErrors = false;
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                hasErrors = true;
                invocationException.addSuppressed(ee.getCause());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (hasErrors) {
            throw invocationException;
        }
    }

    private static ExecutorService createExecutorService(int concurrencyLevel) {
        if (concurrencyLevel == Integer.MAX_VALUE) {
            return Executors.newCachedThreadPool();
        }
        return new ThreadPoolExecutor(0, concurrencyLevel, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static class ThreadLocalContextManager
    implements ConnectionReusePolicy {
        private final ConnectionReusePolicy delegate;
        private final SparqlEndpointRequestContext.State sparqlConfigState;
        private SparqlEndpointRequestContext.State previousSparqlConfigState;

        ThreadLocalContextManager(ConnectionReusePolicy delegate) {
            this.delegate = delegate;
            this.sparqlConfigState = SparqlEndpointRequestContext.getState();
        }

        static ConnectionReusePolicy wrap(ConnectionReusePolicy delegate) {
            if (delegate instanceof ThreadLocalContextManager) {
                return delegate;
            }
            return new ThreadLocalContextManager(delegate);
        }

        @Override
        public SparqlConnection acquireConnection(String requestId, SparqlConnectionFactory connectionFactory, SparqlEndpoint endpoint) {
            this.previousSparqlConfigState = SparqlEndpointRequestContext.setState(this.sparqlConfigState);
            return this.delegate.acquireConnection(requestId, connectionFactory, endpoint);
        }

        @Override
        public void releaseConnection(SparqlConnection connection, String requestId, SparqlEndpoint endpoint) {
            SparqlEndpointRequestContext.setState(this.previousSparqlConfigState);
            this.delegate.releaseConnection(connection, requestId, endpoint);
        }
    }

    private static class QueryInvoker<R>
    implements Runnable {
        private final BiFunction<SparqlRequest, SparqlEndpoint, R> invoker;
        private final SparqlRequest query;
        private final SparqlEndpoint repositoryInfo;
        private final Consumer<R> dataConsumer;
        private final Consumer<Throwable> errorConsumer;
        private final SparqlEndpointRequestContext.State sparqlConfigState;

        private QueryInvoker(BiFunction<SparqlRequest, SparqlEndpoint, R> invoker, SparqlRequest query, SparqlEndpoint repositoryInfo, Consumer<R> dataConsumer, Consumer<Throwable> errorConsumer) {
            this.invoker = invoker;
            this.query = query;
            this.repositoryInfo = repositoryInfo;
            this.dataConsumer = dataConsumer;
            this.errorConsumer = errorConsumer;
            this.sparqlConfigState = SparqlEndpointRequestContext.getState();
        }

        @Override
        public void run() {
            SparqlEndpointRequestContext.State previousSparqlConfigState = SparqlEndpointRequestContext.setState(this.sparqlConfigState);
            try {
                R data = this.invoker.apply(this.query, this.repositoryInfo);
                this.dataConsumer.accept(data);
            }
            catch (RuntimeException re) {
                this.errorConsumer.accept(re);
            }
            finally {
                SparqlEndpointRequestContext.setState(previousSparqlConfigState);
            }
        }
    }

    public static interface RawRequest<R> {
        public R execute(SparqlConnection var1);
    }
}

