/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.HealthResult;
import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlEndpoint;
import java.io.Closeable;
import java.util.Objects;
import org.eclipse.rdf4j.repository.Repository;
import org.jetbrains.annotations.NotNull;

public interface SparqlConnectionFactory
extends Closeable {
    public SparqlConnection getConnection(SparqlEndpoint var1);

    public Repository getRepository(SparqlEndpoint var1);

    default public void setRepositoryCreator(RepositoryCreator creator) {
    }

    @NotNull
    default public RepositoryCreator getRepositoryCreator() {
        return RepositoryCreator.DEFAULT;
    }

    default public void setExclusiveRepositoryCreator(String repository, RepositoryCreator customCreator) {
        if (customCreator != null) {
            RepositoryCreator originalCreator = this.getRepositoryCreator();
            this.setRepositoryCreator((repositoryManager, info) -> {
                if (Objects.equals(repository, info.getRepository())) {
                    return customCreator.createRepository(repositoryManager, info);
                }
                return originalCreator.createRepository(repositoryManager, info);
            });
        }
    }

    @Override
    public void close();

    default public void reload(SparqlEndpoint endpoint) {
    }

    default public HealthResult checkHealth(SparqlEndpoint endpoint) {
        return HealthResult.green((String)endpoint.getRepository());
    }
}

