/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.sparql.AskRequest;
import com.ontotext.sparql.BooleanResponse;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SparqlResponse;
import com.ontotext.sparql.TransactionControl;
import com.ontotext.sparql.UpdateRequest;
import com.ontotext.sparql.UpdateResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;

public interface SparqlConnection
extends AutoCloseable,
TransactionControl {
    public SparqlResponse executeConstruct(QueryRequest var1);

    public void executeConstruct(QueryRequest var1, RDFHandler var2);

    public SparqlResponse executeSelect(QueryRequest var1);

    public void executeSelect(QueryRequest var1, TupleQueryResultHandler var2);

    public UpdateResponse executeUpdate(UpdateRequest var1);

    public BooleanResponse executeAsk(AskRequest var1);

    public List<Statement> fetchStatements(Resource var1, IRI var2, Value var3, Resource ... var4);

    public Stream<Statement> stream(Resource var1, IRI var2, Value var3, Resource ... var4);

    default public boolean hasStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return !this.fetchStatements(subj, pred, obj, contexts).isEmpty();
    }

    public void removeStatements(Resource var1, IRI var2, Value var3, Resource ... var4);

    public void add(InputStream var1, String var2, RDFFormat var3, Resource ... var4) throws IOException;

    public void addStatement(Statement var1);

    default public void addStatements(Statement ... statements) {
        for (Statement statement : statements) {
            this.addStatement(statement);
        }
    }

    default public void addStatements(Iterable<Statement> statements) {
        for (Statement statement : statements) {
            this.addStatement(statement);
        }
    }

    public void removeStatement(Statement var1);

    public void dropGraphs(List<String> var1);

    default public boolean isShaclEnabled() {
        return true;
    }

    public List<Namespace> getNamespaces();

    public void setNamespace(String var1, String var2);

    public void setShaclEnabled(boolean var1);

    @Override
    public void close();
}

