/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.sparql.SparqlEndpoint;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RepositoryCreator {
    public static final RepositoryCreator DEFAULT = (repositoryManager, endpoint) -> {
        Logger logger = LoggerFactory.getLogger(RepositoryCreator.class);
        logger.info("Refreshing repositories information to check for repository: {}", (Object)endpoint.getRepository());
        repositoryManager.refresh();
        Repository repository = repositoryManager.getRepository(endpoint.getRepository());
        if (repository != null) {
            return repository;
        }
        logger.warn("Repository: {} at address: {} is not reachable!", (Object)endpoint.getRepository(), (Object)endpoint.getAddress());
        throw new PlatformConfigurationException("Repository does not exist!", ErrorCode.BAD_CONFIG_REPOSITORY_NOT_FOUND);
    };

    @Nullable
    public Repository createRepository(RepositoryManager var1, SparqlEndpoint var2);
}

