/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import java.util.Collection;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public class RemoteRepositoryImplConfig
implements RepositoryImplConfig {
    private static final String CONFIG_REPOSITORY = "http://www.openrdf.org/config/repository#";
    private static final IRI REPOSITORY_ID = Values.iri((String)"http://www.openrdf.org/config/repository#", (String)"repositoryID");
    private static final IRI REPOSITORY_IMPL = Values.iri((String)"http://www.openrdf.org/config/repository#", (String)"repositoryImpl");
    private static final IRI REPOSITORY_TYPE = Values.iri((String)"http://www.openrdf.org/config/repository#", (String)"repositoryType");
    private final String repositoryId;
    private Resource modelResource;
    private String type;
    private Model contextGraph;
    private String label = "";

    public RemoteRepositoryImplConfig(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public static RepositoryConfig create(Model model, String repositoryId) {
        RemoteRepositoryImplConfig implConfig = new RemoteRepositoryImplConfig(repositoryId);
        implConfig.parse(model, null);
        RepositoryConfig config = new RepositoryConfig(repositoryId);
        config.setTitle(implConfig.label);
        config.setRepositoryImplConfig((RepositoryImplConfig)implConfig);
        return config;
    }

    public String getType() {
        this.validate();
        return this.type;
    }

    public void validate() {
        if (this.type == null) {
            throw new RepositoryConfigException("Model not parsed");
        }
    }

    public Resource export(Model model) {
        model.addAll((Collection)this.contextGraph);
        return this.modelResource;
    }

    public void parse(Model model, Resource resource) {
        try {
            Statement idStatement = RemoteRepositoryImplConfig.getIdStatement(model, this.repositoryId);
            if (idStatement == null) {
                throw new RepositoryConfigException("Invalid repository config");
            }
            Resource repositoryNode = idStatement.getSubject();
            Resource context = idStatement.getContext();
            Models.objectLiteral((Iterable)model.getStatements(repositoryNode, RDFS.LABEL, null, new Resource[0])).ifPresent(literal -> {
                this.label = literal.getLabel();
            });
            this.contextGraph = model.filter(null, null, null, new Resource[]{context});
            this.modelResource = (Resource)Models.objectResource((Iterable)this.contextGraph.getStatements(repositoryNode, CONFIG.Rep.impl, null, new Resource[0])).or(() -> Models.objectResource((Iterable)this.contextGraph.getStatements(repositoryNode, REPOSITORY_IMPL, null, new Resource[0]))).orElseThrow(() -> new RepositoryConfigException("No repository implementation!"));
            this.contextGraph.remove(repositoryNode, null, null, new Resource[0]);
            this.type = ((Literal)Models.objectLiteral((Iterable)this.contextGraph.getStatements(this.modelResource, CONFIG.Rep.type, null, new Resource[0])).or(() -> Models.objectLiteral((Iterable)this.contextGraph.getStatements(this.modelResource, REPOSITORY_TYPE, null, new Resource[0]))).orElseThrow(() -> new RepositoryConfigException("No repository type!"))).getLabel();
        }
        catch (ModelException me) {
            throw new RepositoryConfigException(me.getMessage(), (Throwable)me);
        }
    }

    private static Statement getIdStatement(Model model, String repositoryId) {
        Literal idLiteral = SimpleValueFactory.getInstance().createLiteral(repositoryId);
        Model idStatementList = model.filter(null, CONFIG.Rep.id, (Value)idLiteral, new Resource[0]);
        if (idStatementList.isEmpty()) {
            idStatementList = model.filter(null, REPOSITORY_ID, (Value)idLiteral, new Resource[0]);
        }
        if (idStatementList.size() == 1) {
            return (Statement)idStatementList.iterator().next();
        }
        if (idStatementList.isEmpty()) {
            return null;
        }
        throw new RepositoryConfigException("Multiple ID-statements for repository ID " + repositoryId);
    }
}

