/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.rdf.LiteralValue;
import com.ontotext.soaas.common.rdf.ValueReader;
import com.ontotext.sparql.DatatypeConversionException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class Rdf4jValueConverter
implements ValueReader {
    public static final Rdf4jValueConverter INSTANCE = new Rdf4jValueConverter();
    private static final TimeZone Z_TIME_ZONE = TimeZone.getTimeZone(ZoneId.of("Z"));
    private static Map<IRI, Function<Literal, Serializable>> valueTransformers = new HashMap<IRI, Function<Literal, Serializable>>(64);
    private static final Pattern LOCAL_DATE = Pattern.compile("(\\+\\d+|-\\d*)?\\d{4}-\\d{2}-\\d{2}");
    private static final Pattern LOCAL_TIME = Pattern.compile("\\d{1,2}:\\d{2}:\\d{2}(?:\\.\\d{1,9})?");
    private static final Pattern LOCAL_DATETIME = Pattern.compile(LOCAL_DATE.pattern() + "T" + LOCAL_TIME.pattern());
    private static final Pattern OFFSET_DATETIME = Pattern.compile(LOCAL_DATETIME.pattern() + "(Z|[-+]\\d{2}:\\d{2})");

    private static Function<Literal, Serializable> getBooleanValue() {
        return literal -> {
            try {
                return Boolean.valueOf(literal.booleanValue());
            }
            catch (IllegalArgumentException nfe) {
                return literal.getLabel();
            }
        };
    }

    private static Function<Literal, Serializable> toNumberOrString(Function<Literal, Number> numberFunction) {
        return literal -> {
            try {
                return (Serializable)numberFunction.apply((Literal)literal);
            }
            catch (IllegalArgumentException nfe) {
                return literal.getLabel();
            }
        };
    }

    private static Function<Literal, Serializable> langStringToMap() {
        return literal -> {
            String value = literal.getLabel();
            String type = literal.getDatatype().stringValue();
            String lang = literal.getLanguage().orElse(null);
            return new LiteralValue((Serializable)((Object)value), type, lang);
        };
    }

    private static Function<Literal, Serializable> getLiteralTime() {
        return literal -> {
            try {
                if (LOCAL_TIME.matcher(literal.getLabel()).matches()) {
                    return LocalTime.parse(literal.getLabel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Rdf4jValueConverter.getLiteralCalendar().apply((Literal)literal);
        };
    }

    private static Function<Literal, Serializable> getLiteralDate() {
        return literal -> {
            try {
                if (LOCAL_DATE.matcher(literal.getLabel()).matches()) {
                    return LocalDate.parse(literal.getLabel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Rdf4jValueConverter.getLiteralCalendar().apply((Literal)literal);
        };
    }

    private static Function<Literal, Serializable> getLiteralDateTime() {
        return literal -> {
            try {
                if (LOCAL_DATETIME.matcher(literal.getLabel()).matches()) {
                    return LocalDateTime.parse(literal.getLabel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Rdf4jValueConverter.getLiteralDateTimeStamp().apply((Literal)literal);
        };
    }

    private static Function<Literal, Serializable> getLiteralDateTimeStamp() {
        return literal -> {
            try {
                if (OFFSET_DATETIME.matcher(literal.getLabel()).matches()) {
                    return OffsetDateTime.parse(literal.getLabel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Rdf4jValueConverter.getLiteralCalendar().apply((Literal)literal);
        };
    }

    private static Function<Literal, Serializable> getLiteralCalendar() {
        return literal -> {
            try {
                XMLGregorianCalendar calendar = literal.calendarValue();
                int timezone = calendar.getTimezone();
                TimeZone timeZone = null;
                if (Integer.MIN_VALUE == timezone) {
                    timeZone = Z_TIME_ZONE;
                }
                return calendar.toGregorianCalendar(timeZone, null, null);
            }
            catch (IllegalArgumentException re) {
                return literal.getLabel();
            }
        };
    }

    public static Serializable convert(Value value) {
        Object result;
        if (value instanceof IRI || value instanceof Triple) {
            return value.stringValue();
        }
        if (value instanceof BNode) {
            return value.toString();
        }
        if (value instanceof Literal) {
            Literal literalValue = (Literal)value;
            Function<Literal, Serializable> trasformer = valueTransformers.get(literalValue.getDatatype());
            if (trasformer != null) {
                try {
                    result = trasformer.apply(literalValue);
                }
                catch (ArithmeticException | IllegalArgumentException iaEx) {
                    throw new DatatypeConversionException("Value " + String.valueOf(literalValue) + " is not in a valid format for " + String.valueOf(literalValue.getDatatype()));
                }
            } else {
                result = literalValue.stringValue();
            }
        } else {
            throw Rdf4jValueConverter.newUnknownDataType(value);
        }
        return result;
    }

    public static <E extends Enum<?>> E readEnum(Value value, Function<String, E> enumConverter) {
        String converted = Rdf4jValueConverter.convert(value).toString();
        return (E)((Enum)enumConverter.apply(converted));
    }

    public static String convertAsString(Value value) {
        return Rdf4jValueConverter.convert(value).toString();
    }

    public static Number convertAsNumber(Value value) {
        return (Number)Rdf4jValueConverter.convert(value);
    }

    public static Date convertAsDate(Value value) {
        Serializable convertedValue = Rdf4jValueConverter.convert(value);
        if (convertedValue instanceof GregorianCalendar) {
            return ((GregorianCalendar)convertedValue).getTime();
        }
        if (convertedValue instanceof LocalDateTime) {
            return new Date(((LocalDateTime)convertedValue).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (convertedValue instanceof OffsetDateTime) {
            return new Date(((OffsetDateTime)convertedValue).toInstant().toEpochMilli());
        }
        throw new DatatypeConversionException(String.format("Value %s is not valid for %s, %s or %s", value, GregorianCalendar.class.getName(), LocalDateTime.class.getName(), OffsetDateTime.class.getName()));
    }

    public Object read(Object object) {
        if (object instanceof Value) {
            return Rdf4jValueConverter.convert((Value)object);
        }
        return object;
    }

    public LiteralValue readAsLiteral(Object object) {
        String value;
        String type = null;
        String lang = null;
        if (object instanceof BNode || object instanceof String) {
            value = object.toString();
        } else if (object instanceof IRI) {
            value = ((IRI)object).stringValue();
        } else if (object instanceof Triple) {
            value = ((Triple)object).stringValue();
        } else if (object instanceof Literal) {
            value = ((Literal)object).getLabel();
            type = ((Literal)object).getDatatype().stringValue();
            lang = ((Literal)object).getLanguage().orElse(null);
        } else {
            throw Rdf4jValueConverter.newUnknownDataType(object);
        }
        return new LiteralValue((Serializable)((Object)value), type, lang);
    }

    private static IllegalArgumentException newUnknownDataType(Object object) {
        return new IllegalArgumentException("Unknown data type definition: " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ")");
    }

    static {
        valueTransformers.put(XSD.BOOLEAN, Rdf4jValueConverter.getBooleanValue());
        valueTransformers.put(XSD.TIME, Rdf4jValueConverter.getLiteralTime());
        valueTransformers.put(XSD.DATE, Rdf4jValueConverter.getLiteralDate());
        valueTransformers.put(XSD.DATETIME, Rdf4jValueConverter.getLiteralDateTime());
        valueTransformers.put(XSD.DATETIMESTAMP, Rdf4jValueConverter.getLiteralDateTimeStamp());
        valueTransformers.put(XSD.GYEAR, Rdf4jValueConverter.getLiteralCalendar());
        valueTransformers.put(XSD.GYEARMONTH, Rdf4jValueConverter.getLiteralCalendar());
        valueTransformers.put(XSD.BYTE, Rdf4jValueConverter.toNumberOrString(Literal::byteValue));
        valueTransformers.put(XSD.INT, Rdf4jValueConverter.toNumberOrString(Literal::intValue));
        valueTransformers.put(XSD.LONG, Rdf4jValueConverter.toNumberOrString(Literal::longValue));
        valueTransformers.put(XSD.SHORT, Rdf4jValueConverter.toNumberOrString(Literal::shortValue));
        valueTransformers.put(XSD.INTEGER, Rdf4jValueConverter.toNumberOrString(Literal::integerValue));
        valueTransformers.put(XSD.FLOAT, Rdf4jValueConverter.toNumberOrString(Literal::floatValue));
        valueTransformers.put(XSD.DOUBLE, Rdf4jValueConverter.toNumberOrString(Literal::doubleValue));
        valueTransformers.put(XSD.DECIMAL, Rdf4jValueConverter.toNumberOrString(Literal::decimalValue));
        valueTransformers.put(XSD.UNSIGNED_BYTE, Rdf4jValueConverter.toNumberOrString(Literal::intValue));
        valueTransformers.put(XSD.UNSIGNED_SHORT, Rdf4jValueConverter.toNumberOrString(Literal::intValue));
        valueTransformers.put(XSD.UNSIGNED_INT, Rdf4jValueConverter.toNumberOrString(Literal::longValue));
        valueTransformers.put(XSD.UNSIGNED_LONG, Rdf4jValueConverter.toNumberOrString(Literal::integerValue));
        valueTransformers.put(XSD.POSITIVE_INTEGER, Rdf4jValueConverter.toNumberOrString(Literal::integerValue));
        valueTransformers.put(XSD.NON_POSITIVE_INTEGER, Rdf4jValueConverter.toNumberOrString(Literal::integerValue));
        valueTransformers.put(XSD.NEGATIVE_INTEGER, Rdf4jValueConverter.toNumberOrString(Literal::integerValue));
        valueTransformers.put(XSD.NON_NEGATIVE_INTEGER, Rdf4jValueConverter.toNumberOrString(Literal::integerValue));
        valueTransformers.put(XSD.DURATION, Value::stringValue);
        valueTransformers.put(XSD.DAYTIMEDURATION, Value::stringValue);
        valueTransformers.put(XSD.YEARMONTHDURATION, Value::stringValue);
        valueTransformers.put(XSD.STRING, Value::stringValue);
        valueTransformers.put(RDF.LANGSTRING, Rdf4jValueConverter.langStringToMap());
        valueTransformers.put(null, Value::stringValue);
    }
}

