/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.AskRequest;
import com.ontotext.sparql.BooleanResponse;
import com.ontotext.sparql.LimitedDataHandler;
import com.ontotext.sparql.LimitedResultHandler;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.RdfDataTupleResultHandler;
import com.ontotext.sparql.RdfHandlerToRdfData;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.SparqlResponse;
import com.ontotext.sparql.UpdateRequest;
import com.ontotext.sparql.UpdateResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.slf4j.Logger;

class Rdf4jSparqlConnection
implements SparqlConnection {
    private static final Logger QUERY_LOGGER = Loggers.sparqlQueryLogger();
    private static final Logger UPDATE_LOGGER = Loggers.sparqlUpdateLogger();
    private static final Logger DURATION_LOG = Loggers.sparqlQueryDurationsLogger();
    private final ValueFactory vf = SimpleValueFactory.getInstance();
    private final RepositoryConnection connection;
    private final SparqlEndpoint endpoint;
    private boolean interpolateTupleResults = true;
    private boolean shaclEnabled;
    private boolean enableCartesianProtection;

    Rdf4jSparqlConnection(RepositoryConnection connection) {
        this(connection, null);
    }

    Rdf4jSparqlConnection(RepositoryConnection connection, SparqlEndpoint endpoint) {
        this.connection = Objects.requireNonNull(connection, "RepositoryConnection is required!");
        this.endpoint = endpoint;
    }

    @Override
    public void begin() {
        this.begin(null);
    }

    @Override
    public void begin(String isolationLevel) {
        ShaclSail.TransactionSettings.ValidationApproach approach = this.shaclEnabled ? ShaclSail.TransactionSettings.ValidationApproach.Auto : ShaclSail.TransactionSettings.ValidationApproach.Disabled;
        if (this.shaclEnabled) {
            this.connection.begin(new TransactionSetting[]{approach, IsolationLevels.READ_COMMITTED});
        } else if (isolationLevel == null) {
            this.connection.begin(new TransactionSetting[]{approach});
        } else {
            IsolationLevels level = IsolationLevels.valueOf((String)isolationLevel);
            this.connection.begin(new TransactionSetting[]{approach, level});
        }
    }

    @Override
    public void commit() {
        this.connection.commit();
    }

    @Override
    public void rollback() {
        this.connection.rollback();
    }

    @Override
    public boolean isTxActive() {
        return this.connection.isActive();
    }

    @Override
    public SparqlResponse executeConstruct(QueryRequest queryRequest) {
        LogInfo logInfo = this.logRequest(queryRequest, QUERY_LOGGER);
        try {
            GraphQuery graphQuery = this.connection.prepareGraphQuery(queryRequest.getQuery());
            Rdf4jSparqlConnection.configureOperation(queryRequest, (Operation)graphQuery);
            RdfHandlerToRdfData dataConsumer = new RdfHandlerToRdfData();
            LimitedDataHandler limitedDataHandler = new LimitedDataHandler((RDFHandler)dataConsumer, queryRequest.getLimit());
            graphQuery.evaluate(TimeTrackingRdfHandler.track(limitedDataHandler, logInfo));
            SparqlResponse sparqlResponse = new SparqlResponse(queryRequest.getRequestId(), dataConsumer.getRdfData().toTree());
            return sparqlResponse;
        }
        catch (RuntimeException re) {
            this.logRequestIfNeeded(queryRequest, QUERY_LOGGER);
            throw re;
        }
        finally {
            Rdf4jSparqlConnection.cleanAfterOperation();
            logInfo.logRequestEnd();
        }
    }

    @Override
    public void executeConstruct(QueryRequest queryRequest, RDFHandler handler) {
        LogInfo logInfo = this.logRequest(queryRequest, QUERY_LOGGER);
        try {
            GraphQuery graphQuery = this.connection.prepareGraphQuery(queryRequest.getQuery());
            Rdf4jSparqlConnection.configureOperation(queryRequest, (Operation)graphQuery);
            graphQuery.evaluate(TimeTrackingRdfHandler.track(handler, logInfo));
        }
        catch (RuntimeException re) {
            this.logRequestIfNeeded(queryRequest, QUERY_LOGGER);
            throw re;
        }
        finally {
            Rdf4jSparqlConnection.cleanAfterOperation();
            logInfo.logRequestEnd();
        }
    }

    @Override
    public SparqlResponse executeSelect(QueryRequest queryRequest) {
        LogInfo logInfo = this.logRequest(queryRequest, QUERY_LOGGER);
        Optional<SparqlEndpoint.ExecutionMode> queryMode = SparqlEndpointRequestContext.getQueryMode();
        if (queryRequest.isSparqlPlanRequest()) {
            queryMode.filter(Predicate.isEqual((Object)SparqlEndpoint.ExecutionMode.SUBQUERY)).ifPresent(mode -> SparqlEndpointRequestContext.setQueryMode(SparqlEndpoint.ExecutionMode.SPLIT));
        }
        try {
            TupleQuery tupleQuery = this.connection.prepareTupleQuery(queryRequest.getQuery());
            Rdf4jSparqlConnection.configureOperation(queryRequest, (Operation)tupleQuery);
            RdfDataTupleResultHandler tupleResultHandler = new RdfDataTupleResultHandler(queryRequest.getSomlSchema(), queryRequest.getBindings(), this.isInterpolateTupleResults());
            tupleResultHandler.setEnableCartesianProtection(this.enableCartesianProtection);
            LimitedResultHandler limitedResultHandler = new LimitedResultHandler((TupleQueryResultHandler)tupleResultHandler, queryRequest.getLimit());
            tupleQuery.evaluate(TimeTrackingTupleQueryResultHandler.track(limitedResultHandler, logInfo));
            SparqlResponse sparqlResponse = new SparqlResponse(queryRequest.getRequestId(), tupleResultHandler.getRdfTree());
            return sparqlResponse;
        }
        catch (RuntimeException re) {
            this.logRequestIfNeeded(queryRequest, QUERY_LOGGER);
            throw re;
        }
        finally {
            Rdf4jSparqlConnection.cleanAfterOperation();
            queryMode.ifPresent(SparqlEndpointRequestContext::setQueryMode);
            logInfo.logRequestEnd();
        }
    }

    @Override
    public void executeSelect(QueryRequest queryRequest, TupleQueryResultHandler resultHandler) {
        LogInfo logInfo = this.logRequest(queryRequest, QUERY_LOGGER);
        try {
            TupleQuery tupleQuery = this.connection.prepareTupleQuery(queryRequest.getQuery());
            Rdf4jSparqlConnection.configureOperation(queryRequest, (Operation)tupleQuery);
            tupleQuery.evaluate(TimeTrackingTupleQueryResultHandler.track(resultHandler, logInfo));
        }
        catch (RuntimeException re) {
            this.logRequestIfNeeded(queryRequest, QUERY_LOGGER);
            throw re;
        }
        finally {
            Rdf4jSparqlConnection.cleanAfterOperation();
            logInfo.logRequestEnd();
        }
    }

    @Override
    public UpdateResponse executeUpdate(UpdateRequest updateRequest) {
        LogInfo logInfo = this.logRequest(updateRequest, UPDATE_LOGGER);
        try {
            if (!this.connection.isActive()) {
                this.connection.setIsolationLevel((IsolationLevel)IsolationLevels.READ_COMMITTED);
            }
            Update update = this.connection.prepareUpdate(updateRequest.getQuery());
            Rdf4jSparqlConnection.configureOperation(updateRequest, (Operation)update);
            update.execute();
            UpdateResponse updateResponse = new UpdateResponse(updateRequest.getRequestId(), null, null);
            return updateResponse;
        }
        catch (RuntimeException re) {
            this.logRequestIfNeeded(updateRequest, UPDATE_LOGGER);
            throw re;
        }
        finally {
            Rdf4jSparqlConnection.cleanAfterOperation();
            logInfo.logRequestEnd();
        }
    }

    @Override
    public BooleanResponse executeAsk(AskRequest askRequest) {
        LogInfo logInfo = this.logRequest(askRequest, QUERY_LOGGER);
        Optional<SparqlEndpoint.ExecutionMode> queryMode = SparqlEndpointRequestContext.getQueryMode();
        try {
            queryMode.filter(Predicate.isEqual((Object)SparqlEndpoint.ExecutionMode.SUBQUERY)).ifPresent(mode -> SparqlEndpointRequestContext.clearQueryMode());
            BooleanQuery booleanQuery = this.connection.prepareBooleanQuery(askRequest.getQuery());
            Rdf4jSparqlConnection.configureOperation(askRequest, (Operation)booleanQuery);
            boolean result = booleanQuery.evaluate();
            BooleanResponse booleanResponse = new BooleanResponse(askRequest.getRequestId(), result);
            return booleanResponse;
        }
        catch (RuntimeException re) {
            this.logRequestIfNeeded(askRequest, QUERY_LOGGER);
            throw re;
        }
        finally {
            Rdf4jSparqlConnection.cleanAfterOperation();
            queryMode.ifPresent(SparqlEndpointRequestContext::setQueryMode);
            logInfo.logRequestEnd();
        }
    }

    @Override
    public List<Statement> fetchStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return Iterations.asList((CloseableIteration)this.connection.getStatements(subj, pred, obj, contexts));
    }

    @Override
    public Stream<Statement> stream(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return Iterations.stream((CloseableIteration)this.connection.getStatements(subj, pred, obj, contexts));
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.connection.hasStatement(subj, pred, obj, true, contexts);
    }

    @Override
    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.connection.remove(subj, pred, obj, contexts);
    }

    @Override
    public void add(InputStream inputStream, String baseUri, RDFFormat rdfFormat, Resource ... contexts) throws IOException {
        this.connection.add(inputStream, baseUri, rdfFormat, contexts);
    }

    @Override
    public void addStatement(Statement statement) {
        this.connection.add(statement, new Resource[0]);
    }

    @Override
    public void addStatements(Iterable<Statement> statements) {
        this.connection.add(statements, new Resource[0]);
    }

    @Override
    public void removeStatement(Statement statement) {
        this.connection.remove(statement, new Resource[0]);
    }

    @Override
    public void dropGraphs(List<String> graphs) {
        if (graphs.isEmpty()) {
            return;
        }
        Resource[] resources = (Resource[])graphs.stream().map(arg_0 -> ((ValueFactory)this.vf).createIRI(arg_0)).toArray(Resource[]::new);
        this.connection.clear(resources);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public List<Namespace> getNamespaces() {
        return this.connection.getNamespaces().stream().toList();
    }

    @Override
    public void setNamespace(String prefix, String namespace) {
        this.connection.setNamespace(prefix, namespace);
    }

    public boolean isInterpolateTupleResults() {
        return this.interpolateTupleResults;
    }

    public void setInterpolateTupleResults(boolean interpolateTupleResults) {
        this.interpolateTupleResults = interpolateTupleResults;
    }

    @Override
    public void setShaclEnabled(boolean isShaclEnabled) {
        this.shaclEnabled = isShaclEnabled;
    }

    @Override
    public boolean isShaclEnabled() {
        return this.shaclEnabled;
    }

    public void setEnableCartesianProtection(boolean enableCartesianProtection) {
        this.enableCartesianProtection = enableCartesianProtection;
    }

    private static void configureOperation(SparqlRequest<?> request, Operation operation) {
        Boolean includeInferred = request.isIncludeInferred();
        if (includeInferred != null) {
            operation.setIncludeInferred(includeInferred.booleanValue());
        }
        Boolean expandOverSameAs = request.isExpandOverSameAs();
        SparqlEndpointRequestContext.setExpandOverSameAs(expandOverSameAs);
    }

    private static void cleanAfterOperation() {
        SparqlEndpointRequestContext.clearExpandOverSameAs();
    }

    private LogInfo logRequest(SparqlRequest<?> request, Logger logger) {
        if (request.logRequest()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Repository: {}, Request-ID: {}, Inferred: {}, owl:sameAs: {}\n{}", new Object[]{this.getRepository(), request.getRequestId(), request.isIncludeInferred(), request.isExpandOverSameAs(), request.getPrettyQuery()});
            } else {
                logger.info("Repository: {}, Request-ID: {} - {}", new Object[]{this.getRepository(), request.getRequestId(), request.getQuery()});
            }
            if (DURATION_LOG.isDebugEnabled()) {
                return new LogInfoImpl(request, this.getRepository());
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("Repository: {}, Request-ID: {}, Inferred: {}, owl:sameAs: {}\n{}", new Object[]{this.getRepository(), request.getRequestId(), request.isIncludeInferred(), request.isExpandOverSameAs(), request.getPrettyQuery()});
            if (DURATION_LOG.isDebugEnabled()) {
                return new LogInfoImpl(request, this.getRepository());
            }
        }
        if (DURATION_LOG.isTraceEnabled()) {
            return new LogInfoImpl(request, this.getRepository());
        }
        return NoOpLogInfo.INSTANCE;
    }

    private void logRequestIfNeeded(SparqlRequest<?> request, Logger logger) {
        if (!request.logRequest()) {
            logger.warn("Failed to execute in Repository: {}, Request-ID: {} : {}", new Object[]{this.getRepository(), request.getRequestId(), request.getQuery()});
        }
    }

    private String getRepository() {
        if (this.endpoint == null) {
            return SparqlEndpointRequestContext.getRepository();
        }
        return this.endpoint.getRepository();
    }

    private static interface LogInfo {
        public void logOnFirstResponseFromServer();

        public void onNewResult();

        public void logRequestEnd();
    }

    private static class TimeTrackingRdfHandler
    implements RDFHandler {
        private final RDFHandler delegate;
        private final LogInfo logInfo;

        TimeTrackingRdfHandler(RDFHandler delegate, LogInfo logInfo) {
            this.delegate = delegate;
            this.logInfo = logInfo;
        }

        static RDFHandler track(RDFHandler delegate, LogInfo logInfo) {
            if (logInfo != NoOpLogInfo.INSTANCE) {
                return new TimeTrackingRdfHandler(delegate, logInfo);
            }
            return delegate;
        }

        public void startRDF() {
            this.logInfo.logOnFirstResponseFromServer();
            this.delegate.startRDF();
        }

        public void endRDF() {
            this.delegate.endRDF();
        }

        public void handleNamespace(String prefix, String uri) {
            this.logInfo.onNewResult();
            this.delegate.handleNamespace(prefix, uri);
        }

        public void handleStatement(Statement statement) {
            this.logInfo.onNewResult();
            this.delegate.handleStatement(statement);
        }

        public void handleComment(String comment) {
            this.delegate.handleComment(comment);
        }
    }

    private static class TimeTrackingTupleQueryResultHandler
    implements TupleQueryResultHandler {
        private final TupleQueryResultHandler delegate;
        private final LogInfo logInfo;

        TimeTrackingTupleQueryResultHandler(TupleQueryResultHandler delegate, LogInfo logInfo) {
            this.delegate = delegate;
            this.logInfo = logInfo;
        }

        static TupleQueryResultHandler track(TupleQueryResultHandler delegate, LogInfo logInfo) {
            if (logInfo != NoOpLogInfo.INSTANCE) {
                return new TimeTrackingTupleQueryResultHandler(delegate, logInfo);
            }
            return delegate;
        }

        public void startQueryResult(List<String> bindingNames) {
            this.logInfo.logOnFirstResponseFromServer();
            this.delegate.startQueryResult(bindingNames);
        }

        public void handleSolution(BindingSet bindingSet) {
            this.logInfo.onNewResult();
            this.delegate.handleSolution(bindingSet);
        }

        public void handleBoolean(boolean value) {
            this.logInfo.onNewResult();
            this.delegate.handleBoolean(value);
        }

        public void handleLinks(List<String> linkUrls) {
            this.logInfo.onNewResult();
            this.delegate.handleLinks(linkUrls);
        }

        public void endQueryResult() {
            this.delegate.endQueryResult();
        }
    }

    private static class LogInfoImpl
    implements LogInfo {
        private final Timer timer = Timer.start();
        private final String requestId;
        private final String repository;
        private long timeForFirstResult;
        private long processedRows;

        LogInfoImpl(SparqlRequest<?> queryRequest, String repository) {
            this.requestId = queryRequest.getRequestId();
            this.repository = repository;
        }

        @Override
        public void logOnFirstResponseFromServer() {
            this.timeForFirstResult = this.timer.getDuration();
            DURATION_LOG.trace("Got first results for Request-ID: {} to Repository: {} in {} ms", new Object[]{this.requestId, this.repository, this.timeForFirstResult});
        }

        @Override
        public void onNewResult() {
            ++this.processedRows;
        }

        @Override
        public void logRequestEnd() {
            long totalTime = this.timer.getDuration();
            DURATION_LOG.debug("Query evaluation with Request-ID: {} to Repository: {} took {} ms, response processing took {} ms with total query duration of {} ms and processing of {} rows", new Object[]{this.requestId, this.repository, this.timeForFirstResult, totalTime - this.timeForFirstResult, totalTime, this.processedRows});
        }
    }

    private static class NoOpLogInfo
    implements LogInfo {
        private static final LogInfo INSTANCE = new NoOpLogInfo();

        private NoOpLogInfo() {
        }

        @Override
        public void logOnFirstResponseFromServer() {
        }

        @Override
        public void onNewResult() {
        }

        @Override
        public void logRequestEnd() {
        }
    }
}

