/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.EnumValueDef;
import com.ontotext.models.Prefixes;
import com.ontotext.models.ScalarType;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.ValueConversionException;
import com.ontotext.soaas.common.CollectionsUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.ValidatingValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.jetbrains.annotations.NotNull;

public class Rdf4jInputValueConverter
implements InputValueConverter {
    private static final String INVALID_MODEL = "Invalid model";
    private static final DateTimeFormatter ISO_DATE_TIME_STAMP_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HH:MM", "Z").toFormatter();
    private static final Map<String, BiFunction<Object, ValueFactory, Object>> CONVERTERS = new HashMap<String, BiFunction<Object, ValueFactory, Object>>();
    private static final DatatypeFactory datatypeFactory;
    private static final String OLD_RDF_RESOURCE = "rdf:Resource";
    private final ValueFactory vvf;

    private static BiFunction<Object, ValueFactory, Object> toDateTimeStamp() {
        return (value, vf) -> {
            String valueString = null;
            if (value instanceof String) {
                try {
                    TemporalAccessor temporal = ISO_DATE_TIME_STAMP_FORMAT.parse(value.toString());
                    Rdf4jInputValueConverter.verifyTimeZoneIsSupported(value, temporal);
                    valueString = ISO_DATE_TIME_STAMP_FORMAT.format(temporal);
                }
                catch (DateTimeParseException dpe) {
                    throw new ValueConversionException(String.format("Invalid %s value: %s", XSD.DATETIMESTAMP, dpe.getMessage()), (Throwable)dpe);
                }
            } else if (value instanceof TemporalAccessor) {
                TemporalAccessor temporal = (TemporalAccessor)value;
                Rdf4jInputValueConverter.verifyTimeZoneIsSupported(value, temporal);
                valueString = ISO_DATE_TIME_STAMP_FORMAT.format(temporal);
            }
            if (valueString != null) {
                return vf.createLiteral(valueString, XSD.DATETIMESTAMP);
            }
            if (value instanceof Date) {
                throw new ValueConversionException(String.format("Timezone is required for %s, got %s(%s)", XSD.DATETIMESTAMP, value, value.getClass()));
            }
            throw new ValueConversionException(String.format("Cannot convert value %s(%s) to %s", value, value.getClass(), XSD.DATETIMESTAMP));
        };
    }

    private static void verifyTimeZoneIsSupported(Object value, TemporalAccessor temporal) {
        try {
            temporal.get(ChronoField.OFFSET_SECONDS);
        }
        catch (UnsupportedTemporalTypeException utte) {
            throw new ValueConversionException(String.format("The %s type requires a timezone offset, got '%s'", XSD.DATETIMESTAMP, value), (Throwable)utte);
        }
    }

    public Rdf4jInputValueConverter() {
        this(true);
    }

    public Rdf4jInputValueConverter(boolean enableValidation) {
        this.vvf = enableValidation ? new ValidatingValueFactory((ValueFactory)SimpleValueFactory.getInstance()) : SimpleValueFactory.getInstance();
    }

    public Object convert(Object value, ScalarType expectedType) {
        if (value == null) {
            return null;
        }
        if (expectedType.isUnionType()) {
            return this.convertUnionValues(value, expectedType);
        }
        if (expectedType.isEnum()) {
            value = this.resolveEnumValue(value, expectedType);
        }
        try {
            return this.convertValues(value, expectedType);
        }
        catch (ValueConversionException vce) {
            if (expectedType.isEnum() && INVALID_MODEL.equals(vce.getMessage())) {
                throw new ValueConversionException("The enum type " + expectedType.getName() + " uses RDF type " + expectedType.getRdf() + " that is not supported. Use 'rdfs:Resource', 'xsd:string' or other supported type", (Throwable)vce);
            }
            throw vce;
        }
    }

    private Object resolveEnumValue(Object value, ScalarType expectedType) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(item -> this.resolveEnumValue(item, expectedType)).toList();
        }
        return expectedType.getValues().stream().filter(enumValueDef -> enumValueDef.getName().equals(value)).map(EnumValueDef::getValue).findFirst().orElseThrow(Rdf4jInputValueConverter.unknownEnumValue(value, expectedType));
    }

    @NotNull
    private static Supplier<ValueConversionException> unknownEnumValue(Object value, ScalarType expectedType) {
        return () -> new ValueConversionException(String.format("Unknown enum value %s from the enum %s", value, expectedType.getGraphql()));
    }

    private Object convertUnionValues(Object value, ScalarType expectedType) {
        if (value instanceof Collection) {
            return this.convertUnionCollection(value, expectedType);
        }
        for (ScalarType unionType : expectedType.getUnionTypes()) {
            Object convertedValue = this.tryConvertValue(value, unionType);
            if (convertedValue == null) continue;
            return convertedValue;
        }
        throw new ValueConversionException(String.format("Value %s does not match any of the union types: %s", value, expectedType.getUnion()));
    }

    private List<Object> convertUnionCollection(Object value, ScalarType expectedType) {
        ArrayList<Object> resultList = new ArrayList<Object>(((Collection)value).size());
        ArrayList failed = new ArrayList();
        for (Object element : (Collection)value) {
            boolean convertedSuccessfully = false;
            for (ScalarType unionType : expectedType.getUnionTypes()) {
                Object convertedValue = this.tryConvertValue(element, unionType);
                if (!CollectionsUtil.addIfNotNull(resultList, (Object)convertedValue)) continue;
                convertedSuccessfully = true;
                break;
            }
            if (element == null || convertedSuccessfully) continue;
            failed.add(element);
        }
        if (!failed.isEmpty()) {
            throw new ValueConversionException(String.format("Values %s do not match any of the union types: %s", failed, expectedType.getUnion()));
        }
        return resultList;
    }

    private Object tryConvertValue(Object value, ScalarType unionType) {
        if (value == null) {
            return null;
        }
        BiFunction<Object, ValueFactory, Object> converterFunction = this.resolveConverter(unionType);
        try {
            return converterFunction.apply(value, this.vvf);
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    private BiFunction<Object, ValueFactory, Object> resolveConverter(ScalarType scalarType) {
        String typeName = scalarType.getRdf();
        BiFunction<Object, ValueFactory, Object> converterFunction = CONVERTERS.get(typeName);
        if (converterFunction == null) {
            return this.tryCustomTypeConverter(scalarType);
        }
        if ("rdfs:Resource".equals(typeName) || OLD_RDF_RESOURCE.equals(typeName)) {
            converterFunction = this.toFullIri(converterFunction, scalarType);
        }
        return converterFunction;
    }

    private BiFunction<Object, ValueFactory, Object> tryCustomTypeConverter(ScalarType scalarType) {
        ScalarType iriType = (ScalarType)scalarType.getContainedIn().get((Object)"iri");
        if (iriType == null || "iri".equals(scalarType.getName())) {
            throw new ValueConversionException(INVALID_MODEL);
        }
        String typeName = scalarType.getRdf();
        return (value, valueFactory) -> {
            IRI type = (IRI)this.resolveConverter(iriType).apply(typeName, (ValueFactory)valueFactory);
            return Rdf4jInputValueConverter.toCustomType(type).apply(Objects.toString(value), (ValueFactory)valueFactory);
        };
    }

    private Object convertValues(Object value, ScalarType expectedType) {
        BiFunction<Object, ValueFactory, Object> converterFunction = this.resolveConverter(expectedType);
        if (value instanceof Collection) {
            ArrayList<Object> resultList = new ArrayList<Object>(((Collection)value).size());
            for (Object element : (Collection)value) {
                if (element == null) continue;
                resultList.add(converterFunction.apply(element, this.vvf));
            }
            return resultList;
        }
        return converterFunction.apply(value, this.vvf);
    }

    private BiFunction<Object, ValueFactory, Object> toFullIri(BiFunction<Object, ValueFactory, Object> converterFunction, ScalarType expectedType) {
        Prefixes prefixes = expectedType.getContainedIn().getContainedIn().getPrefixes();
        return (iri, vf) -> converterFunction.apply(this.tryResolveFullIri(prefixes, iri), (ValueFactory)vf);
    }

    private Object tryResolveFullIri(Prefixes prefixes, Object iri) {
        String nameSpace;
        String iriString = iri.toString();
        iriString = StringUtils.removeStart((String)iriString, (String)"<");
        String[] iriParts = (iriString = StringUtils.removeEnd((String)iriString, (String)">")).split(":", 2);
        if (iriParts.length == 2 && (nameSpace = (String)prefixes.get((Object)iriParts[0])) != null) {
            return nameSpace + iriParts[1];
        }
        return iriString;
    }

    private static <T, R extends Value> BiFunction<Object, ValueFactory, Object> createConverter(BiFunction<ValueFactory, T, R> converter, Function<Object, T> transformer) {
        return (value, valueFactory) -> {
            try {
                return converter.apply((ValueFactory)valueFactory, (Object)transformer.apply(value));
            }
            catch (ClassCastException | IllegalArgumentException iae) {
                throw new ValueConversionException(iae.getMessage(), (Throwable)iae);
            }
        };
    }

    private static Function<Object, XMLGregorianCalendar> toXmlGregorianCalendar() {
        return value -> {
            try {
                return datatypeFactory.newXMLGregorianCalendar(value.toString());
            }
            catch (IllegalArgumentException iae) {
                throw new ValueConversionException(iae.getMessage(), (Throwable)iae);
            }
        };
    }

    private static BiFunction<Object, ValueFactory, Object> toLangLiteral() {
        return (val, valueFactory) -> {
            if (val instanceof Map) {
                Map valueMap = (Map)val;
                Object value = valueMap.get("value");
                Object lang = valueMap.get("lang");
                if (value == null) {
                    throw new ValueConversionException("Literal `value` is missing");
                }
                if (value instanceof Literal) {
                    Literal valueLiteral = (Literal)value;
                    value = valueLiteral.getLabel();
                }
                if (lang == null || StringUtils.isBlank((CharSequence)lang.toString())) {
                    return valueFactory.createLiteral(value.toString());
                }
                if (lang instanceof Literal) {
                    Literal langLiteral = (Literal)lang;
                    lang = langLiteral.getLabel();
                }
                return valueFactory.createLiteral(value.toString(), Locale.forLanguageTag(lang.toString()).toLanguageTag());
            }
            throw new ValueConversionException("Invalid literal format! Expected a dictionary with [value, lang] keys but got: " + String.valueOf(val));
        };
    }

    private static Function<Object, Byte> toByte() {
        return value -> {
            if (value instanceof Byte) {
                Byte byteValue = (Byte)value;
                return byteValue;
            }
            return Rdf4jInputValueConverter.createBigInteger(value).byteValueExact();
        };
    }

    private static Function<Object, Short> toShort() {
        return value -> {
            if (value instanceof Short) {
                Short shortValue = (Short)value;
                return shortValue;
            }
            if (value instanceof Character) {
                Character character = (Character)value;
                return (short)character.charValue();
            }
            return Rdf4jInputValueConverter.createBigInteger(value).shortValueExact();
        };
    }

    private static Function<Object, Integer> toInteger() {
        return value -> {
            if (value instanceof Integer) {
                Integer integerValue = (Integer)value;
                return integerValue;
            }
            return Rdf4jInputValueConverter.createBigInteger(value).intValueExact();
        };
    }

    private static Function<Object, Long> toLong() {
        return value -> {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return longValue;
            }
            return Rdf4jInputValueConverter.createBigInteger(value).longValueExact();
        };
    }

    private static Function<Object, Boolean> toBoolean() {
        return value -> {
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                return booleanValue;
            }
            if (value instanceof String) {
                if ((value = value.toString().toLowerCase()).equals("true")) {
                    return Boolean.TRUE;
                }
                if ("false".equals(value)) {
                    return Boolean.FALSE;
                }
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                int intValue = number.intValue();
                if (intValue == 0) {
                    return Boolean.FALSE;
                }
                if (intValue == 1) {
                    return Boolean.TRUE;
                }
            }
            throw new ValueConversionException("Invalid Boolean value! Expected on of [true, false, 1, 0]  but got: " + String.valueOf(value));
        };
    }

    private static Function<Object, BigInteger> toBigInteger() {
        return Rdf4jInputValueConverter::createBigInteger;
    }

    private static BigInteger createBigInteger(Object value) {
        if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            return bigIntegerValue;
        }
        try {
            return new BigInteger(value.toString());
        }
        catch (NumberFormatException nfe) {
            throw new ValueConversionException("Invalid number value: " + String.valueOf(value), (Throwable)nfe);
        }
    }

    private static Function<Object, Float> toFloat() {
        return value -> {
            if (value instanceof Float) {
                Float floatValue = (Float)value;
                return floatValue;
            }
            return Float.valueOf(Rdf4jInputValueConverter.createBigDecimal(value).floatValue());
        };
    }

    private static Function<Object, Double> toDouble() {
        return value -> {
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                return doubleValue;
            }
            return Rdf4jInputValueConverter.createBigDecimal(value).doubleValue();
        };
    }

    private static Function<Object, BigDecimal> toBigDecimal() {
        return Rdf4jInputValueConverter::createBigDecimal;
    }

    private static BigDecimal createBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return bigDecimalValue;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException nfe) {
            throw new ValueConversionException("Invalid floating point number value: " + String.valueOf(value), (Throwable)nfe);
        }
    }

    private static BiFunction<Object, ValueFactory, Object> toCustomType(IRI typeIri) {
        return (value, valueFactory) -> {
            try {
                return valueFactory.createLiteral(value.toString(), typeIri);
            }
            catch (IllegalArgumentException iae) {
                throw new ValueConversionException("Not a valid literal value " + String.valueOf(value) + " for type: " + String.valueOf(typeIri), (Throwable)iae);
            }
        };
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalAccessError("Could not instantiate javax.xml.datatype.DatatypeFactory");
        }
        CONVERTERS.put("xsd:string", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, String.class::cast));
        CONVERTERS.put("rdfs:Resource", Rdf4jInputValueConverter.createConverter(ValueFactory::createIRI, String.class::cast));
        CONVERTERS.put(OLD_RDF_RESOURCE, Rdf4jInputValueConverter.createConverter(ValueFactory::createIRI, String.class::cast));
        CONVERTERS.put("xsd:boolean", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toBoolean()));
        CONVERTERS.put("rdf:langString", Rdf4jInputValueConverter.toLangLiteral());
        CONVERTERS.put("xsd:float", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toFloat()));
        CONVERTERS.put("xsd:double", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toDouble()));
        CONVERTERS.put("xsd:decimal", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toBigDecimal()));
        CONVERTERS.put("xsd:byte", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toByte()));
        CONVERTERS.put("xsd:short", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toShort()));
        CONVERTERS.put("xsd:int", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toInteger()));
        CONVERTERS.put("xsd:long", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toLong()));
        CONVERTERS.put("xsd:integer", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toBigInteger()));
        CONVERTERS.put("xsd:nonNegativeInteger", Rdf4jInputValueConverter.toCustomType(XSD.NON_NEGATIVE_INTEGER));
        CONVERTERS.put("xsd:nonPositiveInteger", Rdf4jInputValueConverter.toCustomType(XSD.NON_POSITIVE_INTEGER));
        CONVERTERS.put("xsd:positiveInteger", Rdf4jInputValueConverter.toCustomType(XSD.POSITIVE_INTEGER));
        CONVERTERS.put("xsd:negativeInteger", Rdf4jInputValueConverter.toCustomType(XSD.NEGATIVE_INTEGER));
        CONVERTERS.put("xsd:unsignedByte", Rdf4jInputValueConverter.toCustomType(XSD.UNSIGNED_BYTE));
        CONVERTERS.put("xsd:unsignedShort", Rdf4jInputValueConverter.toCustomType(XSD.UNSIGNED_SHORT));
        CONVERTERS.put("xsd:unsignedInt", Rdf4jInputValueConverter.toCustomType(XSD.UNSIGNED_INT));
        CONVERTERS.put("xsd:unsignedLong", Rdf4jInputValueConverter.toCustomType(XSD.UNSIGNED_LONG));
        CONVERTERS.put("xsd:dateTimeStamp", Rdf4jInputValueConverter.toDateTimeStamp());
        CONVERTERS.put("xsd:dateTime", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:date", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:time", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:gYear", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:gMonthDay", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:gDay", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:gMonth", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:gYearMonth", Rdf4jInputValueConverter.createConverter(ValueFactory::createLiteral, Rdf4jInputValueConverter.toXmlGregorianCalendar()));
        CONVERTERS.put("xsd:duration", Rdf4jInputValueConverter.toCustomType(XSD.DURATION));
        CONVERTERS.put("xsd:dayTimeDuration", Rdf4jInputValueConverter.toCustomType(XSD.DAYTIMEDURATION));
        CONVERTERS.put("xsd:yearMonthDuration", Rdf4jInputValueConverter.toCustomType(XSD.YEARMONTHDURATION));
    }
}

