/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;

public class OneToManyPropertyResultHandler
extends AbstractTupleQueryResultHandler {
    private final String keyBindingName;
    private final String valueBindingName;
    private Map<Value, List<Value>> results;

    public OneToManyPropertyResultHandler(String keyBindingName, String valueBindingName) {
        this.keyBindingName = keyBindingName;
        this.valueBindingName = valueBindingName;
    }

    public void startQueryResult(List<String> bindingNames) {
        if (!bindingNames.contains(this.keyBindingName) && !bindingNames.contains(this.valueBindingName)) {
            throw new IllegalArgumentException(String.format("The expected binding names [%s, %s] are not present the result. Got: %s", this.keyBindingName, this.valueBindingName, bindingNames));
        }
        this.results = new LinkedHashMap<Value, List<Value>>();
    }

    public void handleSolution(BindingSet bindingSet) {
        Value key = bindingSet.getValue(this.keyBindingName);
        Value value = bindingSet.getValue(this.valueBindingName);
        if (key != null && value != null) {
            this.results.computeIfAbsent(key, v -> new LinkedList()).add(value);
        }
    }

    public Map<Value, List<Value>> getResults() {
        return this.results;
    }
}

