/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.logging.Loggers;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;

public class LimitedResultHandler
implements TupleQueryResultHandler {
    private final TupleQueryResultHandler inner;
    private final int initialLimit;
    private final AtomicInteger limit;

    public LimitedResultHandler(TupleQueryResultHandler inner, AtomicInteger limit) {
        this.inner = inner;
        this.limit = limit;
        this.initialLimit = limit.get();
    }

    public void handleBoolean(boolean value) {
        this.inner.handleBoolean(value);
    }

    public void handleLinks(List<String> linkUrls) {
        this.inner.handleLinks(linkUrls);
    }

    public void startQueryResult(List<String> bindingNames) {
        this.inner.startQueryResult(bindingNames);
    }

    public void endQueryResult() {
        this.inner.endQueryResult();
    }

    public void handleSolution(BindingSet bindingSet) {
        if (this.limit.addAndGet(-bindingSet.size()) < 0) {
            Loggers.sparqlQueryResultsLogger().warn("Reached the limit of sparql.endpoint.maxTupleResults of {} tuples", (Object)this.initialLimit);
            throw new TupleQueryResultHandlerException(String.format("Reached the limit of sparql.endpoint.maxTupleResults of %d tuples", this.initialLimit));
        }
        this.inner.handleSolution(bindingSet);
    }
}

