/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class LimitedDataHandler
implements RDFHandler {
    private final RDFHandler inner;
    private final AtomicInteger limit;
    private final int initialLimit;

    public LimitedDataHandler(RDFHandler inner, AtomicInteger limit) {
        this.inner = inner;
        this.limit = limit;
        this.initialLimit = limit.get();
    }

    public void startRDF() {
        this.inner.startRDF();
    }

    public void endRDF() {
        this.inner.endRDF();
    }

    public void handleNamespace(String prefix, String uri) {
        this.inner.handleNamespace(prefix, uri);
    }

    public void handleStatement(Statement st) {
        if (this.limit.decrementAndGet() < 0) {
            throw new RDFHandlerException(String.format("Reached the limit of sparql.endpoint.maxTupleResults of %d tuples", this.initialLimit));
        }
        this.inner.handleStatement(st);
    }

    public void handleComment(String comment) {
        this.inner.handleComment(comment);
    }
}

