/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.InterruptedQueryException;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import java.util.concurrent.Semaphore;

public class ConnectionReusePolicies {
    private ConnectionReusePolicies() {
    }

    public static ConnectionReusePolicy noConnectionReuse() {
        return NoConnectionReusePolicy.INSTANCE;
    }

    public static ConnectionReusePolicy sharedSingleConnection() {
        return new SharedSingleConnectionPolicy();
    }

    public static ConnectionReusePolicy serializedSingleConnection() {
        return new SerializedConnectionReusePolicy(ConnectionReusePolicies.sharedSingleConnection(), 1);
    }

    public static ConnectionReusePolicy toNoneCloseableConnectionPolicy(ConnectionReusePolicy delegate) {
        if (delegate instanceof NoneCloseableConnectionReusePolicy) {
            return delegate;
        }
        return new NoneCloseableConnectionReusePolicy(delegate);
    }

    public static ConnectionReusePolicy toCloseOnNoTxConnectionPolicy(ConnectionReusePolicy delegate) {
        if (delegate instanceof CloseOnNoTxConnectionReusePolicy) {
            return delegate;
        }
        return new CloseOnNoTxConnectionReusePolicy(delegate);
    }

    private static class NoConnectionReusePolicy
    implements ConnectionReusePolicy {
        static final ConnectionReusePolicy INSTANCE = new NoConnectionReusePolicy();

        private NoConnectionReusePolicy() {
        }

        @Override
        public SparqlConnection acquireConnection(String requestId, SparqlConnectionFactory connectionFactory, SparqlEndpoint endpoint) {
            return connectionFactory.getConnection(endpoint);
        }

        @Override
        public void releaseConnection(SparqlConnection connection, String requestId, SparqlEndpoint endpoint) {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static class SharedSingleConnectionPolicy
    implements ConnectionReusePolicy {
        private SparqlConnection sparqlConnection;

        private SharedSingleConnectionPolicy() {
        }

        @Override
        public synchronized SparqlConnection acquireConnection(String requestId, SparqlConnectionFactory connectionFactory, SparqlEndpoint endpoint) {
            if (this.sparqlConnection == null) {
                this.sparqlConnection = connectionFactory.getConnection(endpoint);
            }
            return this.sparqlConnection;
        }

        @Override
        public void releaseConnection(SparqlConnection connection, String requestId, SparqlEndpoint endpoint) {
        }

        @Override
        public synchronized void close() {
            if (this.sparqlConnection != null) {
                if (this.sparqlConnection.isTxActive()) {
                    Loggers.sparqlUpdateLogger().warn("Rolling back transaction due to previous failures on connection close");
                    this.sparqlConnection.rollback();
                }
                this.sparqlConnection.close();
                this.sparqlConnection = null;
            }
        }
    }

    private static class SerializedConnectionReusePolicy
    implements ConnectionReusePolicy {
        private final ConnectionReusePolicy delegate;
        private final Semaphore semaphore;

        SerializedConnectionReusePolicy(ConnectionReusePolicy delegate, int concurrency) {
            this.delegate = delegate;
            this.semaphore = new Semaphore(Math.max(concurrency, 1));
        }

        private void waitForAvailableConnection() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new InterruptedQueryException("Could not acquire shared connection");
            }
        }

        @Override
        public SparqlConnection acquireConnection(String requestId, SparqlConnectionFactory connectionFactory, SparqlEndpoint endpoint) {
            this.waitForAvailableConnection();
            return this.delegate.acquireConnection(requestId, connectionFactory, endpoint);
        }

        @Override
        public void releaseConnection(SparqlConnection connection, String requestId, SparqlEndpoint endpoint) {
            if (connection != null) {
                this.delegate.releaseConnection(connection, requestId, endpoint);
            }
            this.semaphore.release();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    private static class NoneCloseableConnectionReusePolicy
    implements ConnectionReusePolicy {
        private final ConnectionReusePolicy delegate;

        private NoneCloseableConnectionReusePolicy(ConnectionReusePolicy delegate) {
            this.delegate = delegate;
        }

        @Override
        public SparqlConnection acquireConnection(String requestId, SparqlConnectionFactory connectionFactory, SparqlEndpoint endpoint) {
            return this.delegate.acquireConnection(requestId, connectionFactory, endpoint);
        }

        @Override
        public void releaseConnection(SparqlConnection connection, String requestId, SparqlEndpoint endpoint) {
            this.delegate.releaseConnection(connection, requestId, endpoint);
        }
    }

    private static class CloseOnNoTxConnectionReusePolicy
    implements ConnectionReusePolicy {
        private final ConnectionReusePolicy delegate;

        private CloseOnNoTxConnectionReusePolicy(ConnectionReusePolicy delegate) {
            this.delegate = delegate;
        }

        @Override
        public SparqlConnection acquireConnection(String requestId, SparqlConnectionFactory connectionFactory, SparqlEndpoint endpoint) {
            return this.delegate.acquireConnection(requestId, connectionFactory, endpoint);
        }

        @Override
        public void releaseConnection(SparqlConnection connection, String requestId, SparqlEndpoint endpoint) {
            this.delegate.releaseConnection(connection, requestId, endpoint);
            if (!connection.isTxActive()) {
                connection.close();
                this.delegate.close();
            }
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

