/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.repository.http;

import com.ontotext.repository.http.InterceptingRepositoryConnection;
import com.ontotext.repository.http.OperationInterceptor;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;

public class InterceptingRepository
implements Repository {
    private final Repository delegate;
    private final Set<OperationInterceptor> queryInterceptors = new CopyOnWriteArraySet<OperationInterceptor>();
    private final Set<OperationInterceptor> updateInterceptors = new CopyOnWriteArraySet<OperationInterceptor>();

    public InterceptingRepository(Repository delegate) {
        this.delegate = delegate;
    }

    public void init() {
        this.delegate.init();
    }

    public boolean isInitialized() {
        return this.delegate.isInitialized();
    }

    public void shutDown() {
        this.delegate.shutDown();
    }

    public void setDataDir(File dataDir) {
        this.delegate.setDataDir(dataDir);
    }

    public File getDataDir() {
        return this.delegate.getDataDir();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public RepositoryConnection getConnection() {
        InterceptingRepositoryConnection connection = new InterceptingRepositoryConnection(this.delegate.getConnection());
        this.queryInterceptors.forEach(connection::addQueryInterceptor);
        this.updateInterceptors.forEach(connection::addUpdateInterceptor);
        return connection;
    }

    public ValueFactory getValueFactory() {
        return this.delegate.getValueFactory();
    }

    public Repository getDelegate() {
        return this.delegate;
    }

    public void addQueryInterceptor(OperationInterceptor interceptor) {
        this.queryInterceptors.add(interceptor);
    }

    public void removeQueryInterceptor(OperationInterceptor interceptor) {
        this.queryInterceptors.remove(interceptor);
    }

    public void addUpdateInterceptor(OperationInterceptor interceptor) {
        this.updateInterceptors.add(interceptor);
    }

    public void removeUpdateInterceptor(OperationInterceptor interceptor) {
        this.updateInterceptors.remove(interceptor);
    }
}

