/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.LangConfig;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.SourceLocation;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class LiteralPropertiesValidator
implements OperationValidator {
    public OperationResponse visit(Query query, ValidationContext context) {
        OperationResponse response = new OperationResponse();
        for (Selection selection : query.getSelections()) {
            response.addAll(this.visit(selection, context));
        }
        return response;
    }

    public OperationResponse visit(CreateMutation mutation, ValidationContext context) {
        OperationResponse response = new OperationResponse();
        for (Selection selection : mutation.getSelections()) {
            response.addAll(this.visit(selection, context));
        }
        return response;
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext context) {
        OperationResponse response = new OperationResponse();
        for (Selection selection : mutation.getSelections()) {
            response.addAll(this.visit(selection, context));
        }
        return response;
    }

    public OperationResponse visit(Selection selection, ValidationContext context) {
        Optional<PropertyShape> scalarProperty = selection.getProperty().filter(PropertyShape::isScalarType);
        if (scalarProperty.isPresent() && !scalarProperty.filter(PropertyShape::isLiteral).isPresent()) {
            return OperationResponse.EMPTY;
        }
        OperationResponse response = new OperationResponse();
        if ("Literal".equals(selection.getType())) {
            Shape shape = selection.getDefinedInType();
            PropertyShape property = scalarProperty.orElseThrow(LiteralPropertiesValidator.unknownSelectionProperty(selection, shape));
            ScalarType scalarType = property.getScalarType();
            if (LiteralPropertiesValidator.isLangOrLangString(scalarType) && LiteralPropertiesValidator.isTypeSelected(selection)) {
                response.addErrorMessage((Serializable)((Object)SimpleGraphQlError.newValidationErrorMessage((SourceLocation)selection.getLocation(), (String)"literal.not.allowed.use.of.type", (Object[])new Object[]{selection.getName()}).toSpecification()));
            }
            Arguments arguments = selection.getArguments();
            if (selection.isRequestedByUser() && (scalarType.isLangStringSupported() && (arguments.getLimit().isPresent() || arguments.getOffset().isPresent()) || arguments.getOrder().isPresent())) {
                this.validateLangFilter(selection, response);
            }
        } else {
            for (Selection subSelection : selection.getSelections()) {
                response.addAll(this.visit(subSelection, context));
            }
        }
        return response;
    }

    private void validateLangFilter(Selection selection, OperationResponse response) {
        Optional<String> inheritedPreference = this.resolveLangPreferenceFilter((Selectable)selection);
        if (inheritedPreference.isPresent()) {
            inheritedPreference.map(LiteralPropertiesValidator.captureValidationError(LangFilter::parseForLiteralOrder, (Selectable)selection)).ifPresent(arg_0 -> ((OperationResponse)response).addErrorMessage(arg_0));
        } else {
            selection.getProperty().map(PropertyShape::getLangConfig).map(LangConfig::getFetch).map(LiteralPropertiesValidator.captureValidationError(LangFilter::parseForLiteralOrder, (Selectable)selection)).ifPresent(arg_0 -> ((OperationResponse)response).addErrorMessage(arg_0));
        }
    }

    private Optional<String> resolveLangPreferenceFilter(Selectable selectable) {
        Arguments arguments = selectable.getArguments();
        Object langPreference = arguments.get((Object)"lang");
        if (langPreference != null) {
            return Optional.of(langPreference.toString());
        }
        if (selectable.getParent() != null) {
            return this.resolveLangPreferenceFilter(selectable.getParent());
        }
        return Optional.empty();
    }

    private static <M> Function<M, Serializable> captureValidationError(Consumer<M> validator, Selectable selectable) {
        return value -> {
            try {
                validator.accept(value);
            }
            catch (IllegalArgumentException iae) {
                return (Serializable)((Object)SimpleGraphQlError.newValidationError((SourceLocation)selectable.getLocation(), (String)iae.getMessage()).toSpecification());
            }
            return null;
        };
    }

    private static boolean isTypeSelected(Selection selection) {
        return selection.getSelections().stream().anyMatch(item -> item.isRequestedByUser() && "type".equals(item.getName()));
    }

    private static boolean isLangOrLangString(ScalarType scalarType) {
        boolean isLangOrLangString = scalarType.isUnionType() ? scalarType.getUnionTypes().stream().allMatch(LiteralPropertiesValidator.isStringOrLangString()) : LiteralPropertiesValidator.isStringOrLangString().test(scalarType);
        return isLangOrLangString;
    }

    private static Predicate<ScalarType> isStringOrLangString() {
        return scalarType -> "rdf:langString".equals(scalarType.getRdf()) || "xsd:string".equals(scalarType.getRdf());
    }

    private static Supplier<IllegalArgumentException> unknownSelectionProperty(Selection selection, Shape shape) {
        return () -> new IllegalArgumentException("Unknown property '" + selection.getName() + "' in '" + shape.getId() + "'");
    }
}

