/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.ChangePreconditions;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.CaseInsensitiveRegex;
import com.ontotext.models.query.CaseInsensitiveRegexMismatch;
import com.ontotext.models.query.ExpressionTraverserContext;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.FilterExpressionTraverser;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.Regex;
import com.ontotext.models.query.RegexMismatch;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.query.TraversalControl;
import com.ontotext.models.query.Value;
import com.ontotext.soaas.common.validation.ValidationPatterns;
import com.ontotext.validator.query.ValidationExpressionContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class IdArgumentOperationValidator
extends AbstractExpressionVisitor<TraversalControl, ValidationExpressionContext>
implements OperationValidator {
    private static final Set<String> BASE_TYPES = new HashSet<String>(Arrays.asList("Object", "Nameable", "Literal"));
    private static final String ARGUMENTS_ID_NOT_VALID_IRI = "arguments.id.notValidIRI";

    public TraversalControl visit(CaseInsensitiveRegex target, ValidationExpressionContext context) {
        return TraversalControl.CANCEL;
    }

    public TraversalControl visit(CaseInsensitiveRegexMismatch target, ValidationExpressionContext context) {
        return TraversalControl.CANCEL;
    }

    public TraversalControl visit(Regex target, ValidationExpressionContext context) {
        return TraversalControl.CANCEL;
    }

    public TraversalControl visit(RegexMismatch target, ValidationExpressionContext context) {
        return TraversalControl.CANCEL;
    }

    public TraversalControl visit(Value target, ValidationExpressionContext context) {
        Optional<Node> idNode = context.getPath().filter(Node.class::isInstance).map(Node.class::cast).filter(node -> node.getName().equals("id")).findFirst();
        if (!idNode.isPresent() || !IdArgumentOperationValidator.isTypeApplicableForValidation(idNode.get().getShape())) {
            return TraversalControl.CONTINUE;
        }
        Selectable selectable = context.getSelectable();
        Shape shape = idNode.get().getShape();
        IdArgumentOperationValidator.getExpressionValues(target.getValue()).filter(IdArgumentOperationValidator::isNotValidIri).forEach(this.addValidationError(context));
        IdArgumentOperationValidator.getExpressionValues(target.getValue()).forEach(id -> this.validateByType((String)id, selectable, shape, (Collection<SourceLocation>)Collections.singleton(selectable.getLocation()), context.getOperationResponse()));
        return TraversalControl.CONTINUE;
    }

    public OperationResponse visit(Query query, ValidationContext validationContext) {
        return this.validate((Operation)query, validationContext);
    }

    public OperationResponse visit(Selection selection, ValidationContext validationContext) {
        OperationResponse operationResponse = new OperationResponse();
        this.validateInternal((Selectable)selection, validationContext.getSomlSchema(), operationResponse);
        return operationResponse;
    }

    public OperationResponse visit(CreateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(DeleteMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    private Consumer<String> addValidationError(ValidationExpressionContext context) {
        Selectable selectable = context.getSelectable();
        Set<SourceLocation> location = Collections.singleton(selectable.getLocation());
        return id -> this.addError(context::addMessage, location, selectable, ARGUMENTS_ID_NOT_VALID_IRI, id);
    }

    private static Stream<String> getExpressionValues(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(Object::toString);
        }
        return Stream.of(value.toString());
    }

    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        if (!validationContext.getValidatorOptions().isValidatorEnabled(((Object)((Object)this)).getClass().getSimpleName())) {
            return OperationResponse.EMPTY;
        }
        OperationResponse operationResponse = new OperationResponse();
        this.validateInternal((Selectable)operation, validationContext.getSomlSchema(), operationResponse);
        return operationResponse;
    }

    private void validateInternal(Selectable selectable, SomlSchema schema, OperationResponse response) {
        if (selectable instanceof Mutation) {
            this.validateMutationId((Mutation)selectable, response);
        } else {
            selectable.getArguments().getId().ifPresent(ids -> {
                String shapeName = schema.getPrefixes().nameToShortIri(selectable.getType());
                Shape shape = (Shape)schema.getObjects().get((Object)shapeName);
                this.validateIds((Collection<String>)ids, shape, (Collection<SourceLocation>)Collections.singleton(selectable.getLocation()), selectable, response);
            });
        }
        this.validateWhereExpressionIdValues(selectable, response);
        for (Selectable selection : selectable.getSelections()) {
            this.validateInternal(selection, schema, response);
        }
    }

    private void validateMutationId(Mutation mutation, OperationResponse response) {
        for (Change change : mutation.getChanges()) {
            Shape shape = change.getShape();
            Set<SourceLocation> changeLocation = Collections.singleton(change.getSourceLocation());
            change.getEntityId().ifPresent(id -> this.validateIds(Collections.singleton(id), shape, changeLocation, (Selectable)mutation, response));
            if (change.hasPreconditions() && change.getPreconditions().getPrecondition() != null) {
                ChangePreconditions preconditions = change.getPreconditions();
                ValidationExpressionContext context = new ValidationExpressionContext(response, (Selectable)mutation);
                preconditions.getPrecondition().accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
            }
            change.getChanges().stream().filter(propChange -> this.isIriProperty(shape, (PropertyChange)propChange)).forEach(propChange -> this.validateProperty(mutation, response, shape, (PropertyChange)propChange));
        }
    }

    private boolean isIriProperty(Shape shape, PropertyChange propChange) {
        return shape.getProperty(propChange.getName()).filter(propertyShape -> !propertyShape.isScalarType() || "iri".equals(propertyShape.getRange())).isPresent();
    }

    private void validateProperty(Mutation mutation, OperationResponse response, Shape shape, PropertyChange propertyChange) {
        List<Object> idsToCheck = Collections.emptyList();
        if (propertyChange.hasPatch()) {
            idsToCheck = propertyChange.getPatch() instanceof Collection ? ((Collection)propertyChange.getPatch()).stream().map(Objects::toString).collect(Collectors.toList()) : Collections.singletonList(propertyChange.getPatch().toString());
        } else if (propertyChange.hasValue()) {
            idsToCheck = propertyChange.getValueAsCollection().stream().filter(Objects::nonNull).map(Objects::toString).collect(Collectors.toList());
        }
        if (propertyChange.hasWhere()) {
            propertyChange.getWhere().accept((ExpressionVisitor)this, (ExpressionVisitorContext)new ValidationExpressionContext(response, (Selectable)mutation));
        }
        if (idsToCheck.isEmpty()) {
            return;
        }
        PropertyShape propertyShape = shape.getProperty(propertyChange.getName()).orElseGet(PropertyShape::new);
        SomlSchema schema = shape.getContainedIn().getContainedIn();
        Shape rangeShape = (Shape)schema.getObjects().get((Object)propertyShape.getRange());
        List locations = propertyChange.getSourceLocations();
        this.validateIds(idsToCheck, rangeShape, locations, (Selectable)mutation, response);
    }

    private void validateIds(Collection<String> ids, Shape shape, Collection<SourceLocation> locations, Selectable selectable, OperationResponse operationResponse) {
        boolean isTypeApplicableForValidation = IdArgumentOperationValidator.isTypeApplicableForValidation(shape);
        for (String id : ids) {
            if (IdArgumentOperationValidator.isNotValidIri(id)) {
                this.addError(arg_0 -> ((OperationResponse)operationResponse).add(arg_0), locations, selectable, ARGUMENTS_ID_NOT_VALID_IRI, id);
                continue;
            }
            if (!isTypeApplicableForValidation) continue;
            this.validateByType(id, selectable, shape, locations, operationResponse);
        }
    }

    private void validateWhereExpressionIdValues(Selectable selectable, OperationResponse response) {
        Optional expression = selectable.getArguments().getWhere();
        expression.ifPresent(value -> FilterExpressionTraverser.traversePreOrder((ExpressionValue)value, (ExpressionVisitor)this, (ExpressionTraverserContext)new ValidationExpressionContext(response, selectable)));
    }

    private static boolean isTypeApplicableForValidation(Shape definedInType) {
        if (definedInType == null) {
            return false;
        }
        String typeId = definedInType.getId();
        if (BASE_TYPES.contains(typeId)) {
            return false;
        }
        if (definedInType.isAbstract()) {
            Collection subTypes = definedInType.getContainedIn().getContainedIn().getObjects().getConcreteSubTypes(typeId);
            return subTypes.stream().allMatch(shape -> shape.getRegex() != null || shape.getPrefix() != null);
        }
        return true;
    }

    private void validateByType(String id, Selectable selectable, Shape type, Collection<SourceLocation> locations, OperationResponse response) {
        if (ReferenceId.isReferenceId((String)id)) {
            return;
        }
        SomlSchema somlSchema = type.getContainedIn().getContainedIn();
        Prefixes prefixes = somlSchema.getPrefixes();
        if (type.isAbstract()) {
            Collection subTypes = somlSchema.getObjects().getConcreteSubTypes(type.getId());
            boolean notValidId = subTypes.stream().noneMatch(this.validateId(somlSchema, id, prefixes));
            if (notValidId) {
                this.addError(arg_0 -> ((OperationResponse)response).add(arg_0), locations, selectable, "arguments.id.doesNotMatchAnySubType", id);
            }
        } else {
            List hierarchy = somlSchema.getObjects().getHierarchy(type.getId());
            Optional<Shape> regexShape = hierarchy.stream().filter(shape -> StringUtils.isNotBlank((CharSequence)shape.getRegex())).findFirst();
            if (regexShape.isPresent() && !IdArgumentOperationValidator.matchRegex(regexShape.get(), id)) {
                this.addError(arg_0 -> ((OperationResponse)response).add(arg_0), locations, selectable, "arguments.id.doesNotMatchRegex", id, regexShape.get().getRegex());
            }
            if (!IdArgumentOperationValidator.matchPrefix(id, prefixes, type)) {
                this.addError(arg_0 -> ((OperationResponse)response).add(arg_0), locations, selectable, "arguments.id.doesNotMatchPrefix", id, type.getPrefix());
            }
        }
    }

    private void addError(Consumer<OperationResponse.OperationMessage> messageConsumer, Collection<SourceLocation> locations, Selectable selectable, String message, Object ... args) {
        messageConsumer.accept((OperationResponse.OperationMessage)QueryValidationMessage.error(locations, (String)message, (Object[])this.resolveArgs(selectable, args)));
    }

    private Object[] resolveArgs(Selectable selectable, Object ... args) {
        Object[] newArgs = Arrays.copyOf(args, args.length + 1);
        newArgs[args.length] = selectable.getPath();
        return newArgs;
    }

    private static boolean isNotValidIri(String id) {
        return ReferenceId.isNotReferenceId((String)id) && !ValidationPatterns.isValidIri((String)id);
    }

    private Predicate<Shape> validateId(SomlSchema schema, String id, Prefixes prefixes) {
        return object -> {
            List hierarchy;
            Optional<Shape> regexShape;
            boolean passAnyValidation = false;
            boolean valid = true;
            if (StringUtils.isNotBlank((CharSequence)object.getPrefix())) {
                passAnyValidation = true;
                valid = IdArgumentOperationValidator.matchPrefix(id, prefixes, object);
            }
            if ((regexShape = (hierarchy = schema.getObjects().getHierarchy(object.getId())).stream().filter(shape -> StringUtils.isNotBlank((CharSequence)shape.getRegex())).findFirst()).isPresent() && StringUtils.isNotBlank((CharSequence)regexShape.get().getRegex())) {
                passAnyValidation = true;
                valid &= IdArgumentOperationValidator.matchRegex(regexShape.get(), id);
            }
            return passAnyValidation && valid;
        };
    }

    private static boolean matchRegex(Shape regexShape, String id) {
        return Pattern.compile(regexShape.getRegex()).matcher(id).find();
    }

    private static boolean matchPrefix(String id, Prefixes prefixes, Shape object) {
        return StringUtils.isBlank((CharSequence)object.getPrefix()) || id.startsWith(prefixes.toIri(object.getPrefix()));
    }
}

