/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.mutation;

import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.query.SourceLocation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SoTypeValidator {
    public void validateCreateChange(Change change, Map<String, Set<String>> changeDescMap, Consumer<QueryValidationMessage> messageConsumer) {
        Shape changeShape = change.getShape();
        SomlSchema schema = changeShape.getContainedIn().getContainedIn();
        for (PropertyChange propChange : change.getChanges()) {
            if (!this.propChangeIsDescriptor(schema, changeShape, propChange)) continue;
            String changeProp = this.getRdfPropForProp(changeShape, propChange.getName());
            Set vals = changeDescMap.computeIfAbsent(changeProp, key -> new HashSet());
            if (propChange.isReplace()) {
                vals.clear();
            }
            if (!SoTypeValidator.doesPropertyChangeContainsValidValue(changeShape, propChange, vals)) continue;
            Object value = propChange.getRawValue();
            if (value instanceof Collection) {
                ((Collection)value).stream().map(String::valueOf).forEach(vals::add);
                continue;
            }
            vals.add(String.valueOf(value));
        }
        this.compliesWithShape(changeDescMap, changeShape, shape -> messageConsumer.accept(this.getShapeNotMetError(change, (Shape)shape)), true, new HashSet<String>());
    }

    private static boolean doesPropertyChangeContainsValidValue(Shape changeShape, PropertyChange propChange, Set<String> vals) {
        Object patch;
        if (propChange.hasPatch() && ((patch = propChange.getPatch()) instanceof Map || patch instanceof Collection || !vals.remove(changeShape.getContainedIn().getContainedIn().getPrefixes().toIri(String.valueOf(patch))))) {
            return false;
        }
        return propChange.hasValue();
    }

    void checkIfMatchesExactType(Change change, Map<String, Set<String>> changeDescMap, Consumer<QueryValidationMessage> messageConsumer) {
        Shape changeShape = change.getShape();
        SomlSchema schema = changeShape.getContainedIn().getContainedIn();
        LinkedList<Shape> compliantShapes = new LinkedList<Shape>();
        Set allowedShapes = schema.getObjects().getHierarchy(changeShape.getId()).stream().map(Shape::getId).collect(Collectors.toSet());
        changeShape.getContainedIn().values().stream().filter(sh -> !allowedShapes.contains(sh.getId())).filter(sh -> sh.getType() != null).forEach(otherShape -> {
            if (this.compliesWithShape(changeDescMap, (Shape)otherShape, ignore -> {}, false, (Set<String>)new HashSet<String>())) {
                compliantShapes.add((Shape)otherShape);
            }
        });
        if (!compliantShapes.isEmpty()) {
            compliantShapes.add(0, changeShape);
            messageConsumer.accept(this.getMultipleShapesMetError(change, compliantShapes));
        }
    }

    private QueryValidationMessage getMultipleShapesMetError(Change change, List<Shape> compliantShapes) {
        String types = this.prettyPrint(compliantShapes.stream().map(Shape::getId).collect(Collectors.toList()));
        SourceLocation location = change.getSourceLocation();
        return change.getEntityId().map(s -> QueryValidationMessage.error((SourceLocation)location, (String)"sotype.violation.multipleShapesMet", (Object[])new Object[]{s, types})).orElseGet(() -> QueryValidationMessage.error((SourceLocation)location, (String)"sotype.violation.multipleShapesMet_noId", (Object[])new Object[]{types}));
    }

    private QueryValidationMessage getShapeNotMetError(Change change, Shape shape) {
        SourceLocation location = change.getSourceLocation();
        String types = this.prettyPrint(shape.getTypeAsList());
        return change.getEntityId().map(id -> QueryValidationMessage.error((SourceLocation)location, (String)"sotype.violation.shapeNotMet", (Object[])new Object[]{id, shape.getId(), shape.getTypeProp(), types})).orElseGet(() -> QueryValidationMessage.error((SourceLocation)location, (String)"sotype.violation.shapeNotMet_noId", (Object[])new Object[]{shape.getId(), shape.getTypeProp(), types}));
    }

    public boolean changeAffectsDescriptors(SomlSchema schema, Change change) {
        for (PropertyChange propChange : change.getChanges()) {
            if (!this.propChangeIsDescriptor(schema, change.getShape(), propChange)) continue;
            return true;
        }
        return false;
    }

    protected boolean compliesWithShape(Map<String, Set<String>> descMap, Shape shape, Consumer<Shape> nonCompliantShapeConsumer, boolean full, Set<String> rdfPropsChecked) {
        if (shape == null) {
            return true;
        }
        boolean complies = false;
        if (shape.getType() == null || shape.isIgnoredType() || rdfPropsChecked.contains(shape.getTypeProp())) {
            complies = true;
        } else {
            Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
            List<String> nomalizedTypeList = shape.getTypeAsList().stream().map(arg_0 -> ((Prefixes)prefixes).toIri(arg_0)).collect(Collectors.toList());
            for (Map.Entry<String, Set<String>> desc : descMap.entrySet()) {
                if (!prefixes.irisAreEqual(shape.getTypePropIri(), desc.getKey()) || !this.commonElementsExist(nomalizedTypeList, desc.getValue(), prefixes)) continue;
                complies = true;
                break;
            }
            rdfPropsChecked.add(shape.getTypeProp());
        }
        if (!complies) {
            nonCompliantShapeConsumer.accept(shape);
        }
        if (full && shape.getInherits() != null) {
            complies &= shape.getParents().allMatch(parent -> this.compliesWithShape(descMap, (Shape)parent, nonCompliantShapeConsumer, true, rdfPropsChecked));
        }
        return complies;
    }

    protected String getRdfPropForProp(Shape shape, String prop) {
        Optional shapeProp = shape.getProperty(prop);
        if (shapeProp.isEmpty()) {
            return null;
        }
        return ((PropertyShape)shapeProp.get()).getRdfProperty();
    }

    protected boolean commonElementsExist(List<String> typeAsList, Object value, Prefixes prefixes) {
        if (value instanceof Collection) {
            for (Object val : (Collection)value) {
                if (!typeAsList.contains(prefixes.toIri(String.valueOf(val)))) continue;
                return true;
            }
        } else {
            return typeAsList.contains(prefixes.toIri(String.valueOf(value)));
        }
        return false;
    }

    protected boolean propChangeIsDescriptor(SomlSchema schema, Shape shape, PropertyChange propChange) {
        return this.getDescriptors(schema).contains(this.getRdfPropForProp(shape, propChange.getName()));
    }

    private synchronized Set<String> getDescriptors(SomlSchema schema) {
        return schema.getObjects().getSoTypeDescriptors();
    }

    private String prettyPrint(Collection<String> collection) {
        return collection.stream().collect(Collectors.joining("', '", "['", "']"));
    }

    public void addErrorMessage(SourceLocation source, OperationResponse resp, String message, Object ... args) {
        resp.add((OperationResponse.OperationMessage)QueryValidationMessage.error((SourceLocation)source, (String)message, (Object[])args));
    }
}

