/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.mutation;

import com.ontotext.models.MutationValidator;
import com.ontotext.models.Operation;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.PropertyChange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class PropertiesCardinalityOperationValidator
extends MutationValidator {
    public OperationResponse validate(Operation operation, ValidationContext context) {
        if (operation instanceof DeleteMutation || !context.getValidatorOptions().isValidatorEnabled(((Object)((Object)this)).getClass().getSimpleName())) {
            return OperationResponse.EMPTY;
        }
        OperationResponse response = new OperationResponse();
        operation.getArguments().getChanges().ifPresent(changes -> changes.forEach(change -> this.validateChange((Change)change, response)));
        return response;
    }

    private void validateChange(Change change, OperationResponse response) {
        Shape shape = change.getShape();
        change.getChanges().stream().filter(PropertyChange::hasValue).collect(Collectors.groupingBy(this.getPropertyShape(shape), this.collectValues())).forEach((property, values) -> this.validateProperty((PropertyShape)property, (Set<Object>)values, response));
    }

    private Function<PropertyChange, PropertyShape> getPropertyShape(Shape shape) {
        Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
        return prop -> (PropertyShape)shape.getProperty(prefixes.nameToShortIri(prop.getName())).orElseThrow(() -> new IllegalArgumentException("Unknown property " + prop.getName()));
    }

    private Collector<PropertyChange, ?, Set<Object>> collectValues() {
        return Collector.of(HashSet::new, (list, property) -> list.addAll(this.getValues((PropertyChange)property)), (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    private Collection<?> getValues(PropertyChange property) {
        Object value = property.getValue();
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    private void validateProperty(PropertyShape property, Set<Object> values, OperationResponse response) {
        int valuesSize = values.size();
        if (property.isMultivalued() && !property.isUnbounded() && property.getMaxValue() < valuesSize) {
            response.addErrorMessage("mutation.property.values.limit.exceeded", new Object[]{this.getPropertyPath(property), property.getMax()});
        }
    }

    private String getPropertyPath(PropertyShape property) {
        return String.join((CharSequence)".", property.getContainedIn().getContainedIn().getId(), property.getName());
    }
}

