/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.GraphQlTypes;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.soaas.common.CollectionsUtil;
import java.util.Collection;

public class ScalarTypesValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        ScalarTypes types = somlSchema.getTypes();
        for (ScalarType scalarType : types.values()) {
            if (!types.isTracked(scalarType.getName())) continue;
            if (scalarType.getGraphql() == null) {
                operationResponse.addErrorMessage("type.should.have.graphql.mapping", new Object[]{scalarType.getName()});
            } else if (!scalarType.isEnum() && !GraphQlTypes.ALL_TYPES.contains(scalarType.getGraphql())) {
                operationResponse.addErrorMessage("type.should.have.valid.graphql.mapping", new Object[]{scalarType.getName(), scalarType.getGraphql()});
            }
            if (scalarType.getRdf() != null) continue;
            if (CollectionsUtil.isNullOrEmpty((Collection)scalarType.getUnion())) {
                operationResponse.addErrorMessage("type.should.have.rdf.mapping", new Object[]{scalarType.getName()});
                continue;
            }
            if (scalarType.getUnionTypes().size() >= 2) continue;
            operationResponse.addErrorMessage("union.type.should.have.atLeastTwoTypes", new Object[]{scalarType.getName()});
        }
        return operationResponse;
    }
}

