/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.soaas.common.validation.ValidationPatterns;
import org.apache.commons.lang3.StringUtils;

public class PropertyRdfPropValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        for (PropertyShape property2 : somlSchema.getProperties().values()) {
            if (!property2.isTracked("rdfProp") || !StringUtils.isNotBlank((CharSequence)property2.getRdfProp()) || !property2.isTripleSelection() && !property2.isAbsoluteRdfPropValue()) continue;
            this.checkRdfPropCollision(property2, operationResponse);
            this.checkRdfPropFormat(property2, somlSchema.getPrefixes(), operationResponse);
        }
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.isHierarchyInvalid() || shape.isSynthetic().booleanValue()) continue;
            shape.getAllProperties().values().stream().distinct().filter(property -> shape.getProps().isTracked(property.getName())).filter(property -> property.isTracked("rdfProp")).filter(property -> StringUtils.isNotBlank((CharSequence)property.getRdfProp())).filter(property -> property.isTripleSelection() || property.isAbsoluteRdfPropValue()).forEach(property -> {
                this.checkRdfPropCollision((PropertyShape)property, operationResponse, shape.getId());
                this.checkRdfPropFormat((PropertyShape)property, somlSchema.getPrefixes(), operationResponse, shape.getId());
            });
        }
        return operationResponse;
    }

    private void checkRdfPropCollision(PropertyShape property, OperationResponse errors) {
        if (StringUtils.isNotBlank((CharSequence)property.getInverseAlias())) {
            errors.addErrorMessage("property.conflict.aliases", new Object[]{property.getName(), property.getRdfProp(), property.getInverseAlias()});
        }
    }

    private void checkRdfPropCollision(PropertyShape property, OperationResponse errors, String parent) {
        if (StringUtils.isNotBlank((CharSequence)property.getInverseAlias())) {
            errors.addErrorMessage("property.object.conflict.aliases", new Object[]{property.getName(), parent, property.getRdfProp(), property.getInverseAlias()});
        }
    }

    private void checkRdfPropFormat(PropertyShape property, Prefixes prefixes, OperationResponse errors) {
        try {
            if (!property.isAbsoluteRdfPropValue()) {
                if (!ValidationPatterns.isValidIri((String)prefixes.toIri(property.getRdfProp()))) {
                    errors.addErrorMessage("property.rdf.prop.bad.format", new Object[]{property.getName(), property.getRdfProp()});
                }
            } else if (!ValidationPatterns.isValidIri((String)property.getRdfProp())) {
                errors.addErrorMessage("property.rdf.prop.bad.absolute.format", new Object[]{property.getName(), property.getAsAbsoluteRdfProp()});
            }
        }
        catch (InvalidSchemaException ise) {
            errors.addErrorMessage("property.rdf.prop.undefined.prefix", new Object[]{property.getName(), property.getRdfProp()});
        }
    }

    private void checkRdfPropFormat(PropertyShape property, Prefixes prefixes, OperationResponse errors, String parent) {
        try {
            if (!property.isAbsoluteRdfPropValue()) {
                if (!ValidationPatterns.isValidIri((String)prefixes.toIri(property.getRdfProp()))) {
                    errors.addErrorMessage("property.object.rdf.prop.bad.format", new Object[]{property.getName(), parent, property.getRdfProp()});
                }
            } else if (!ValidationPatterns.isValidIri((String)property.getRdfProp())) {
                errors.addErrorMessage("property.object.rdf.prop.bad.absolute.format", new Object[]{property.getName(), parent, property.getAsAbsoluteRdfProp()});
            }
        }
        catch (InvalidSchemaException ise) {
            errors.addErrorMessage("property.object.rdf.prop.undefined.prefix", new Object[]{property.getName(), parent, property.getRdfProp()});
        }
    }
}

