/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class PropertyOntologyCharacteristicsValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        for (PropertyShape property : somlSchema.getProperties().values()) {
            this.validateInverseAlias("", property, objects, operationResponse);
            this.validateInverseOf("", property, objects, operationResponse);
        }
        for (Shape object : objects.values()) {
            if (!objects.isTracked(object.getId()) || object.isHierarchyInvalid()) continue;
            String propertyPath = " of " + object.getId();
            Properties props = object.getProps();
            for (PropertyShape property : props.values()) {
                if (!props.isTracked(property.getName())) continue;
                this.validateInverseAlias(propertyPath, property, objects, operationResponse);
                this.validateInverseOf(propertyPath, property, objects, operationResponse);
            }
        }
        return operationResponse;
    }

    private void validateInverseOf(String path, PropertyShape property, Shapes objects, OperationResponse response) {
        if (!property.isTracked("inverseOf")) {
            return;
        }
        this.doValidation(property.getName(), path, property.getInverseOf(), property.getRange(), objects, response, "Of");
    }

    private void validateInverseAlias(String path, PropertyShape property, Shapes objects, OperationResponse response) {
        if (!property.isTracked("inverseAlias")) {
            return;
        }
        this.doValidation(property.getName(), path, property.getInverseAlias(), property.getRange(), objects, response, "Alias");
    }

    private void doValidation(String name, String path, String relation, String range, Shapes objects, OperationResponse response, String inverseType) {
        if (relation != null && !relation.trim().isEmpty()) {
            PropertyShape referredProp = this.getReferredProperty(relation, range, objects);
            if (null == referredProp) {
                this.writeUndefinedErrorMessage(name, path, relation, range, response, inverseType);
            } else if (null != referredProp.getInverseAlias() && "Alias".equals(inverseType)) {
                this.writeIndirectionErrorMessage(name, path, referredProp.getName(), referredProp.getInverseAlias(), response);
            }
        }
    }

    @Nullable
    private PropertyShape getReferredProperty(String relation, String range, Shapes objects) {
        PropertyShape referredProp = null;
        Shape refPropShape = (Shape)objects.get((Object)range);
        if (refPropShape != null && !refPropShape.isHierarchyInvalid() && (referredProp = refPropShape.isUnion() ? (PropertyShape)refPropShape.getUnionOfShapes().stream().map(member -> member.getProperty(relation).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null) : (PropertyShape)refPropShape.getProperty(relation).orElse(null)) == null) {
            referredProp = refPropShape.getProperty(SchemaSanitizerUtils.sanitizeValue((String)relation)).orElse(null);
        }
        return referredProp;
    }

    private void writeUndefinedErrorMessage(String name, String path, String relation, String range, OperationResponse response, String inverseType) {
        response.addErrorMessage("property.refers.to.undefined.inverse" + inverseType, new Object[]{name, path, relation, range});
    }

    private void writeIndirectionErrorMessage(String name, String path, String inverseAlias, String secondAlias, OperationResponse response) {
        response.addErrorMessage("property.refers.to.indirection.inverseAlias", new Object[]{inverseAlias, name, path, secondAlias});
    }
}

