/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Collection;
import java.util.List;

public class PropertyCardinalityValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        for (PropertyShape property : somlSchema.getProperties().values()) {
            this.checkPropertyCardinality(property, operationResponse, "");
        }
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.isHierarchyInvalid() || shape.isSynthetic().booleanValue()) continue;
            String path = " of " + shape.getId();
            for (PropertyShape property : shape.getProps().values()) {
                this.checkPropertyCardinality(property, operationResponse, path);
                this.checkInheritedCardinality(somlSchema.getObjects(), shape, property, operationResponse);
            }
        }
        return operationResponse;
    }

    private void checkPropertyCardinality(PropertyShape property, OperationResponse errors, String path) {
        try {
            if (property.isTracked("max") && !"inf".equals(property.getMax())) {
                Integer.parseInt(property.getMax());
            }
        }
        catch (NumberFormatException nfe) {
            errors.addErrorMessage("property.has.wrong.cardinality", new Object[]{property.getName(), path, property.getMin(), property.getMax()});
            return;
        }
        boolean isCardinalityInvalid = property.isTracked("min") && property.getMin() != null && property.getMin() < 0;
        isCardinalityInvalid |= property.isTracked("max") && property.getMaxValue() != null && property.getMaxValue() <= 0;
        if (isCardinalityInvalid |= null != property.getMin() && property.getMax() == null && property.getMin() > 1 || property.getMax() != null && property.getMin() > property.getMaxValue()) {
            errors.addErrorMessage("property.has.wrong.cardinality", new Object[]{property.getName(), path, property.getMin(), property.getMax()});
        }
    }

    private void checkInheritedCardinality(Shapes objects, Shape shape, PropertyShape property, OperationResponse operationResponse) {
        List hierarchy;
        try {
            hierarchy = objects.getHierarchy(shape.getId());
        }
        catch (InvalidSchemaException ise) {
            return;
        }
        if (!property.isRequired()) {
            this.validateRequired(shape, property, operationResponse, hierarchy);
        }
        if (property.isMultivalued()) {
            this.validateMultivalued(shape, property, operationResponse, hierarchy);
        } else {
            this.validateSingleValued(shape, property, operationResponse, hierarchy);
        }
    }

    private void validateMultivalued(Shape shape, PropertyShape property, OperationResponse operationResponse, Collection<Shape> hierarchy) {
        for (Shape object : hierarchy) {
            PropertyShape parentProperty = (PropertyShape)object.getProps().get((Object)property.getName());
            if (parentProperty == null || parentProperty.isMultivalued() && property.getMaxValue() <= parentProperty.getMaxValue()) continue;
            operationResponse.addErrorMessage("property.cannot.increase.max", new Object[]{shape.getId(), property.getName(), property.getMax(), object.getId()});
        }
    }

    private void validateSingleValued(Shape shape, PropertyShape property, OperationResponse operationResponse, Collection<Shape> hierarchy) {
        for (Shape object : hierarchy) {
            PropertyShape parentProperty = (PropertyShape)object.getProps().get((Object)property.getName());
            if (parentProperty == null || !parentProperty.isMultivalued()) continue;
            operationResponse.addErrorMessage("property.cannot.changeFromMVtoSV", new Object[]{shape.getId(), property.getName(), object.getId()});
        }
    }

    private void validateRequired(Shape shape, PropertyShape property, OperationResponse operationResponse, Collection<Shape> hierarchy) {
        for (Shape object : hierarchy) {
            PropertyShape parentProperty = (PropertyShape)object.getProps().get((Object)property.getName());
            if (parentProperty == null || parentProperty.getMin() <= property.getMin()) continue;
            operationResponse.addErrorMessage("property.cannot.decrease.min", new Object[]{shape.getId(), property.getName(), property.getMin(), object.getId()});
        }
    }
}

