/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class PrefixesValidationUtil {
    private PrefixesValidationUtil() {
    }

    static Set<String> collectUsedNamespaces(SomlSchema schema) {
        HashSet<String> usedNamespaces = new HashSet<String>();
        PrefixesValidationUtil.collectNamespaces(schema.getObjects().keySet(), usedNamespaces);
        PrefixesValidationUtil.collectNamespaces(PrefixesValidationUtil.allFromProperties(schema), usedNamespaces);
        PrefixesValidationUtil.collectNamespaces(PrefixesValidationUtil.allShapesTypes(schema), usedNamespaces);
        return usedNamespaces;
    }

    private static void collectNamespaces(Collection<String> from, Set<String> usedPrefixes) {
        for (String value : from) {
            String[] parts;
            if (!StringUtils.isNotBlank((CharSequence)value) || (parts = value.split(":", 2)).length <= 1) continue;
            usedPrefixes.add(parts[0]);
        }
    }

    private static Set<String> allFromProperties(SomlSchema schema) {
        return schema.getObjects().values().stream().map(Shape::getAllProperties).flatMap(props -> Stream.concat(props.values().stream().filter(PropertyShape::isTripleSelection).filter(prop -> !prop.isAbsoluteRdfPropValue()).map(PropertyShape::getRdfProp), props.keySet().stream())).collect(Collectors.toSet());
    }

    private static Set<String> allShapesTypes(SomlSchema schema) {
        return schema.getObjects().values().stream().map(Shape::getTypeAsList).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

