/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ObjectTypeValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        Map<String, List<Shape>> objectsByTypeProp = objects.values().stream().filter(shape -> shape.isSynthetic() == false).filter(shape -> !shape.isAbstract() && !Shapes.AFFECTED_TYPES.contains(shape.getId())).collect(Collectors.groupingBy(Shape::getTypeProp));
        for (List<Shape> withSameTypeProp : objectsByTypeProp.values()) {
            ObjectTypeValidator.checkTypeConstrains(withSameTypeProp, operationResponse);
        }
        objects.values().stream().filter(shape -> shape.isSynthetic() == false && !Shapes.AFFECTED_TYPES.contains(shape.getId())).forEach(shape -> this.checkTypePrefix(somlSchema.getPrefixes(), (Shape)shape, operationResponse));
        return operationResponse;
    }

    private static void checkTypeConstrains(List<Shape> withSameTypeProp, OperationResponse operationResponse) {
        LinkedList<Shape> rest = new LinkedList<Shape>(withSameTypeProp);
        while (!rest.isEmpty()) {
            Shape first = rest.pop();
            for (Shape other : rest) {
                ObjectTypeValidator.checkConstrains(first, other, operationResponse);
            }
        }
    }

    private static void checkConstrains(Shape current, Shape other, OperationResponse operationResponse) {
        if (current.getTypeAsList().isEmpty() && !current.isUnion()) {
            operationResponse.addErrorMessage("object.should.have.type.value", new Object[]{current.getId()});
            return;
        }
        for (String typeValue : current.getTypeAsList()) {
            if (!other.getTypeAsList().contains(typeValue) || ObjectTypeValidator.haveDisjointParent(current, other)) continue;
            operationResponse.addErrorMessage("objects.with.same.typeProp.should.be.disjoint", new Object[]{current.getId(), other.getId(), current.getTypeProp(), typeValue});
        }
    }

    private void checkTypePrefix(Prefixes prefixes, Shape shape, OperationResponse response) {
        shape.getTypeAsList().forEach(type -> {
            try {
                prefixes.toIri(type);
            }
            catch (InvalidSchemaException ise) {
                response.addErrorMessage("object.type.undefined.prefix", new Object[]{shape.getId(), type});
            }
        });
    }

    private static boolean haveDisjointParent(Shape shape1, Shape shape2) {
        Map<String, List<String>> parents1 = ObjectTypeValidator.getParentsConstraintsMap(shape1);
        Map<String, List<String>> parents2 = ObjectTypeValidator.getParentsConstraintsMap(shape2);
        if (parents1.isEmpty() && parents2.isEmpty()) {
            return false;
        }
        if (!parents1.keySet().equals(parents2.keySet())) {
            return true;
        }
        for (String prop : parents1.keySet()) {
            if (ObjectTypeValidator.haveCommonElements(parents1.get(prop), parents2.get(prop))) continue;
            return true;
        }
        return false;
    }

    private static boolean haveCommonElements(List<String> array1, List<String> array2) {
        for (String string1 : array1) {
            if (!array2.contains(string1)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, List<String>> getParentsConstraintsMap(Shape shape) {
        HashMap<String, List<String>> parentsConstraints = new HashMap<String, List<String>>();
        List inheritsAsList = shape.getInheritsAsList();
        for (String parent : inheritsAsList) {
            ObjectTypeValidator.traceParentHierarchy(shape, parentsConstraints, parent);
        }
        return parentsConstraints;
    }

    private static void traceParentHierarchy(Shape shape, Map<String, List<String>> parentsConstraints, String parent) {
        Shape parentShape = (Shape)shape.getContainedIn().get((Object)parent);
        if (parentShape == null) {
            return;
        }
        if (!(parentShape.getTypeAsList().isEmpty() || Objects.equals(shape.getTypePropIri(), parentShape.getTypePropIri()) || parentsConstraints.containsKey(parentShape.getTypeProp()))) {
            parentsConstraints.put(parentShape.getTypeProp(), parentShape.getTypeAsList());
        }
        parentShape.getInheritsAsList().forEach(currentParent -> ObjectTypeValidator.traceParentHierarchy(parentShape, parentsConstraints, currentParent));
    }
}

