/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;

public class ObjectNameCardinalityValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        for (Shape shape : objects.values()) {
            if (!objects.isTracked(shape.getId()) || !this.hasDefinedName(shape)) continue;
            shape.getProperty(shape.getName()).filter(this::isNotSingleValue).ifPresent(nameProp -> this.reportError(response, shape, (PropertyShape)nameProp));
        }
        return response;
    }

    private boolean hasDefinedName(Shape shape) {
        return shape.isSynthetic() == false && shape.isTracked("name") && shape.getName() != null;
    }

    private boolean isNotSingleValue(PropertyShape nameShape) {
        return nameShape.isMultivalued() && nameShape.isScalarType() && !nameShape.getScalarType().isLangStringSupported() || !nameShape.isRequired();
    }

    private void reportError(OperationResponse response, Shape shape, PropertyShape nameShape) {
        String message = nameShape.isLiteral() ? "name.should.be.mandatory.literal" : "name.should.be.mandatory.and.single";
        response.addErrorMessage(message, new Object[]{nameShape.getName(), shape.getId(), nameShape.getMin(), nameShape.getMax()});
    }
}

