/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MultipleInheritancePropertyCardinalityValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        objects.values().stream().filter(this::shapeHasMultipleParents).forEach(shape -> this.checkForInheritedCardinalityViolations((Shape)shape, operationResponse));
        return operationResponse;
    }

    private boolean shapeHasMultipleParents(Shape shape) {
        return shape.getInheritsAsList().size() > 1;
    }

    private void checkForInheritedCardinalityViolations(Shape shape, OperationResponse operationResponse) {
        Map<String, List<Shape>> parentPropertyMap = this.collectCommonParentProperties(shape);
        parentPropertyMap.forEach((propertyName, parentsList) -> this.checkForPropertyFieldCardinalityViolations(shape, operationResponse, (String)propertyName, (List<Shape>)parentsList));
    }

    private Map<String, List<Shape>> collectCommonParentProperties(Shape shape) {
        LinkedHashMap<String, List<Shape>> result = new LinkedHashMap<String, List<Shape>>();
        shape.getParents().forEach(parent -> this.populateProperties((Shape)parent, (Map<String, List<Shape>>)result));
        result.values().removeIf(list -> list.size() < 2);
        return result;
    }

    private void populateProperties(Shape shape, Map<String, List<Shape>> result) {
        shape.getAllProperties().values().forEach(property -> result.computeIfAbsent(property.getName(), k -> new ArrayList()).add(shape));
    }

    private void checkForPropertyFieldCardinalityViolations(Shape shape, OperationResponse operationResponse, String propertyName, List<Shape> parentsList) {
        Map<String, Set<Integer>> propertyFields = this.collectCommonPropertyFieldCardinality(shape, propertyName, parentsList);
        this.generateMessageForWrongFieldCardinality(shape.getId(), propertyName, propertyFields, operationResponse);
    }

    private Map<String, Set<Integer>> collectCommonPropertyFieldCardinality(Shape shape, String propertyName, List<Shape> parentsList) {
        LinkedHashMap<String, Set<Integer>> result = new LinkedHashMap<String, Set<Integer>>();
        parentsList.forEach(parent -> {
            PropertyShape parentProperty = (PropertyShape)parent.getAllProperties().get((Object)propertyName);
            this.populateCommonPropertyFieldCardinalityMap(shape, result, parentProperty);
        });
        return result;
    }

    private void populateCommonPropertyFieldCardinalityMap(Shape shape, Map<String, Set<Integer>> result, PropertyShape parentProperty) {
        if (this.propertyIsDefined(shape, parentProperty)) {
            return;
        }
        result.computeIfAbsent("min", k -> new TreeSet()).add(parentProperty.getMin());
        result.computeIfAbsent("max", k -> new TreeSet()).add(parentProperty.getMaxValue());
    }

    private boolean propertyIsDefined(Shape shape, PropertyShape prop) {
        PropertyShape propertyShape = null;
        try {
            propertyShape = (PropertyShape)shape.getProps().get((Object)prop.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return propertyShape != null;
    }

    private void generateMessageForWrongFieldCardinality(String shapeId, String propertyName, Map<String, Set<Integer>> propertyFields, OperationResponse operationResponse) {
        int max;
        if (propertyFields.isEmpty()) {
            return;
        }
        int min = propertyFields.get("min").stream().mapToInt(Integer::intValue).max().orElseThrow(() -> new IllegalStateException(this.getClass().getSimpleName() + " fails: the min field set is empty"));
        if (min > (max = propertyFields.get("max").stream().mapToInt(Integer::intValue).min().orElseThrow(() -> new IllegalStateException(this.getClass().getSimpleName() + " fails: the max field set is empty")))) {
            operationResponse.addErrorMessage("property.has.wrong.cardinality", new Object[]{propertyName, " of " + shapeId, min, max});
        }
    }
}

