/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Objects;

public class FederatedSparqlServicesValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse resp = new OperationResponse();
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.getSparqlFederatedService() == null) continue;
            this.validateServiceConfiguration(resp, shape);
            this.validateServiceIsNotOverwritten(resp, shape);
            this.validatePropertyInverseAliasRanges(somlSchema, resp, shape);
        }
        return resp;
    }

    private void validateServiceConfiguration(OperationResponse resp, Shape shape) {
        if (shape.getSparqlFederatedService() != null && shape.getServiceAddress() == null) {
            resp.addErrorMessage("object.service.notConfigured", new Object[]{shape.getSparqlFederatedService(), shape.getId()});
        }
    }

    private void validateServiceIsNotOverwritten(OperationResponse resp, Shape shape) {
        if (shape.isAbstract()) {
            for (Shape child : shape.getSubTypes()) {
                if (Objects.equals(child.getSparqlFederatedService(), shape.getSparqlFederatedService()) || !child.isTracked("sparqlFederatedService")) continue;
                resp.addErrorMessage("object.service.overwrite.forbidden", new Object[]{child.getId(), shape.getId(), shape.getSparqlFederatedService(), child.getSparqlFederatedService()});
            }
        }
    }

    private void validatePropertyInverseAliasRanges(SomlSchema somlSchema, OperationResponse resp, Shape shape) {
        for (PropertyShape property : shape.getAllProperties().values()) {
            if (property.getInverseAlias() == null) continue;
            Shape propRange = (Shape)somlSchema.getObjects().get((Object)property.getRange());
            if (Objects.equals(shape.getSparqlFederatedService(), propRange.getSparqlFederatedService())) continue;
            resp.addErrorMessage("property.inverse.service.different", new Object[]{shape.getId(), property.getName(), propRange.getId(), property.getInverseAlias()});
        }
    }
}

