/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.EnumValueDef;
import com.ontotext.models.RdfTypes;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EnumValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        List<ScalarType> enums = somlSchema.getTypes().values().stream().filter(ScalarType::isEnum).toList();
        if (enums.isEmpty()) {
            return OperationResponse.EMPTY;
        }
        OperationResponse response = new OperationResponse();
        Set modelNames = somlSchema.getObjects().values().stream().map(Shape::asGraphQl).collect(Collectors.toSet());
        for (ScalarType type : enums) {
            this.validateEnumValues(type, response);
            if (modelNames.contains(type.getGraphql())) {
                response.addErrorMessage("enums.duplicate-name", new Object[]{type.getGraphql(), type.getName()});
            }
            if (type.getRdf() == null || RdfTypes.SUPPORTED_TYPES.contains(type.getRdf()) || RdfTypes.SUPPORTED_TYPES.contains(somlSchema.getPrefixes().toShortIri(type.getRdf()))) continue;
            response.addWarningMessage("enums.invalid-rdf", new Object[]{type.getRdf(), type.getName()});
        }
        return response;
    }

    private void validateEnumValues(ScalarType type, OperationResponse response) {
        long enumsWithExplicitValues;
        Map namesCount = type.getValues().stream().map(EnumValueDef::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List<String> duplicateNames = namesCount.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).toList();
        if (!duplicateNames.isEmpty()) {
            response.addErrorMessage("enums.duplicate-value-name", new Object[]{type.getName(), duplicateNames});
        }
        if ((enumsWithExplicitValues = type.getValues().stream().filter(def -> def.isTracked("value")).count()) > 1L) {
            type.getValues().stream().map(EnumValueDef::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((value, count) -> {
                if (count > 1L) {
                    response.addErrorMessage("enums.duplicate-value", new Object[]{type.getName(), value});
                }
            });
        }
    }
}

