/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.grpc;

import com.ontotext.graphdb.cluster.observer.grpc.PingRequest;
import com.ontotext.graphdb.cluster.observer.grpc.PingResponse;
import com.ontotext.graphdb.cluster.observer.grpc.PingServiceGrpc;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class RpcPingService
extends PingServiceGrpc.PingServiceImplBase {
    private final Function<String, ManagedChannelBuilder<?>> channelFactory;

    public RpcPingService() {
        this(null);
    }

    public RpcPingService(@Nullable Function<String, ManagedChannelBuilder<?>> channelFactory) {
        this.channelFactory = channelFactory;
    }

    @Override
    public void ping(PingRequest request, StreamObserver<PingResponse> responseObserver) {
        String address = request.getAddress();
        if (address.isEmpty() || this.channelFactory == null) {
            responseObserver.onNext((Object)RpcPingService.buildSuccessMessage());
            responseObserver.onCompleted();
            return;
        }
        Context.current().fork().run(() -> RpcPingService.callBack(address, responseObserver, this.channelFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callBack(String address, StreamObserver<PingResponse> responseObserver, Function<String, ManagedChannelBuilder<?>> channelFactory) {
        ManagedChannel channel = channelFactory.apply(address).build();
        try {
            PingServiceGrpc.PingServiceBlockingStub stub = PingServiceGrpc.newBlockingStub((Channel)channel);
            PingResponse response = ((PingServiceGrpc.PingServiceBlockingStub)stub.withDeadlineAfter(2L, TimeUnit.SECONDS)).ping(PingRequest.newBuilder().build());
            if (response.getSuccess()) {
                responseObserver.onNext((Object)RpcPingService.buildSuccessMessage());
            } else {
                String message = response.getMessage().isEmpty() ? "Bad pong response" : response.getMessage();
                responseObserver.onNext((Object)RpcPingService.buildFailureMessage(message));
            }
        }
        catch (RuntimeException re) {
            String message = Objects.toString(re.getMessage(), "Unknown failure reason by " + String.valueOf(re.getClass()));
            responseObserver.onNext((Object)RpcPingService.buildFailureMessage(message));
        }
        finally {
            try {
                responseObserver.onCompleted();
            }
            finally {
                if (channel != null) {
                    channel.shutdown();
                }
            }
        }
    }

    private static PingResponse buildSuccessMessage() {
        return PingResponse.newBuilder().setSuccess(true).build();
    }

    private static PingResponse buildFailureMessage(String message) {
        return PingResponse.newBuilder().setSuccess(false).setMessage(message).build();
    }
}

