/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.apache.commons.rdf.rdf4j.RDF4JQuad;
import org.apache.commons.rdf.rdf4j.impl.TripleImpl;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

final class QuadImpl
implements RDF4JQuad {
    private transient int hashCode = 0;
    private final UUID salt;
    private final Statement statement;

    QuadImpl(Statement statement, UUID salt) {
        this.statement = statement;
        this.salt = salt;
    }

    @Override
    public Statement asStatement() {
        return this.statement;
    }

    public Triple asTriple() {
        return new TripleImpl(this.statement, this.salt);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Quad) {
            Quad quad = (Quad)obj;
            return this.getGraphName().equals(quad.getGraphName()) && this.getSubject().equals(quad.getSubject()) && this.getPredicate().equals((Object)quad.getPredicate()) && this.getObject().equals((Object)quad.getObject());
        }
        return false;
    }

    public Optional<BlankNodeOrIRI> getGraphName() {
        if (this.statement.getContext() == null) {
            return Optional.empty();
        }
        BlankNodeOrIRI g = (BlankNodeOrIRI)RDF4J.asRDFTerm((Value)this.statement.getContext(), this.salt);
        return Optional.of(g);
    }

    public RDFTerm getObject() {
        return RDF4J.asRDFTerm(this.statement.getObject(), this.salt);
    }

    public IRI getPredicate() {
        return (IRI)RDF4J.asRDFTerm((Value)this.statement.getPredicate(), null);
    }

    public BlankNodeOrIRI getSubject() {
        return (BlankNodeOrIRI)RDF4J.asRDFTerm((Value)this.statement.getSubject(), this.salt);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = Objects.hash(this.getSubject(), this.getPredicate(), this.getObject(), this.getGraphName());
        return this.hashCode;
    }

    public String toString() {
        return this.statement.toString();
    }
}

