/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j.impl;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.rdf4j.RDF4JLiteral;
import org.apache.commons.rdf.rdf4j.impl.AbstractRDFTerm;
import org.apache.commons.rdf.rdf4j.impl.IRIImpl;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

final class LiteralImpl
extends AbstractRDFTerm<Literal>
implements RDF4JLiteral {
    private static final String QUOTE = "\"";

    LiteralImpl(Literal literal) {
        super(literal);
    }

    private static String lowerCase(String langTag) {
        return langTag.toLowerCase(Locale.ROOT);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof org.apache.commons.rdf.api.Literal) {
            org.apache.commons.rdf.api.Literal other = (org.apache.commons.rdf.api.Literal)obj;
            return this.getLexicalForm().equals(other.getLexicalForm()) && this.getDatatype().equals((Object)other.getDatatype()) && this.getLanguageTag().map(LiteralImpl::lowerCase).equals(other.getLanguageTag().map(LiteralImpl::lowerCase));
        }
        return false;
    }

    public IRI getDatatype() {
        return new IRIImpl(((Literal)this.value).getDatatype());
    }

    public Optional<String> getLanguageTag() {
        return ((Literal)this.value).getLanguage();
    }

    public String getLexicalForm() {
        return ((Literal)this.value).getLabel();
    }

    public int hashCode() {
        return Objects.hash(((Literal)this.value).getLabel(), ((Literal)this.value).getDatatype(), this.getLanguageTag().map(LiteralImpl::lowerCase));
    }

    public String ntriplesString() {
        String escaped = QUOTE + TurtleUtil.encodeString((String)((Literal)this.value).getLabel()) + QUOTE;
        if (((Literal)this.value).getLanguage().isPresent()) {
            return escaped + "@" + (String)((Literal)this.value).getLanguage().get();
        }
        if (((Literal)this.value).getDatatype().equals((Object)XMLSchema.STRING)) {
            return escaped;
        }
        return escaped + "^^<" + TurtleUtil.encodeURIString((String)((Literal)this.value).getDatatype().toString()) + ">";
    }

    public String toString() {
        return this.ntriplesString();
    }
}

