/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j.impl;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.rdf4j.RDF4JBlankNode;
import org.apache.commons.rdf.rdf4j.impl.AbstractRDFTerm;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

final class BlankNodeImpl
extends AbstractRDFTerm<BNode>
implements RDF4JBlankNode {
    private transient int hashCode = 0;
    private final long saltUUIDleast;
    private final long saltUUIDmost;

    BlankNodeImpl(BNode bNode, UUID salt) {
        super(bNode);
        this.saltUUIDmost = salt.getMostSignificantBits();
        this.saltUUIDleast = salt.getLeastSignificantBits();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlankNode) {
            BlankNode blankNode = (BlankNode)obj;
            return this.uniqueReference().equals(blankNode.uniqueReference());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.uniqueReference().hashCode();
        return this.hashCode;
    }

    private boolean isValidBlankNodeLabel(String id) {
        if (id.isEmpty()) {
            return false;
        }
        if (!TurtleUtil.isBLANK_NODE_LABEL_StartChar((int)id.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (TurtleUtil.isBLANK_NODE_LABEL_Char((int)id.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public String ntriplesString() {
        if (this.isValidBlankNodeLabel(((BNode)this.value).getID())) {
            return "_:" + ((BNode)this.value).getID();
        }
        return "_:" + UUID.nameUUIDFromBytes(((BNode)this.value).getID().getBytes(StandardCharsets.UTF_8));
    }

    public String uniqueReference() {
        UUID uuid = new UUID(this.saltUUIDmost, this.saltUUIDleast);
        return "urn:uuid:" + uuid + "#" + ((BNode)this.value).getID();
    }

    public String toString() {
        return this.ntriplesString() + " [" + this.uniqueReference() + "]";
    }
}

