/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.TripleLike;
import org.apache.commons.rdf.rdf4j.RDF4JBlankNode;
import org.apache.commons.rdf.rdf4j.RDF4JBlankNodeOrIRI;
import org.apache.commons.rdf.rdf4j.RDF4JDataset;
import org.apache.commons.rdf.rdf4j.RDF4JGraph;
import org.apache.commons.rdf.rdf4j.RDF4JIRI;
import org.apache.commons.rdf.rdf4j.RDF4JLiteral;
import org.apache.commons.rdf.rdf4j.RDF4JQuad;
import org.apache.commons.rdf.rdf4j.RDF4JTerm;
import org.apache.commons.rdf.rdf4j.RDF4JTriple;
import org.apache.commons.rdf.rdf4j.RDF4JTripleLike;
import org.apache.commons.rdf.rdf4j.impl.InternalRDF4JFactory;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public final class RDF4J
implements RDF {
    private static InternalRDF4JFactory rdf4j = new InternalRDF4JFactory(){};
    private final UUID salt;
    private final ValueFactory valueFactory;

    public RDF4J() {
        this((ValueFactory)SimpleValueFactory.getInstance(), UUID.randomUUID());
    }

    public RDF4J(ValueFactory valueFactory) {
        this(valueFactory, UUID.randomUUID());
    }

    public RDF4J(UUID salt) {
        this((ValueFactory)SimpleValueFactory.getInstance(), salt);
    }

    public RDF4J(ValueFactory valueFactory, UUID salt) {
        this.valueFactory = valueFactory;
        this.salt = salt;
    }

    public RDF4JQuad asQuad(Statement statement) {
        return rdf4j.createQuadImpl(statement, this.salt);
    }

    public RDF4JTerm asRDFTerm(Value value) {
        return RDF4J.asRDFTerm(value, this.salt);
    }

    public RDF4JBlankNode asRDFTerm(BNode value) {
        return rdf4j.createBlankNodeImpl(value, this.salt);
    }

    public RDF4JLiteral asRDFTerm(Literal value) {
        return rdf4j.createLiteralImpl(value);
    }

    public RDF4JIRI asRDFTerm(org.eclipse.rdf4j.model.IRI value) {
        return rdf4j.createIRIImpl(value);
    }

    public RDF4JBlankNodeOrIRI asRDFTerm(Resource value) {
        if (value instanceof org.eclipse.rdf4j.model.IRI) {
            return this.asRDFTerm((org.eclipse.rdf4j.model.IRI)value);
        }
        if (value instanceof BNode) {
            return this.asRDFTerm((BNode)value);
        }
        throw new IllegalArgumentException("Value is not a BNode or IRI: " + value.getClass());
    }

    public static RDF4JTerm asRDFTerm(Value value, UUID salt) {
        if (value instanceof BNode) {
            return rdf4j.createBlankNodeImpl((BNode)value, salt);
        }
        if (value instanceof Literal) {
            return rdf4j.createLiteralImpl((Literal)value);
        }
        if (value instanceof org.eclipse.rdf4j.model.IRI) {
            return rdf4j.createIRIImpl((org.eclipse.rdf4j.model.IRI)value);
        }
        throw new IllegalArgumentException("Value is not a BNode, Literal or IRI: " + value.getClass());
    }

    public RDF4JDataset asDataset(Repository repository, Option ... options) {
        EnumSet<Option> opts = this.optionSet(options);
        return rdf4j.createRepositoryDatasetImpl(repository, opts.contains((Object)Option.handleInitAndShutdown), opts.contains((Object)Option.includeInferred));
    }

    public RDF4JGraph asGraph(Model model) {
        return rdf4j.createModelGraphImpl(model, this);
    }

    public RDF4JGraph asGraph(Repository repository, Option ... options) {
        EnumSet<Option> opts = this.optionSet(options);
        return rdf4j.createRepositoryGraphImpl(repository, opts.contains((Object)Option.handleInitAndShutdown), opts.contains((Object)Option.includeInferred), new Resource[]{null});
    }

    public RDF4JGraph asGraphUnion(Repository repository, Option ... options) {
        EnumSet<Option> opts = this.optionSet(options);
        return rdf4j.createRepositoryGraphImpl(repository, opts.contains((Object)Option.handleInitAndShutdown), opts.contains((Object)Option.includeInferred), new Resource[0]);
    }

    public RDF4JGraph asGraph(Repository repository, Set<? extends BlankNodeOrIRI> contexts, Option ... option) {
        EnumSet<Option> opts = this.optionSet(option);
        Resource[] resources = (Resource[])contexts.stream().map(g -> (Resource)this.asValue((RDFTerm)g)).toArray(Resource[]::new);
        return rdf4j.createRepositoryGraphImpl(Objects.requireNonNull(repository), opts.contains((Object)Option.handleInitAndShutdown), opts.contains((Object)Option.includeInferred), resources);
    }

    public Statement asStatement(TripleLike tripleLike) {
        if (tripleLike instanceof RDF4JTripleLike) {
            return ((RDF4JTripleLike)tripleLike).asStatement();
        }
        Resource subject = (Resource)this.asValue(tripleLike.getSubject());
        org.eclipse.rdf4j.model.IRI predicate = (org.eclipse.rdf4j.model.IRI)this.asValue(tripleLike.getPredicate());
        Value object = this.asValue(tripleLike.getObject());
        Resource context = null;
        if (tripleLike instanceof Quad) {
            Quad quad = (Quad)tripleLike;
            context = (Resource)this.asValue(quad.getGraphName().orElse(null));
        }
        return this.getValueFactory().createStatement(subject, predicate, object, context);
    }

    public RDF4JTriple asTriple(Statement statement) {
        return rdf4j.createTripleImpl(statement, this.salt);
    }

    public Value asValue(RDFTerm term) {
        if (term == null) {
            return null;
        }
        if (term instanceof RDF4JTerm) {
            return ((RDF4JTerm)term).asValue();
        }
        if (term instanceof IRI) {
            IRI iri = (IRI)term;
            return this.getValueFactory().createIRI(iri.getIRIString());
        }
        if (term instanceof org.apache.commons.rdf.api.Literal) {
            org.apache.commons.rdf.api.Literal literal = (org.apache.commons.rdf.api.Literal)term;
            String label = literal.getLexicalForm();
            if (literal.getLanguageTag().isPresent()) {
                String lang = (String)literal.getLanguageTag().get();
                return this.getValueFactory().createLiteral(label, lang);
            }
            org.eclipse.rdf4j.model.IRI dataType = (org.eclipse.rdf4j.model.IRI)this.asValue((RDFTerm)literal.getDatatype());
            return this.getValueFactory().createLiteral(label, dataType);
        }
        if (term instanceof BlankNode) {
            BlankNode blankNode = (BlankNode)term;
            return this.getValueFactory().createBNode(blankNode.uniqueReference());
        }
        throw new IllegalArgumentException("RDFTerm was not an IRI, Literal or BlankNode: " + term.getClass());
    }

    public RDF4JBlankNode createBlankNode() {
        BNode bnode = this.getValueFactory().createBNode();
        return this.asRDFTerm(bnode);
    }

    public RDF4JBlankNode createBlankNode(String name) {
        BNode bnode = this.getValueFactory().createBNode(name);
        return this.asRDFTerm(bnode);
    }

    public RDF4JDataset createDataset() {
        MemoryStore sail = new MemoryStore();
        SailRepository repository = new SailRepository((Sail)sail);
        return rdf4j.createRepositoryDatasetImpl((Repository)repository, true, false);
    }

    public RDF4JGraph createGraph() {
        return this.asGraph((Model)new LinkedHashModel());
    }

    public RDF4JIRI createIRI(String iri) throws IllegalArgumentException {
        return this.asRDFTerm(this.getValueFactory().createIRI(iri));
    }

    public RDF4JLiteral createLiteral(String lexicalForm) throws IllegalArgumentException {
        Literal lit = this.getValueFactory().createLiteral(lexicalForm);
        return this.asRDFTerm(lit);
    }

    public org.apache.commons.rdf.api.Literal createLiteral(String lexicalForm, IRI dataType) throws IllegalArgumentException {
        org.eclipse.rdf4j.model.IRI iri = this.getValueFactory().createIRI(dataType.getIRIString());
        Literal lit = this.getValueFactory().createLiteral(lexicalForm, iri);
        return this.asRDFTerm(lit);
    }

    public org.apache.commons.rdf.api.Literal createLiteral(String lexicalForm, String languageTag) throws IllegalArgumentException {
        Literal lit = this.getValueFactory().createLiteral(lexicalForm, languageTag);
        return this.asRDFTerm(lit);
    }

    public RDF4JTriple createTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws IllegalArgumentException {
        Statement statement = this.getValueFactory().createStatement((Resource)this.asValue((RDFTerm)subject), (org.eclipse.rdf4j.model.IRI)this.asValue((RDFTerm)predicate), this.asValue(object));
        return this.asTriple(statement);
    }

    public Quad createQuad(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws IllegalArgumentException {
        Statement statement = this.getValueFactory().createStatement((Resource)this.asValue((RDFTerm)subject), (org.eclipse.rdf4j.model.IRI)this.asValue((RDFTerm)predicate), this.asValue(object), (Resource)this.asValue((RDFTerm)graphName));
        return this.asQuad(statement);
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    private EnumSet<Option> optionSet(Option ... options) {
        EnumSet<Option> opts = EnumSet.noneOf(Option.class);
        opts.addAll(Arrays.asList(options));
        return opts;
    }

    public static enum Option {
        includeInferred,
        handleInitAndShutdown;

    }
}

