/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrdererImplNoManager;

public class ExplanationOrdererImpl
extends ExplanationOrdererImplNoManager {
    private static final AtomicLong RANDOMSTART = new AtomicLong(System.currentTimeMillis());
    private final OWLOntologyManager man;
    @Nullable
    private OWLOntology ont;

    public ExplanationOrdererImpl(OWLOntologyManager m) {
        this.man = (OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)m, (String)"m cannot be null");
    }

    @Override
    protected Set<OWLAxiom> getTargetAxioms(OWLEntity target) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (target.isOWLClass()) {
            OWLAPIStreamUtils.add(axioms, (Stream)this.getOntology().axioms(target.asOWLClass()));
        }
        if (target.isOWLObjectProperty()) {
            OWLAPIStreamUtils.add(axioms, (Stream)this.getOntology().axioms((OWLObjectPropertyExpression)target.asOWLObjectProperty()));
        }
        if (target.isOWLDataProperty()) {
            OWLAPIStreamUtils.add(axioms, (Stream)this.getOntology().axioms(target.asOWLDataProperty()));
        }
        if (target.isOWLNamedIndividual()) {
            OWLAPIStreamUtils.add(axioms, (Stream)this.getOntology().axioms((OWLIndividual)target.asOWLNamedIndividual()));
        }
        return axioms;
    }

    protected OWLOntology getOntology() {
        return (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.ont, (String)"ontology has not been set yet");
    }

    @Override
    protected Stream<? extends OWLAxiom> getAxioms(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.getOntology().axioms(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.getOntology().axioms((OWLObjectPropertyExpression)entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.getOntology().axioms(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.getOntology().axioms((OWLIndividual)entity.asOWLNamedIndividual());
        }
        return OWLAPIStreamUtils.empty();
    }

    @Override
    protected void buildIndices() {
        this.reset();
        ExplanationOrdererImplNoManager.AxiomMapBuilder builder = new ExplanationOrdererImplNoManager.AxiomMapBuilder();
        this.currentExplanation.forEach(ax -> ax.accept((OWLAxiomVisitor)builder));
        try {
            if (this.ont != null) {
                this.man.removeOntology((OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.getOntology()));
            }
            this.ont = this.man.createOntology(IRI.create((String)"http://www.semanticweb.org/", (String)("ontology" + RANDOMSTART.incrementAndGet())));
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom ax2 : this.currentExplanation) {
                changes.add(new AddAxiom(this.getOntology(), ax2));
                ax2.accept((OWLAxiomVisitor)builder);
            }
            this.man.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }
}

