/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.graphdb.importrdf.Preload;
import com.ontotext.graphdb.importrdf.ReportError;
import com.ontotext.trree.entitypool.impl.map.SearchResult;
import com.ontotext.trree.entitypool.impl.storage.StoredEntity;
import java.io.IOException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;

public class Resolver
extends Thread
implements ReportError {
    private final Preload preload;
    StoredEntity storedEntity = new StoredEntity();
    boolean forceShutdown = false;

    Resolver(Preload preload) {
        this.preload = preload;
    }

    Preload.TupleBuffer getData() {
        Preload.TupleBuffer data = null;
        while (true) {
            try {
                data = this.preload.queue.take();
                data.reset();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return data;
    }

    void write(long id, Value v, long datatypeId) {
        try {
            if (v instanceof IRI) {
                this.storedEntity.setUri(v.stringValue());
            } else if (v instanceof BNode) {
                this.storedEntity.setBNode(v.stringValue());
            } else if (v instanceof Literal) {
                Literal l = (Literal)v;
                String language = l.getLanguage().orElse(null);
                IRI datatype = l.getDatatype();
                if (language != null) {
                    this.storedEntity.setLanguageLiteral(l.getLabel(), language);
                } else if (datatype != null) {
                    if (datatypeId == 0L) {
                        datatypeId = this.preload.hashmap.find((Value)datatype);
                    }
                    assert (datatypeId != 0L) : "Datatype not present in hashmap!";
                    this.storedEntity.setDatatypeLiteral(l.getLabel(), datatypeId);
                } else {
                    this.storedEntity.setPlainLiteral(l.getLabel());
                }
                if (this.preload.buildLiteralIndexCollections) {
                    this.preload.processLiteral(id, l);
                }
            } else {
                throw new RuntimeException("Unknown entity class: " + String.valueOf(v.getClass()));
            }
            this.preload.estorage.write(id, this.storedEntity);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void writeTriple(long id, Value v, long datatypeId, long subjId, long predId, long objId) {
        try {
            if (v instanceof Triple) {
                this.storedEntity.setTriple(subjId, predId, objId);
            }
            this.preload.estorage.write(id, this.storedEntity);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    long createid(Value v) {
        long subj;
        String lang = null;
        IRI datatype = null;
        long tripleSubj = 0L;
        long triplePred = 0L;
        long tripleObj = 0L;
        long dtId = v instanceof Literal ? ((lang = (String)((Literal)v).getLanguage().orElse(null)) == null ? ((datatype = ((Literal)v).getDatatype()) != null ? this.createid((Value)datatype) : 0L) : 0L) : 0L;
        if (v instanceof Triple) {
            tripleSubj = this.createid((Value)((Triple)v).getSubject());
            triplePred = this.createid((Value)((Triple)v).getPredicate());
            tripleObj = this.createid(((Triple)v).getObject());
        }
        SearchResult sr = this.preload.hashmap.search(v);
        if (!sr.found) {
            subj = sr.hint == 0L ? this.preload.hashmap.addKey((long)sr.hash).id : this.preload.hashmap.addFast(v, sr.hint, sr.hash);
            sr.hint = subj;
        } else {
            subj = sr.hint;
        }
        if (!sr.found) {
            if (v instanceof Triple) {
                this.writeTriple(subj, v, dtId, tripleSubj, triplePred, tripleObj);
                this.preload.processTriple(subj, v, tripleSubj, triplePred, tripleObj);
            } else {
                this.write(subj, v, dtId);
            }
            if (this.preload.entityTypes != null) {
                this.preload.entityTypes.setByValue(subj, v);
            }
        }
        return subj;
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[WHILELOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

