/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.GraphDBConfigParameters;
import com.ontotext.config.Memory;
import com.ontotext.config.Parameter;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.importrdf.BaseLoadTool;
import com.ontotext.graphdb.importrdf.CheckMemory;
import com.ontotext.graphdb.importrdf.PicoUtils;
import com.ontotext.graphdb.importrdf.ReportError;
import com.ontotext.graphdb.importrdf.Resolver;
import com.ontotext.graphdb.importrdf.RestoreManager;
import com.ontotext.graphdb.importrdf.Sorter;
import com.ontotext.load.GraphDBRDFFormatUtils;
import com.ontotext.load.GraphdbRDFLoader;
import com.ontotext.trree.InferencerException;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.ReleaseInfo;
import com.ontotext.trree.RepositoryAdapter;
import com.ontotext.trree.RepositoryProperties;
import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.big.AVLRepository;
import com.ontotext.trree.big.AVLRepositoryConnection;
import com.ontotext.trree.big.collections.CPSOCollection;
import com.ontotext.trree.big.collections.PairCollection;
import com.ontotext.trree.big.collections.PredicateStatisticsCollection;
import com.ontotext.trree.big.collections.StatementCollection;
import com.ontotext.trree.entitypool.EntityPool;
import com.ontotext.trree.entitypool.EntityPoolConnection;
import com.ontotext.trree.entitypool.EntityPoolFactory;
import com.ontotext.trree.entitypool.EntityPoolFactoryException;
import com.ontotext.trree.entitypool.impl.map.HashEntityMapFactory;
import com.ontotext.trree.entitypool.impl.map.PersistedHashMap;
import com.ontotext.trree.entitypool.impl.storage.EntityStorage;
import com.ontotext.trree.entitypool.impl.storage.EntityStorageFactory;
import com.ontotext.trree.entitypool.impl.storage.EntityStorageVersion3;
import com.ontotext.trree.entitypool.impl.storage.EntityTypeStorage;
import com.ontotext.trree.entitypool.impl.storage.StorageType;
import com.ontotext.trree.entitypool.util.DuplicateEntityException;
import com.ontotext.trree.io.FileSystemHealth;
import com.ontotext.trree.plugin.literalsindex.LiteralType;
import com.ontotext.trree.plugin.literalsindex.LiteralsCollectionConnection;
import com.ontotext.trree.plugin.literalsindex.LiteralsIndexPlugin;
import com.ontotext.trree.rules.RuleCompilerException;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.impl.PluginConnectionImpl;
import com.ontotext.trree.transactions.TransactionException;
import com.ontotext.trree.util.AbstractSortedQueue;
import com.ontotext.trree.util.CompressedSortedChunksFileQueue;
import com.ontotext.trree.util.Formats;
import com.ontotext.trree.util.Measurements;
import com.ontotext.trree.util.PushPull;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="preload", defaultValueProvider=PicoUtils.PreloadDefaultProvider.class, description={"Loads data as single non-fragmented repository image. Doesn't run inference."}, separator=" ")
public class Preload
extends BaseLoadTool {
    @CommandLine.Option(names={"-a", "--iterator-cache"}, description={"Iterator cache size. the value will be multiplied by 1024, default is 'auto' e.g. calculated by the tool."}, paramLabel="<arg>", arity="1", converter={PicoUtils.CacheConverter.class}, defaultValue="-1")
    protected static int iteratorCache;
    @CommandLine.Option(names={"-b", "--chunk"}, description={"Chunk size for partial sorting of the queues. use 'm' for millions or 'k' for thousands, default is 'auto' e.g. calculated by the tool."}, paramLabel="<arg>", arity="1", converter={PicoUtils.ChunkConverter.class}, defaultValue="-1")
    protected static int chunkSize;
    @CommandLine.Option(names={"-q", "--queue-folder"}, description={"Folder used to store temporary data."}, paramLabel="<folder>")
    protected static File queueLocation;
    @CommandLine.Option(names={"-r", "--recursive"}, description={"Whether to walk folders recursively."}, defaultValue="false")
    protected static Boolean recursive;
    @CommandLine.Option(names={"-t", "--parsing-tasks"}, paramLabel="<num>", description={"Number of rdf parsers."})
    protected static int parsingTasks;
    @CommandLine.Option(names={"-x", "--restart"}, description={"Whether to restart the load, ignoring any existing recovery points."}, defaultValue="false")
    protected static boolean restartPreload;
    @CommandLine.Option(names={"-y", "--recovery-point-interval"}, paramLabel="<seconds>", description={"The interval at which recovery points are created."}, defaultValue="3600")
    protected static int recoveryPointInterval;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    CompressedSortedChunksFileQueue psoq = null;
    CompressedSortedChunksFileQueue posq = null;
    CompressedSortedChunksFileQueue psot = null;
    CompressedSortedChunksFileQueue post = null;
    CompressedSortedChunksFileQueue cpsoq = null;
    CompressedSortedChunksFileQueue plistsq = null;
    CompressedSortedChunksFileQueue numericsq = null;
    CompressedSortedChunksFileQueue datesq = null;
    Map<String, String> namespaces;
    RepositoryProperties properties;
    LiteralsIndexPlugin literalsIndex;
    PersistedHashMap hashmap;
    EntityStorage estorage;
    EntityTypeStorage entityTypes;
    private EntityPoolConnection econn;
    AVLRepository rep;
    long countResolved = 0L;
    long countSorted = 0L;
    File storage = null;
    String storageLocation = null;
    EntityPool entities;
    boolean buildContextIndex = false;
    boolean buildPredLists = false;
    boolean buildLiteralProperties;
    boolean buildLiteralIndexCollections;
    int bytesPerEntity = 4;
    int entityIndexSize;
    boolean isEntityPoolOnHeap;
    long globalCacheMemory;
    boolean inrecoverMode = false;
    private static int availableCpus;
    private static int processorsToUse;
    private static int NUMBER_OF_PARSING_TASKS;
    private static final int STATEMENT_BUFFER_SIZE;
    private static final int TUPPLE_BUFFER_SIZE = 1000000;
    private static int STATEMENT_BUFFERES;
    private static int TUPLE_BUFFERES;
    public static boolean bMeasure;
    Semaphore fileToProcessSimultenously = null;
    Sorter sorterThread;
    Resolver resolverThread;
    SimpleValueFactory vf = SimpleValueFactory.getInstance();
    int nFiles = 0;
    ExecutorService fileProcessors = null;
    RestoreManager man;
    boolean preadStatCreated = false;
    long timeStart = 0L;
    LinkedBlockingQueue<TripleBuffer> statements = null;
    LinkedBlockingQueue<TripleBuffer> rq = null;
    LinkedBlockingQueue<TupleBuffer> queue = null;
    LinkedBlockingQueue<TupleBuffer> sq = null;
    TupleBuffer END = new TupleBuffer();
    TripleBuffer ENDS;
    HashMap<Long, long[]> map;
    HashMap<Long, long[]> tripleMap;
    int numberOfFilesToProcess;
    long sizeOfFilesToProcess;
    long estimatednumberOfTriples;
    long estimatednumberOfEntities;
    ArrayList<ItemToProcess> enumeratedFiles;
    private static boolean simpleMemoryCheck;
    PSOCIndexData statePSOC;
    POSCIndexData statePOSC;
    PSOTIndexData statePSOT;
    POSTIndexData statePOST;
    RuntimeData stateCPSO;
    RuntimeData statePredLists;
    LiteralsIndexData stateLiterals;
    long num_numbers;
    long num_dates;
    long num_literals;
    TimeZone tz;
    boolean stopHandlers;

    public Preload() {
        this.END.buffer = null;
        this.ENDS = new TripleBuffer();
        this.ENDS.buffer = null;
        this.map = new HashMap();
        this.tripleMap = new HashMap();
        this.numberOfFilesToProcess = 0;
        this.sizeOfFilesToProcess = 0L;
        this.estimatednumberOfTriples = 0L;
        this.estimatednumberOfEntities = 0L;
        this.enumeratedFiles = new ArrayList();
        this.statePSOC = null;
        this.statePOSC = null;
        this.statePSOT = null;
        this.statePOST = null;
        this.stateCPSO = null;
        this.statePredLists = null;
        this.stateLiterals = null;
        this.num_numbers = 0L;
        this.num_dates = 0L;
        this.num_literals = 0L;
        this.tz = TimeZone.getTimeZone("UTC");
        this.stopHandlers = false;
    }

    @Override
    public boolean isRestart() {
        return restartPreload;
    }

    @Override
    protected void validate() {
        super.validate();
        this.validateQueueLocation();
        this.validateRecoverPointInterval();
        FileSystemHealth.getInstance().canStartTransaction("");
    }

    private void validateQueueLocation() {
        if (queueLocation.exists()) {
            if (!queueLocation.isDirectory()) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Location %s for temporary data exists and is not a folder!", queueLocation.getAbsolutePath()));
            }
        } else {
            try {
                boolean mk = queueLocation.mkdirs();
                if (!mk) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Failed to create temporary location folder: %s", queueLocation.getAbsolutePath()));
                }
            }
            catch (SecurityException se) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Do not have rights to create temporary location folder: %s", queueLocation.getAbsolutePath()));
            }
        }
    }

    private void validateRecoverPointInterval() {
        if (recoveryPointInterval < 180) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("'%s' is too short. Please give a value greater than 180", recoveryPointInterval));
        }
    }

    @Override
    protected void logUserInput() {
        LOG.info("Input folders recursively: " + recursive);
        LOG.info("Iterator cache set to: {}", iteratorCache == -1 ? "'auto'" : Integer.valueOf(iteratorCache));
        LOG.info("Chunk size set to: {}", (Object)(chunkSize == -1 ? "'auto'" : Formats.number((long)chunkSize)));
        LOG.info("Parsing tasks: " + parsingTasks);
        LOG.info("Temporary data folder: " + String.valueOf(queueLocation));
        if (restartPreload) {
            LOG.info("Restarting, ignoring recovery points: true");
        }
        LOG.info("Restore point interval: {}s", (Object)Formats.number((long)recoveryPointInterval));
        super.logUserInput();
    }

    @Override
    public Integer call() throws Exception {
        LOG = LoggerFactory.getLogger(Preload.class);
        this.validate();
        this.logUserInput();
        mainProcess = Preload::mainPreloadInternal;
        return this.mainInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainPreloadInternal(OwlimSchemaRepository owlim, GraphDBRepositoryManager localRepositoryManager) throws Exception {
        Preload loader = new Preload();
        loader.setStorage(owlim.getStorageFolder());
        File recoverFrom = null;
        if (!foundRecoverPoint) {
            loader.buildPredLists = (Boolean)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENABLE_PREDICATE_LIST);
            loader.buildContextIndex = (Boolean)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENABLE_CONTEXT_INDEX);
            loader.buildLiteralIndexCollections = (Boolean)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENABLE_LITERAL_INDEX);
            loader.buildLiteralProperties = (Boolean)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_IN_MEMORY_LITERAL_PROPERTIES);
            loader.bytesPerEntity = (Integer)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENTITY_ID_SIZE) / 8;
            loader.entityIndexSize = (int)((Memory)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENTITY_INDEX_SIZE)).getValue();
            loader.isEntityPoolOnHeap = owlim.getParameters().isEnabled(GraphDBConfigParameters.ON_HEAP_ENITY_POOL) || Config.hasOnHeapAllocation();
            loader.globalCacheMemory = ((Memory)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PAGE_CACHE_SIZE)).getValue();
        } else {
            LOG.info("Restore point detected");
            recoverFrom = Preload.preload.preload;
        }
        NUMBER_OF_PARSING_TASKS = parsingTasks;
        STATEMENT_BUFFERES = NUMBER_OF_PARSING_TASKS * 2;
        TUPLE_BUFFERES = NUMBER_OF_PARSING_TASKS * 2;
        try {
            loader.init(recoverFrom);
        }
        catch (IOException ioe) {
            localRepositoryManager.shutDown();
            recoverFrom.delete();
            LOG.error("Failed to init from a recover point! It will be deleted!", (Throwable)ioe);
            return 1;
        }
        catch (RuntimeException re) {
            localRepositoryManager.shutDown();
            LOG.error("memory is not enough or other runtime issue encountered ", (Throwable)re);
            return 1;
        }
        long start = System.currentTimeMillis();
        try {
            loader.start(owlim);
        }
        catch (EntityPoolFactoryException | IOException | RDFHandlerException | RDFParseException e) {
            e.printStackTrace();
        }
        finally {
            long now = System.currentTimeMillis();
            if (!loader.stopHandlers) {
                LOG.info("Processing finished " + Formats.number((long)(now - start)) + "ms. Shutting down ...");
                loader.shutdown();
                LOG.info("Finished in " + Formats.number((long)(System.currentTimeMillis() - start)) + "ms");
            }
            loader.closeQueues();
        }
        return 0;
    }

    public void startInternal() {
        this.timeStart = System.currentTimeMillis();
    }

    public void endInternal() {
        long now = System.currentTimeMillis();
        LOG.info("The parsing took " + Formats.number((long)(now - this.timeStart)) + "ms. Updating entity pool...");
        LOG.info("Entity pool commit took " + Formats.number((long)(System.currentTimeMillis() - now)) + "ms");
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    private void passToResolver(TripleBuffer data) {
        while (true) {
            try {
                this.rq.put(data);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        this.man.releaseSlot();
    }

    void passToSorting(TupleBuffer data) {
        while (true) {
            try {
                this.sq.put(data);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(OwlimSchemaRepository owlim) throws EntityPoolFactoryException, RDFParseException, RDFHandlerException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, RuleCompilerException, InferencerException, TransactionException {
        if (this.storage == null) {
            this.setStorage("storage");
        }
        this.prepare(owlim);
        int permits = NUMBER_OF_PARSING_TASKS;
        this.man.start(permits);
        if (this.man.mode == 1) {
            long startTime = System.currentTimeMillis();
            try {
                this.startInternal();
                for (ItemToProcess item : this.enumeratedFiles) {
                    if (this.stopHandlers) {
                        return;
                    }
                    if (item.completed) continue;
                    this.processSingleFile(item);
                }
            }
            finally {
                for (int i = 0; i < NUMBER_OF_PARSING_TASKS; ++i) {
                    this.fileToProcessSimultenously.acquireUninterruptibly();
                    this.man.parserEnterWait();
                }
                if (this.stopHandlers) {
                    return;
                }
                this.man.lock.lock();
                this.endInternal();
                this.fileProcessors.shutdown();
                while (true) {
                    try {
                        this.rq.put(this.ENDS);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
                try {
                    this.resolverThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while (true) {
                    try {
                        this.sq.put(this.END);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            try {
                this.sorterThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOG.info("Finished in " + Formats.number((long)(System.currentTimeMillis() - startTime)) + "ms, statements: " + Formats.number((long)this.countResolved) + ", sorted: " + Formats.number((long)this.countSorted));
            try {
                this.hashmap.shutdown();
                this.estorage.flush();
                this.estorage.shutdown();
                if (this.entityTypes != null) {
                    this.entityTypes.flush();
                }
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
        } else {
            this.man.lock.lock();
        }
        if (this.man.mode == 1) {
            try {
                this.man.setIndexMode();
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
        }
        if (this.man.mode == 2) {
            this.statePSOC = new PSOCIndexData(this);
            this.statePOSC = new POSCIndexData(this);
            this.statePSOT = new PSOTIndexData(this);
            this.statePOST = new POSTIndexData(this);
            if (this.buildContextIndex) {
                this.stateCPSO = new RuntimeData(this);
            }
            if (this.buildPredLists) {
                this.statePredLists = new RuntimeData(this);
            }
            if (this.buildLiteralIndexCollections) {
                this.stateLiterals = new LiteralsIndexData(this);
            }
            this.man.mode = 3;
        }
        try {
            this.entities = EntityPoolFactory.getInstance().getEntityPool("classic", owlim.getParameters());
            this.entities.initialize();
            if (this.buildLiteralProperties) {
                this.entities.precacheLiteralLanguagesAndDatatypes();
            }
            this.econn = this.entities.getConnection();
            this.rep = new AVLRepository(this.storage.getAbsolutePath(), this.econn, 0, -1, 0, false, this.buildPredLists, this.buildContextIndex, false, ((Integer)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENTITY_ID_SIZE)).intValue(), true);
            this.rep.setSize(this.properties.getNumberOfStatements());
            this.rep.setNumberOfExplicitStatements(this.properties.getNumberOfExplicitStatements());
        }
        catch (DuplicateEntityException e) {
            e.printStackTrace();
        }
        boolean normal = false;
        try {
            this.indexData();
            normal = true;
        }
        finally {
            this.man.shutDown();
            if (normal) {
                this.man.deleteRecoverPointOnSuccess();
            }
        }
    }

    synchronized void updatePredicateStatistics(Map<Long, long[]> predStatsMap, long pred, long count, long subjects) {
        long[] data = predStatsMap.get(pred);
        if (data == null) {
            predStatsMap.put(pred, new long[]{count, subjects, 0L});
        } else {
            data[0] = count;
            data[1] = subjects;
        }
    }

    synchronized void updatePredicateStatistics(Map<Long, long[]> predStatsMap, long pred, long objects) {
        long[] data = predStatsMap.get(pred);
        if (data == null) {
            predStatsMap.put(pred, new long[]{0L, 0L, objects});
        } else {
            data[2] = objects;
        }
    }

    public void writePredicateStatistics(Map<Long, long[]> predStatsMap, DataOutputStream dos) throws IOException {
        dos.writeInt(predStatsMap.size());
        for (Map.Entry<Long, long[]> e : predStatsMap.entrySet()) {
            dos.writeLong(e.getKey());
            long[] val = e.getValue();
            dos.writeInt(val.length);
            for (long l : val) {
                dos.writeLong(l);
            }
        }
    }

    public void readPredicateStatistics(Map<Long, long[]> predStatsMap, DataInputStream dis) throws IOException {
        predStatsMap.clear();
        int size = dis.readInt();
        for (int j = 0; j < size; ++j) {
            long key = dis.readLong();
            int arity = dis.readInt();
            long[] value = new long[arity];
            for (int i = 0; i < value.length; ++i) {
                value[i] = dis.readLong();
            }
            predStatsMap.put(key, value);
        }
    }

    protected void createPredicateStatisticsFromMap(Map<Long, long[]> predStatsMap, PredicateStatisticsCollection.PredicateStatisticsConnection predConn) {
        AtomicLong count = new AtomicLong();
        long start = System.currentTimeMillis();
        LOG.info("Generating collected predicate statistics");
        try {
            predConn.beginTransaction();
            predStatsMap.forEach((pred, value) -> {
                if (value[0] == 0L) {
                    LOG.warn("Wrong count {} for predicate {}", (Object)value[0], pred);
                }
                predConn.set(pred.longValue(), predConn.getCollectionSize(pred.longValue()) + value[0], predConn.getUniqueSubjects(pred.longValue()) + value[1], predConn.getUniqueObjects(pred.longValue()) + value[2]);
                count.addAndGet(value[0]);
            });
            predConn.commit();
        }
        catch (TransactionException e) {
            try {
                predConn.rollback();
            }
            catch (TransactionException e1) {
                e1.printStackTrace();
            }
        }
        LOG.info("Done generating predicate statistics, {} predicates in {} ms, total tuples {}", new Object[]{predStatsMap.size(), Formats.number((long)(System.currentTimeMillis() - start)), Formats.number((long)count.get())});
        this.preadStatCreated = true;
    }

    private String queueFileName(String name) {
        return new File(queueLocation, name).getAbsolutePath();
    }

    private void init(File recoverFrom) throws IOException {
        this.man = new RestoreManager(this);
        if (recoverFrom != null) {
            this.inrecoverMode = true;
            try {
                this.man.initFromRestorePoint(recoverFrom);
                this.man.bDirty = false;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize from a recovery point. restarting!");
                ioe.printStackTrace();
                this.inrecoverMode = false;
                throw ioe;
            }
        }
        if (!this.inrecoverMode) {
            this.analyseInputData();
            this.man.mode = 0;
            this.man.createRestorePoint();
            this.man.mode = 1;
        }
        this.fileProcessors = Executors.newFixedThreadPool(NUMBER_OF_PARSING_TASKS);
        this.fileToProcessSimultenously = new Semaphore(NUMBER_OF_PARSING_TASKS);
        this.statements = new LinkedBlockingQueue(STATEMENT_BUFFERES);
        this.rq = new LinkedBlockingQueue(STATEMENT_BUFFERES - 1);
        this.queue = new LinkedBlockingQueue(TUPLE_BUFFERES);
        this.sq = new LinkedBlockingQueue(TUPLE_BUFFERES - 1);
        if (!this.inrecoverMode || this.man.mode == 0) {
            if (this.man.mode == 0) {
                this.man.mode = 1;
            }
            this.psoq = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("pso_q"), true, AbstractSortedQueue.SortOrder.psoc);
            this.psoq.setIterCache(iteratorCache * 1024);
            this.posq = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("pos_q"), true, AbstractSortedQueue.SortOrder.posc);
            this.posq.setIterCache(iteratorCache * 1024);
            this.psot = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("psot_q"), true, AbstractSortedQueue.SortOrder.psoc);
            this.psot.setIterCache(iteratorCache * 1024);
            this.post = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("post_q"), true, AbstractSortedQueue.SortOrder.posc);
            this.post.setIterCache(iteratorCache * 1024);
            if (this.buildContextIndex) {
                this.cpsoq = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("cpso_q"), true, AbstractSortedQueue.SortOrder.cpso);
                this.cpsoq.setIterCache(iteratorCache * 1024);
            }
            if (this.buildPredLists) {
                this.plistsq = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("plists_q"), true, AbstractSortedQueue.SortOrder.pairAB);
                this.plistsq.setIterCache(iteratorCache * 1024);
            }
            if (this.buildLiteralIndexCollections) {
                this.numericsq = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("num_q"), true, AbstractSortedQueue.SortOrder.pairBA);
                this.numericsq.setIterCache(iteratorCache * 1024);
                this.datesq = new CompressedSortedChunksFileQueue(chunkSize, this.queueFileName("dates_q"), true, AbstractSortedQueue.SortOrder.pairBA);
                this.datesq.setIterCache(iteratorCache * 1024);
            }
        }
        if (bMeasure) {
            Measurements.create();
        }
        if (this.psoq != null) {
            this.psoq.setLogger(LOG, bMeasure ? "pos" : null);
        }
        if (this.posq != null) {
            this.posq.setLogger(LOG, bMeasure ? "pso" : null);
        }
        if (this.psot != null) {
            this.psot.setLogger(LOG, bMeasure ? "post" : null);
        }
        if (this.post != null) {
            this.post.setLogger(LOG, bMeasure ? "psot" : null);
        }
        if (this.cpsoq != null && this.buildContextIndex) {
            this.cpsoq.setLogger(LOG, bMeasure ? "cpso" : null);
        }
        if (this.plistsq != null && this.buildPredLists) {
            this.plistsq.setLogger(LOG, bMeasure ? "plists" : null);
        }
        if (this.buildLiteralIndexCollections) {
            if (this.numericsq != null) {
                this.numericsq.setLogger(LOG, bMeasure ? "numerics" : null);
            }
            if (this.datesq != null) {
                this.datesq.setLogger(LOG, bMeasure ? "dates" : null);
            }
        }
    }

    private long analyseInputData() {
        LOG.info("Analysing input data. It may take a while ...");
        long estimate = 0L;
        for (File fileOrFolder : filesToBeLoaded) {
            if (fileOrFolder.isFile() && fileOrFolder.exists()) {
                long localEst = this.analyseSingleFile(fileOrFolder);
                if (0L < localEst) {
                    this.enumeratedFiles.add(new ItemToProcess(fileOrFolder, false, false, 0L));
                }
                estimate += localEst;
                continue;
            }
            if (!fileOrFolder.isDirectory() || !fileOrFolder.exists()) continue;
            estimate += this.analyseFolder(fileOrFolder);
        }
        if (estimate > 20000000L) {
            estimate += 5000000L - estimate % 5000000L;
        }
        this.estimatednumberOfTriples = estimate;
        this.estimatednumberOfEntities = (estimate << 1) / 7L;
        LOG.info("Dataset:\n\tnumber of files {}\n\ttotal files size {}\n\testimated number of statements {}\n\testimated number of entities {}", new Object[]{this.numberOfFilesToProcess, Formats.formatBytes((long)this.sizeOfFilesToProcess), Formats.number((long)this.estimatednumberOfTriples), Formats.number((long)this.estimatednumberOfEntities)});
        CheckMemory cm = new CheckMemory(this);
        if (simpleMemoryCheck) {
            cm.checkMemorySimple();
        } else {
            cm.checkMemory();
        }
        return estimate;
    }

    private long analyseFolder(File fileOrFolder) {
        File[] list;
        long estimate = 0L;
        for (File item : list = fileOrFolder.listFiles()) {
            if (item.isDirectory()) {
                String itemPath = item.getAbsolutePath();
                if (itemPath.equals(fileOrFolder.getAbsolutePath()) || itemPath.equals(fileOrFolder.getParentFile().getAbsolutePath()) || !recursive.booleanValue()) continue;
                estimate += this.analyseFolder(item);
                continue;
            }
            if (!item.isFile()) continue;
            long localest = this.analyseSingleFile(item);
            if (0L < localest) {
                this.enumeratedFiles.add(new ItemToProcess(item.getAbsolutePath(), false, false, 0L));
            }
            estimate += localest;
        }
        return estimate;
    }

    private long analyseSingleFile(File fileOrFolder) {
        RDFFormat dataFormat;
        int limit_block = 1024;
        long estimate = 0L;
        ++this.numberOfFilesToProcess;
        try {
            dataFormat = GraphDBRDFFormatUtils.extractRDFDataFormat((File)fileOrFolder, null);
        }
        catch (IOException e) {
            throw new RDFHandlerException(e.getMessage());
        }
        if (dataFormat != null) {
            ParserConfig pc = Preload.getParserConfig(true);
            GraphdbRDFLoader loader = new GraphdbRDFLoader(pc, (ValueFactory)SimpleValueFactory.getInstance());
            loader.setBufferSize(1024);
            final AtomicLong counted = new AtomicLong();
            final long size = fileOrFolder.length();
            this.sizeOfFilesToProcess += size;
            final AtomicLong count = new AtomicLong(1L);
            final AtomicLong initial = new AtomicLong(0L);
            try {
                final FileInputStream bis = new FileInputStream(fileOrFolder);
                loader.load((InputStream)bis, "http://base.org/", dataFormat, new RDFHandler(){
                    long toCloseAt = -1L;

                    public void startRDF() throws RDFHandlerException {
                        counted.set(0L);
                    }

                    public void endRDF() throws RDFHandlerException {
                        try {
                            if (bis.getChannel().isOpen()) {
                                count.set(bis.getChannel().position() - initial.get());
                            } else if (count.get() == 0L || count.get() == 1L) {
                                if (size < 128000L) {
                                    count.set(size - initial.get());
                                } else {
                                    count.set(128000L - initial.get());
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new RDFHandlerException("on end", (Throwable)e);
                        }
                    }

                    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                    }

                    public void handleStatement(Statement st) throws RDFHandlerException {
                        try {
                            if (st.getPredicate().equals((Object)SystemGraphs.SYSTEM_TRANSACTION.getUri())) {
                                return;
                            }
                            if (bis.getChannel().isOpen()) {
                                long pos = bis.getChannel().position();
                                if (this.toCloseAt < 0L) {
                                    this.toCloseAt = pos + 131072L;
                                    initial.set(pos);
                                }
                                count.set(pos - initial.get());
                                if (pos > this.toCloseAt) {
                                    bis.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new RDFHandlerException("on handle", (Throwable)e);
                        }
                        counted.incrementAndGet();
                    }

                    public void handleComment(String comment) throws RDFHandlerException {
                    }
                });
            }
            catch (Throwable bis) {
                // empty catch block
            }
            if (count.get() == 0L) {
                if (counted.get() == 0L) {
                    return 0L;
                }
                if (size > 0L) {
                    count.set(size);
                    initial.set(0L);
                }
            }
            double factor = 1.0 * (double)(size - initial.get()) / (double)count.get();
            estimate = (long)(factor * (double)counted.get());
            if (dataFormat.getName().equals("JSON-LD")) {
                estimate = counted.get();
            }
        }
        return estimate;
    }

    private void setStorage(String string) {
        this.storage = new File(string);
        this.storageLocation = this.storage.getAbsolutePath();
        if (this.storage.exists()) {
            if (this.storage.isFile()) {
                LOG.error("Storage " + this.storage.getAbsolutePath() + " exists and is not a folder");
                System.exit(1);
            }
        } else if (!this.storage.mkdirs()) {
            LOG.error("Storage " + this.storage.getAbsolutePath() + " could not be created!");
            System.exit(1);
        }
    }

    public void prepare(OwlimSchemaRepository owlim) throws EntityPoolFactoryException, RuleCompilerException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, InferencerException, TransactionException {
        try {
            ReleaseInfo.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        owlim.doShutDown(true);
        this.properties = new RepositoryProperties(new File(this.storage.getAbsolutePath(), "owlim.properties"));
        if (this.properties.getFile().exists()) {
            RepositoryAdapter.readPropertiesFile((RepositoryProperties)this.properties, (File)this.properties.getFile());
        }
        this.namespaces = new ConcurrentSkipListMap<String, String>(this.properties.readNamespaces());
        if (this.man.mode == 1) {
            while (0 != this.statements.remainingCapacity()) {
                this.statements.add(new TripleBuffer());
            }
            while (0 != this.queue.remainingCapacity()) {
                this.queue.add(new TupleBuffer());
            }
            this.sq.clear();
            this.sorterThread = new Sorter(this);
            this.sorterThread.setName("sorting");
            this.sorterThread.start();
            this.resolverThread = new Resolver(this);
            this.resolverThread.setName("resolver");
            this.resolverThread.start();
            String workDir = owlim.getStorageFolder();
            int keyIndexSize = (int)((Memory)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENTITY_INDEX_SIZE)).getValue();
            int entityIdSize = (Integer)owlim.getParameters().get((Parameter)GraphDBConfigParameters.PARAM_ENTITY_ID_SIZE);
            this.hashmap = HashEntityMapFactory.getInstance().createMap(workDir, keyIndexSize, entityIdSize == 32 ? StorageType.SHORT_32BIT : StorageType.WIDE_40BIT);
            this.estorage = EntityStorageFactory.getInstance().createStorage(workDir, entityIdSize == 32 ? StorageType.SHORT_32BIT : StorageType.WIDE_40BIT, true);
            this.estorage.setEntityIdSizeInBytes(this.hashmap.getEntityIdSizeInBytes());
            ((EntityStorageVersion3)this.estorage).do_not_cache_writes = false;
            if (this.buildLiteralProperties) {
                this.entityTypes = new EntityTypeStorage(workDir, this.hashmap.getEntityIdSizeInBytes(), this.hashmap.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long indexPSOC(StatementCollection.StatementConnection conn, CompressedSortedChunksFileQueue q, String name, PushPull adapter) {
        long[] tuple = q.newTuple();
        long start = System.currentTimeMillis();
        this.statePSOC.adapter = adapter;
        this.statePSOC.q = q;
        try {
            adapter.start();
        }
        catch (Throwable e) {
            this.handleError(null, e);
        }
        this.statePSOC.commitAction = () -> {
            boolean sucess = false;
            try {
                conn.commit();
                sucess = true;
            }
            catch (TransactionException e) {
                try {
                    conn.rollback();
                }
                catch (TransactionException e1) {
                    e1.printStackTrace();
                }
                this.handleError(null, e);
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed PSOC commit"));
                }
                try {
                    conn.beginTransaction();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                    this.handleError(null, e);
                }
            }
        };
        try {
            conn.beginTransaction();
            LOG.info("indexing {}", (Object)name);
            long click = 0L;
            while (adapter.pull(tuple)) {
                boolean added;
                if (this.stopHandlers) {
                    return -1L;
                }
                if (click % 10000000L == 0L) {
                    LOG.info("{} from {}  queue processed ...", (Object)Formats.number((long)this.statePSOC.count), (Object)name);
                }
                ++click;
                if (tuple[1] != this.statePSOC.pred) {
                    if (this.statePSOC.pred != 0L) {
                        this.updatePredicateStatistics(this.map, this.statePSOC.pred, this.statePSOC.predCount, this.statePSOC.uniqueSubjects);
                    }
                    this.statePSOC.pred = tuple[1];
                    this.statePSOC.predCountSum += this.statePSOC.predCount;
                    this.statePSOC.predCount = 0L;
                    this.statePSOC.uniqueSubjects = 0L;
                    this.statePSOC.lastSubj = 0L;
                }
                if (added = conn.add(tuple[0], tuple[1], tuple[2], tuple[3], (int)tuple[4])) {
                    ++this.statePSOC.predCount;
                    if (this.statePSOC.lastSubj != tuple[0]) {
                        ++this.statePSOC.uniqueSubjects;
                        this.statePSOC.lastSubj = tuple[0];
                    }
                }
                if (!added) continue;
                ++this.statePSOC.count;
            }
            if (this.statePSOC.pred != 0L) {
                this.updatePredicateStatistics(this.map, this.statePSOC.pred, this.statePSOC.predCount, this.statePSOC.uniqueSubjects);
            }
            this.statePSOC.predCountSum += this.statePSOC.predCount;
            LOG.info(name + " commit " + Formats.number((long)this.statePSOC.count) + "... cross check from predicate statistics " + Formats.number((long)this.statePSOC.predCountSum) + " statements");
            this.man.lock.lock();
            try {
                this.statePSOC.commitAction = null;
                conn.commit();
                this.statePSOC.done = true;
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                this.man.lock.unlock();
            }
            LOG.info("done");
        }
        catch (TransactionException te) {
            try {
                conn.rollback();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            this.handleError(null, te);
        }
        catch (Throwable te) {
            this.handleError(null, te);
        }
        long now = System.currentTimeMillis();
        LOG.info("enumerated {} in {} ms", (Object)Formats.number((long)this.statePSOC.count), (Object)Formats.number((long)(now - start)));
        LOG.info("closing {} queue", (Object)name);
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
            q.shutdown();
        }
        finally {
            this.man.lock.unlock();
        }
        return this.statePSOC.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexPOSC(StatementCollection.StatementConnection conn, CompressedSortedChunksFileQueue q, String name, PushPull adapter) {
        long[] tuple = q.newTuple();
        long start = System.currentTimeMillis();
        this.statePOSC.adapter = adapter;
        this.statePOSC.q = q;
        try {
            adapter.start();
        }
        catch (Throwable e) {
            this.handleError(null, e);
        }
        this.statePOSC.commitAction = () -> {
            boolean sucess = false;
            try {
                conn.commit();
                sucess = true;
            }
            catch (TransactionException e) {
                try {
                    conn.rollback();
                }
                catch (TransactionException e1) {
                    e1.printStackTrace();
                }
                this.handleError(null, e);
            }
            catch (Throwable e) {
                this.handleError(null, e);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed POCS commit"));
                }
                try {
                    conn.beginTransaction();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                    this.handleError(null, e);
                }
            }
        };
        LOG.info("indexing {}", (Object)name);
        try {
            conn.beginTransaction();
            long click = 0L;
            while (adapter.pull(tuple)) {
                boolean added;
                if (this.stopHandlers) {
                    return;
                }
                if (click % 10000000L == 0L) {
                    LOG.info("{} from {}  queue processed ...", (Object)Formats.number((long)this.statePOSC.count), (Object)name);
                }
                ++click;
                if (tuple[1] != this.statePOSC.pred) {
                    if (this.statePOSC.pred != 0L) {
                        this.updatePredicateStatistics(this.map, this.statePOSC.pred, this.statePOSC.uniqueObjects);
                    }
                    this.statePOSC.pred = tuple[1];
                    this.statePOSC.uniqueObjects = 0L;
                    this.statePOSC.lastObj = 0L;
                }
                if ((added = conn.add(tuple[0], tuple[1], tuple[2], tuple[3], (int)tuple[4])) && this.statePOSC.lastObj != tuple[2]) {
                    ++this.statePOSC.uniqueObjects;
                    this.statePOSC.lastObj = tuple[2];
                }
                if (!added) continue;
                ++this.statePOSC.count;
            }
            if (this.statePOSC.pred != 0L) {
                this.updatePredicateStatistics(this.map, this.statePOSC.pred, this.statePOSC.uniqueObjects);
            }
            LOG.info(name + " commit " + Formats.number((long)this.statePOSC.count) + " statements ...");
            this.man.lock.lock();
            try {
                this.statePOSC.commitAction = null;
                conn.commit();
                this.statePOSC.done = true;
            }
            finally {
                this.man.lock.unlock();
            }
            LOG.info("done");
        }
        catch (TransactionException te) {
            try {
                conn.rollback();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            this.handleError(null, te);
        }
        long now = System.currentTimeMillis();
        LOG.info("enumerated {} in {} ms", (Object)Formats.number((long)this.statePOSC.count), (Object)Formats.number((long)(now - start)));
        LOG.info("closing {} queue", (Object)name);
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
            q.shutdown();
        }
        finally {
            this.man.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexPSOT(StatementCollection.StatementConnection conn, CompressedSortedChunksFileQueue q, String name, PushPull adapter) {
        long[] tuple = q.newTuple();
        long start = System.currentTimeMillis();
        this.statePSOT.adapter = adapter;
        this.statePSOT.q = q;
        try {
            adapter.start();
        }
        catch (Throwable e) {
            this.handleError(null, e);
        }
        this.statePSOT.commitAction = () -> {
            boolean sucess = false;
            try {
                conn.commit();
                sucess = true;
            }
            catch (TransactionException e) {
                try {
                    conn.rollback();
                }
                catch (TransactionException e1) {
                    e1.printStackTrace();
                }
                this.handleError(null, e);
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed PSOT commit"));
                }
                try {
                    conn.beginTransaction();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                    this.handleError(null, e);
                }
            }
        };
        try {
            conn.beginTransaction();
            LOG.info("indexing {}", (Object)name);
            long click = 0L;
            while (adapter.pull(tuple)) {
                boolean added;
                if (this.stopHandlers) {
                    return;
                }
                if (click % 10000000L == 0L) {
                    LOG.info("{} from {}  queue processed ...", (Object)Formats.number((long)this.statePSOT.count), (Object)name);
                }
                ++click;
                if (tuple[1] != this.statePSOT.pred) {
                    if (this.statePSOT.pred != 0L) {
                        this.updatePredicateStatistics(this.tripleMap, this.statePSOT.pred, this.statePSOT.predCount, this.statePSOT.uniqueSubjects);
                    }
                    this.statePSOT.pred = tuple[1];
                    this.statePSOT.predCountSum += this.statePSOT.predCount;
                    this.statePSOT.predCount = 0L;
                    this.statePSOT.uniqueSubjects = 0L;
                    this.statePSOT.lastSubj = 0L;
                }
                if (added = conn.add(tuple[0], tuple[1], tuple[2], tuple[3], (int)tuple[4])) {
                    ++this.statePSOT.predCount;
                    if (this.statePSOT.lastSubj != tuple[0]) {
                        ++this.statePSOT.uniqueSubjects;
                        this.statePSOT.lastSubj = tuple[0];
                    }
                }
                if (!added) continue;
                ++this.statePSOT.count;
            }
            if (this.statePSOT.pred != 0L) {
                this.updatePredicateStatistics(this.tripleMap, this.statePSOT.pred, this.statePSOT.predCount, this.statePSOT.uniqueSubjects);
            }
            this.statePSOT.predCountSum += this.statePSOT.predCount;
            LOG.info(name + " commit " + Formats.number((long)this.statePSOT.count) + "... cross check from predicate statistics " + Formats.number((long)this.statePSOT.predCountSum) + " statements");
            this.man.lock.lock();
            try {
                this.statePSOT.commitAction = null;
                conn.commit();
                this.statePSOT.done = true;
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                this.man.lock.unlock();
            }
            LOG.info("done");
        }
        catch (TransactionException te) {
            try {
                conn.rollback();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            this.handleError(null, te);
        }
        catch (Throwable te) {
            this.handleError(null, te);
        }
        long now = System.currentTimeMillis();
        LOG.info("enumerated {} in {} ms", (Object)Formats.number((long)this.statePSOT.count), (Object)Formats.number((long)(now - start)));
        LOG.info("closing {} queue", (Object)name);
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
            q.shutdown();
        }
        finally {
            this.man.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexPOST(StatementCollection.StatementConnection conn, CompressedSortedChunksFileQueue q, String name, PushPull adapter) {
        long[] tuple = q.newTuple();
        long start = System.currentTimeMillis();
        this.statePOST.adapter = adapter;
        this.statePOST.q = q;
        try {
            adapter.start();
        }
        catch (Throwable e) {
            this.handleError(null, e);
        }
        this.statePOST.commitAction = () -> {
            boolean sucess = false;
            try {
                conn.commit();
                sucess = true;
            }
            catch (TransactionException e) {
                try {
                    conn.rollback();
                }
                catch (TransactionException e1) {
                    e1.printStackTrace();
                }
                this.handleError(null, e);
            }
            catch (Throwable e) {
                this.handleError(null, e);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed POST commit"));
                }
                try {
                    conn.beginTransaction();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                    this.handleError(null, e);
                }
            }
        };
        LOG.info("indexing {}", (Object)name);
        try {
            conn.beginTransaction();
            long click = 0L;
            while (adapter.pull(tuple)) {
                boolean added;
                if (this.stopHandlers) {
                    return;
                }
                if (click % 10000000L == 0L) {
                    LOG.info("{} from {}  queue processed ...", (Object)Formats.number((long)this.statePOST.count), (Object)name);
                }
                ++click;
                if (tuple[1] != this.statePOST.pred) {
                    if (this.statePOST.pred != 0L) {
                        this.updatePredicateStatistics(this.tripleMap, this.statePOST.pred, this.statePOST.uniqueObjects);
                    }
                    this.statePOST.pred = tuple[1];
                    this.statePOST.uniqueObjects = 0L;
                    this.statePOST.lastObj = 0L;
                }
                if ((added = conn.add(tuple[0], tuple[1], tuple[2], tuple[3], (int)tuple[4])) && this.statePOST.lastObj != tuple[2]) {
                    ++this.statePOST.uniqueObjects;
                    this.statePOST.lastObj = tuple[2];
                }
                if (!added) continue;
                ++this.statePOST.count;
            }
            if (this.statePOST.pred != 0L) {
                this.updatePredicateStatistics(this.tripleMap, this.statePOST.pred, this.statePOST.uniqueObjects);
            }
            LOG.info(name + " commit " + Formats.number((long)this.statePOST.count) + " statements ...");
            this.man.lock.lock();
            try {
                this.statePOST.commitAction = null;
                conn.commit();
                this.statePOST.done = true;
            }
            finally {
                this.man.lock.unlock();
            }
            LOG.info("done");
        }
        catch (TransactionException te) {
            try {
                conn.rollback();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            this.handleError(null, te);
        }
        long now = System.currentTimeMillis();
        LOG.info("enumerated {} in {} ms", (Object)Formats.number((long)this.statePOST.count), (Object)Formats.number((long)(now - start)));
        LOG.info("closing {} queue", (Object)name);
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
            q.shutdown();
        }
        finally {
            this.man.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexCPSO(CPSOCollection.CPSOConnection conn, CompressedSortedChunksFileQueue q, String name, PushPull adapter) {
        long[] tuple = q.newTuple();
        long start = System.currentTimeMillis();
        this.stateCPSO.adapter = adapter;
        this.stateCPSO.q = q;
        try {
            adapter.start();
        }
        catch (Throwable e) {
            this.handleError(null, e);
        }
        this.stateCPSO.commitAction = () -> {
            boolean sucess = false;
            try {
                conn.commit();
                sucess = true;
            }
            catch (TransactionException e) {
                try {
                    conn.rollback();
                }
                catch (TransactionException e1) {
                    e1.printStackTrace();
                }
                this.handleError(null, e);
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed CPSO commit"));
                }
                try {
                    conn.beginTransaction();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                    this.handleError(null, e);
                }
            }
        };
        LOG.info("indexing {}", (Object)name);
        try {
            conn.beginTransaction();
            long click = 0L;
            while (adapter.pull(tuple)) {
                if (this.stopHandlers) {
                    return;
                }
                if (click % 10000000L == 0L) {
                    LOG.info("{} from {}  queue processed ...", (Object)Formats.number((long)this.stateCPSO.count), (Object)name);
                }
                ++click;
                boolean added = conn.add(tuple[0], tuple[1], tuple[2], tuple[3], (int)tuple[4]);
                if (!added) continue;
                ++this.stateCPSO.count;
            }
            LOG.info(name + " commit " + this.stateCPSO.count + " statements ...");
            this.man.lock.lock();
            try {
                this.stateCPSO.commitAction = null;
                conn.commit();
                this.stateCPSO.done = true;
            }
            finally {
                this.man.lock.unlock();
            }
            LOG.info("done");
        }
        catch (TransactionException te) {
            try {
                conn.rollback();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            this.handleError(null, te);
        }
        long now = System.currentTimeMillis();
        LOG.info("enumerated {} in {} ms", (Object)Formats.number((long)this.stateCPSO.count), (Object)Formats.number((long)(now - start)));
        LOG.info("closing {} queue", (Object)name);
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
            q.shutdown();
        }
        finally {
            this.man.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long indexPredLists(PairCollection.PairConnection conn, CompressedSortedChunksFileQueue q, String name, PushPull adapter) {
        long[] tuple = q.newTuple();
        this.statePredLists.adapter = adapter;
        this.statePredLists.q = q;
        try {
            adapter.start();
        }
        catch (Throwable e) {
            this.handleError(null, e);
        }
        this.statePredLists.commitAction = () -> {
            boolean sucess = false;
            try {
                conn.commit();
                sucess = true;
            }
            catch (TransactionException e) {
                try {
                    conn.rollback();
                }
                catch (TransactionException e1) {
                    e1.printStackTrace();
                }
                this.handleError(null, e);
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed predlists commit"));
                }
                try {
                    conn.beginTransaction();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                    this.handleError(null, e);
                }
            }
        };
        long start = System.currentTimeMillis();
        LOG.info("indexing {}", (Object)name);
        try {
            conn.beginTransaction();
            long click = 0L;
            while (adapter.pull(tuple)) {
                if (this.stopHandlers) {
                    return -1L;
                }
                if (click % 10000000L == 0L) {
                    LOG.info("{} from {}  queue processed ...", (Object)Formats.number((long)this.statePredLists.count), (Object)name);
                }
                ++click;
                boolean added = conn.add(tuple[0], tuple[1]);
                if (!added) continue;
                ++this.statePredLists.count;
            }
            LOG.info(name + " commit " + Formats.number((long)this.statePredLists.count) + " pairs ...");
            this.man.lock.lock();
            try {
                this.statePredLists.commitAction = null;
                conn.commit();
                this.statePredLists.done = true;
            }
            finally {
                this.man.lock.unlock();
            }
            LOG.info("done");
        }
        catch (TransactionException te) {
            try {
                conn.rollback();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            this.handleError(null, te);
        }
        long now = System.currentTimeMillis();
        LOG.info("{} pairs enum done in {} ms", (Object)name, (Object)Formats.number((long)(now - start)));
        LOG.info("closing {} queue", (Object)name);
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
            q.shutdown();
        }
        finally {
            this.man.lock.unlock();
        }
        return this.statePredLists.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexData() {
        AVLRepositoryConnection conn = this.rep.getConnection();
        int EXPECTED_TASKS = 7;
        int PERMITS = Integer.parseInt(System.getProperty("permits-index", "7"));
        Semaphore permits = new Semaphore(PERMITS);
        Semaphore expected_tasks = new Semaphore(7);
        expected_tasks.acquireUninterruptibly(7);
        AtomicLong count = new AtomicLong();
        try {
            PushPull PLadapter;
            PushPull CPadapter;
            PushPull POTadapter;
            PushPull PSTadapter;
            PushPull POadapter;
            PushPull PSadapter;
            PushPull pushPull = PSadapter = this.psoq == null ? null : new PushPull(16364, arg -> {
                try {
                    return this.psoq.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.psoq.NUMBER_OF_ITEMS_IN_TUPLE);
            if (this.statePSOC != null) {
                this.statePSOC.adapter = PSadapter;
            }
            PushPull pushPull2 = POadapter = this.posq == null ? null : new PushPull(16364, arg -> {
                try {
                    return this.posq.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.posq.NUMBER_OF_ITEMS_IN_TUPLE);
            if (this.statePOSC != null) {
                this.statePOSC.adapter = POadapter;
            }
            PushPull pushPull3 = PSTadapter = this.psot == null ? null : new PushPull(16364, arg -> {
                try {
                    return this.psot.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.psot.NUMBER_OF_ITEMS_IN_TUPLE);
            if (this.statePSOT != null) {
                this.statePSOT.adapter = PSTadapter;
            }
            PushPull pushPull4 = POTadapter = this.post == null ? null : new PushPull(16364, arg -> {
                try {
                    return this.post.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.post.NUMBER_OF_ITEMS_IN_TUPLE);
            if (this.statePOST != null) {
                this.statePOST.adapter = POTadapter;
            }
            PushPull pushPull5 = CPadapter = this.cpsoq != null && this.buildContextIndex ? new PushPull(16364, arg -> {
                try {
                    return this.cpsoq.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.cpsoq.NUMBER_OF_ITEMS_IN_TUPLE) : null;
            if (this.stateCPSO != null) {
                this.stateCPSO.adapter = CPadapter;
            }
            PushPull pushPull6 = PLadapter = this.plistsq != null && this.buildPredLists ? new PushPull(16364, arg -> {
                try {
                    return this.plistsq.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.plistsq.NUMBER_OF_ITEMS_IN_TUPLE) : null;
            if (this.statePredLists != null) {
                this.statePredLists.adapter = PLadapter;
            }
            if (this.stateLiterals != null) {
                if (this.stateLiterals.mode == 0) {
                    this.stateLiterals.adapter = new PushPull(16364, arg -> {
                        try {
                            return this.numericsq.get(arg);
                        }
                        catch (Throwable t) {
                            this.handleError(null, t);
                            return false;
                        }
                    }, this.numericsq.NUMBER_OF_ITEMS_IN_TUPLE);
                } else if (this.stateLiterals.mode == 1) {
                    this.stateLiterals.adapter = new PushPull(16364, arg -> {
                        try {
                            return this.datesq.get(arg);
                        }
                        catch (Throwable t) {
                            this.handleError(null, t);
                            return false;
                        }
                    }, this.datesq.NUMBER_OF_ITEMS_IN_TUPLE);
                }
            }
            ExecutorService es = Executors.newFixedThreadPool(PERMITS);
            if (this.buildLiteralIndexCollections && this.stateLiterals != null) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-literals");
                    permits.acquireUninterruptibly();
                    try {
                        this.indexLiterals();
                    }
                    catch (RuntimeException re) {
                        LOG.error("Literal index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            } else {
                expected_tasks.release();
            }
            if (PSadapter != null) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-PSOC");
                    permits.acquireUninterruptibly();
                    try {
                        count.set(this.indexPSOC(conn.getPsoConnection(), this.psoq, "PSOC", PSadapter));
                    }
                    catch (RuntimeException re) {
                        LOG.error("PSOC index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            } else {
                expected_tasks.release();
            }
            if (POadapter != null) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-POSC");
                    permits.acquireUninterruptibly();
                    try {
                        this.indexPOSC(conn.getPosConnection(), this.posq, "POSC", POadapter);
                    }
                    catch (RuntimeException re) {
                        LOG.error("POSC index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            }
            if (CPadapter != null && this.buildContextIndex) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-CPSO");
                    permits.acquireUninterruptibly();
                    try {
                        this.indexCPSO(conn.getCpsoConnection(), this.cpsoq, "CPSO", CPadapter);
                    }
                    catch (RuntimeException re) {
                        LOG.error("CPSO index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            } else {
                expected_tasks.release();
            }
            if (PLadapter != null && this.buildPredLists) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-predlists");
                    permits.acquireUninterruptibly();
                    try {
                        this.indexPredLists(conn.getPredListsConnection(), this.plistsq, "predlists", PLadapter);
                    }
                    catch (RuntimeException re) {
                        LOG.error("Predicate list index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            } else {
                expected_tasks.release();
            }
            if (PSTadapter != null) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-PSOT");
                    permits.acquireUninterruptibly();
                    try {
                        this.indexPSOT(conn.getPSOTConnection(), this.psot, "PSOT", PSTadapter);
                    }
                    catch (RuntimeException re) {
                        LOG.error("PSOT index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            } else {
                expected_tasks.release();
            }
            if (POTadapter != null) {
                es.execute(() -> {
                    Thread.currentThread().setName("index-POST");
                    permits.acquireUninterruptibly();
                    try {
                        this.indexPOST(conn.getPOSTConnection(), this.post, "POST", POTadapter);
                    }
                    catch (RuntimeException re) {
                        LOG.error("POST index preload failed!", (Throwable)re);
                        this.handleError(null, re);
                    }
                    finally {
                        permits.release();
                        expected_tasks.release();
                    }
                });
            } else {
                expected_tasks.release();
            }
            this.man.lock.unlock();
            expected_tasks.acquireUninterruptibly(7);
            this.man.lock.lock();
            try {
                es.shutdown();
                this.createPredicateStatisticsFromMap(this.map, conn.getPredicateStatisticsConnection());
                this.createPredicateStatisticsFromMap(this.tripleMap, conn.getTrPredicateStatisticsConnection());
            }
            finally {
                this.man.lock.unlock();
            }
        }
        finally {
            this.rep.setNumberOfExplicitStatements(this.rep.numberOfExplicitStatements() + count.get());
            this.rep.setSize(this.rep.size() + count.get());
            conn.close();
        }
    }

    private void processSingleFile(ItemToProcess item) throws RDFParseException, RDFHandlerException, IOException {
        this.fileToProcessSimultenously.acquireUninterruptibly();
        this.fileProcessors.execute(() -> {
            File file = new File(item.absolutePath);
            Thread.currentThread().setName("parsing-" + file.getName());
            if (this.man.isInCreateRestore()) {
                LOG.info("ouch");
            }
            try {
                try {
                    item.started = true;
                    this.processSingleFileInternal(file, item.currentParsedTupple);
                }
                catch (Exception e) {
                    LOG.error("processing file {}", (Object)item.absolutePath, (Object)e);
                    e.printStackTrace();
                }
                finally {
                    item.completed = true;
                }
            }
            finally {
                this.fileToProcessSimultenously.release();
            }
        });
    }

    private void processSingleFileInternal(final File file, AtomicLong parsedCount) throws RDFParseException, RDFHandlerException, IOException {
        LOG.info("Loading file: " + file.getName());
        ParserConfig cfg = Preload.getParserConfig(true);
        cfg.set((RioSetting)BasicParserSettings.VERIFY_URI_SYNTAX, (Object)false);
        cfg.set((RioSetting)XMLParserSettings.FAIL_ON_INVALID_NCNAME, (Object)false);
        cfg.set((RioSetting)XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID, (Object)false);
        GraphdbRDFLoader loader = new GraphdbRDFLoader(cfg, (ValueFactory)this.vf);
        final FileInputStream fin = new FileInputStream(file);
        final AtomicBoolean stop = new AtomicBoolean(false);
        Thread t = new Thread(this){

            @Override
            public void run() {
                this.setName("monitor file position");
                while (!stop.get()) {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (stop.get()) continue;
                    FileChannel ch = fin.getChannel();
                    try {
                        BaseLoadTool.LOG.info("File " + file.getName() + " processed to position " + Formats.number((long)ch.position()) + " from " + Formats.number((long)file.length()) + " bytes");
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        t.start();
        BufferedInputStream r = new BufferedInputStream(fin, 0x100000);
        RDFFormat dataFormat = null;
        try {
            dataFormat = (RDFFormat)Rio.getParserFormatForFileName((String)file.getName()).orElseThrow(() -> new UnsupportedRDFormatException("Could not find RDF format for file: " + file.getName()));
            loader.load((InputStream)r, "http://base.org", dataFormat, (RDFHandler)new LocalHandler(parsedCount));
        }
        catch (RDFParseException e) {
            LOG.error("Error while parsing the file: {}", (Object)e.getMessage());
            this.man.releaseSlot();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        stop.set(true);
        t.interrupt();
        LOG.info("Parsed " + Formats.number((long)parsedCount.get()) + " statements. Resolved statements so far: " + Formats.number((long)this.countResolved) + " pre-indexed tuples " + Formats.number((long)this.countSorted));
        ++this.nFiles;
    }

    void processLiteral(long id, Literal v) {
        LiteralType type = LiteralType.of((Literal)v);
        switch (type) {
            case NUMERIC: {
                try {
                    double value = v.doubleValue();
                    long bits = Double.doubleToLongBits(value);
                    this.numericsq.push(id, bits);
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Literal not a number: {}", (Object)v.stringValue());
                }
                ++this.num_numbers;
                break;
            }
            case DATE: {
                try {
                    GregorianCalendar c = v.calendarValue().normalize().toGregorianCalendar(this.tz, null, null);
                    long bits = c.getTimeInMillis();
                    this.datesq.push(id, bits);
                }
                catch (Exception e) {
                    LOG.warn("Literal {} not a date", (Object)v.stringValue());
                }
                ++this.num_dates;
                break;
            }
        }
    }

    void processTriple(long id, Value v, long tripleSubj, long triplePred, long tripleObj) {
        this.psot.push(tripleSubj, triplePred, tripleObj, id, 2L);
        this.post.push(tripleSubj, triplePred, tripleObj, id, 2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexLiterals() {
        LiteralsCollectionConnection conn;
        if (this.stateLiterals.mode == 3) {
            return;
        }
        LOG.info("enum numeric and date literals");
        this.literalsIndex = new LiteralsIndexPlugin();
        this.literalsIndex.setLogger(LOG);
        this.literalsIndex.setDataDir(new File(this.storage, "literals-index"));
        this.econn = this.entities.getConnection();
        this.econn.begin();
        this.literalsIndex.skip_rebuild = true;
        PluginConnectionImpl pluginConnection = new PluginConnectionImpl(null, this.econn.getEntities(), null, null, null, 0L, false, null);
        this.literalsIndex.initialize(InitReason.DEFAULT, (PluginConnection)pluginConnection);
        long[] tuple = null;
        this.stateLiterals.commitAction = () -> {
            boolean sucess = false;
            try {
                this.econn.precommit();
                this.econn.commit();
                sucess = true;
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            finally {
                if (!sucess) {
                    this.handleError(null, new Error("failed literal index commit"));
                }
                this.econn.begin();
            }
        };
        if (this.stateLiterals.mode == 0) {
            LOG.info("Processing numerics queue " + Formats.number((long)this.num_numbers) + " to add");
            tuple = this.numericsq.newTuple();
            this.stateLiterals.q = this.numericsq;
            try {
                this.stateLiterals.adapter.start();
            }
            catch (Throwable e) {
                this.handleError(null, e);
            }
            conn = this.literalsIndex.getConnectionForType(LiteralType.NUMERIC);
            try {
                conn.beginTransaction();
                while (this.stateLiterals.adapter.pull(tuple)) {
                    if (this.stopHandlers) {
                        return;
                    }
                    conn.add(tuple[0], tuple[1]);
                    ++this.stateLiterals.count;
                    if ((double)this.stateLiterals.count % 1000000.0 != 0.0) continue;
                    LOG.info("added " + Formats.number((long)this.stateLiterals.count) + " numbers so far ");
                }
                conn.commit();
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            this.man.lock.lock();
            try {
                this.stateLiterals.adapter = null;
                this.stateLiterals.mode = 1;
            }
            finally {
                this.man.lock.unlock();
            }
        }
        if (this.stateLiterals.mode == 1) {
            if (tuple == null) {
                tuple = this.datesq.newTuple();
            }
            LOG.info("Processing dates queue " + Formats.number((long)this.num_dates) + " to add");
            conn = this.literalsIndex.getConnectionForType(LiteralType.DATE);
            this.man.lock.lock();
            this.stateLiterals.count = 0L;
            this.stateLiterals.adapter = new PushPull(16364, arg -> {
                try {
                    return this.datesq.get(arg);
                }
                catch (Throwable t) {
                    this.handleError(null, t);
                    return false;
                }
            }, this.datesq.NUMBER_OF_ITEMS_IN_TUPLE);
            try {
                this.stateLiterals.adapter.start();
            }
            catch (Throwable e) {
                this.handleError(null, e);
            }
            this.stateLiterals.q = this.datesq;
            this.man.lock.unlock();
            try {
                conn.beginTransaction();
                while (this.stateLiterals.adapter.pull(tuple)) {
                    if (this.stopHandlers) {
                        return;
                    }
                    conn.add(tuple[0], tuple[1]);
                    ++this.stateLiterals.count;
                    if ((double)this.stateLiterals.count % 1000000.0 != 0.0) continue;
                    LOG.info("added " + Formats.number((long)this.stateLiterals.count) + " dates so far ");
                }
                conn.commit();
            }
            catch (Throwable t) {
                this.handleError(null, t);
            }
            this.stateLiterals.mode = 2;
        }
        this.man.lock.lock();
        try {
            this.stateLiterals.done = true;
            this.stateLiterals.commitAction = null;
            LOG.info("done!. Commiting literals index...");
            this.econn.precommit();
            this.econn.commit();
            this.stateLiterals.mode = 3;
        }
        catch (Throwable t) {
            this.handleError(null, t);
        }
        finally {
            this.man.lock.unlock();
            LOG.info("done!.");
        }
        try {
            this.literalsIndex.shutdown(ShutdownReason.DEFAULT);
        }
        catch (Throwable t) {
            LOG.error("literals index commit", t);
            this.handleError(null, t);
        }
        LOG.info("Literals index created");
        this.man.lock.lock();
        try {
            this.man.createRestorePoint();
        }
        catch (Throwable t) {
            this.handleError(null, t);
        }
        finally {
            this.man.lock.unlock();
        }
        this.numericsq.shutdown();
        this.datesq.shutdown();
    }

    public void shutdown() {
        this.econn.precommit();
        this.econn.commit();
        LOG.info("epool commited phase 2, entities {}", (Object)Formats.number((long)this.econn.size()));
        this.properties.setNumberOfEntities(this.econn.size());
        this.properties.setNumberOfExplicitStatements(this.rep.numberOfExplicitStatements());
        this.properties.setNumberOfStatements(this.rep.size());
        this.properties.setSafeMode(true);
        this.properties.setSuccessfulCommits(1L);
        this.properties.setVersion(80);
        this.properties.setNumberOfBNodes(1L);
        this.properties.setFingerprint(-355380292462L);
        this.properties.setPluginsFingerprint("[GeoSPARQL=0][autocomplete=0][dependencies-plugin=0][direct=0][expose-entity=0][geospatial=0][literals-index=0][lucene=0][lucene-connector=0][magic-predicates=0][notifications=0][plugincontrol=0][rdfrank=0][script=0][sparql-mm=0]");
        this.properties.setNamespaces(this.namespaces);
        RepositoryAdapter.writePropertiesFile((RepositoryProperties)this.properties, (File)this.properties.getFile());
        if (this.rep != null) {
            LOG.info("shutting down repository collections");
            this.rep.shutdown();
            LOG.info("done");
        }
        if (bMeasure && Measurements.getInstance() != null) {
            System.out.println(Measurements.getInstance().report());
        }
        if (this.econn != null) {
            this.econn.close();
        }
        if (this.entities != null) {
            this.entities.shutdown();
        }
    }

    public void closeQueues() {
        if (this.psoq != null) {
            this.psoq.shutdown();
        }
        if (this.posq != null) {
            this.posq.shutdown();
        }
        if (this.psot != null) {
            this.psot.shutdown();
        }
        if (this.post != null) {
            this.post.shutdown();
        }
        if (this.cpsoq != null) {
            this.cpsoq.shutdown();
        }
        if (this.plistsq != null) {
            this.plistsq.shutdown();
        }
        if (this.numericsq != null) {
            this.numericsq.shutdown();
        }
        if (this.datesq != null) {
            this.datesq.shutdown();
        }
    }

    public void handleError(ReportError agent, Throwable e) {
        e.printStackTrace();
        if (this.stopHandlers) {
            return;
        }
        this.stopHandlers = true;
        if (this.man.hook != null) {
            if (testing) {
                this.man.shutDown();
            } else {
                Runtime.getRuntime().removeShutdownHook(this.man.hook);
            }
            this.man.hook = null;
        }
        if (this.man.mode == 1) {
            this.fileProcessors.shutdownNow();
            if (agent == this.sorterThread || agent == this.man) {
                this.resolverThread.forceShutdown();
                try {
                    this.resolverThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (agent == this.resolverThread || agent == this.man) {
                this.sorterThread.forceShutdown();
                try {
                    this.sorterThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (agent != this.man) {
            this.man.shutDown();
        }
        if (testing) {
            throw new RuntimeException("Failed!", e);
        }
        System.exit(1);
    }

    static {
        availableCpus = Runtime.getRuntime().availableProcessors();
        processorsToUse = availableCpus > 2 ? availableCpus / 2 : 1;
        NUMBER_OF_PARSING_TASKS = Integer.parseInt(System.getProperty("parsing-tasks", "" + Math.min(processorsToUse, 6)));
        STATEMENT_BUFFER_SIZE = Integer.parseInt(System.getProperty("statement-buffer-size", "10000"));
        STATEMENT_BUFFERES = NUMBER_OF_PARSING_TASKS * 2;
        TUPLE_BUFFERES = NUMBER_OF_PARSING_TASKS * 2;
        bMeasure = Boolean.parseBoolean(System.getProperty("measure", "false"));
        simpleMemoryCheck = true;
    }

    static class TupleBuffer {
        long[] buffer = new long[5000000];
        int pos = 0;

        TupleBuffer() {
        }

        void add(long number) {
            this.buffer[this.pos++] = number;
        }

        void reset() {
            this.pos = 0;
        }
    }

    static class TripleBuffer {
        Value[] buffer = new Value[STATEMENT_BUFFER_SIZE * 4];
        int pos = 0;

        TripleBuffer() {
        }

        void add(Value st) {
            this.buffer[this.pos++] = st;
        }

        void reset() {
            this.pos = 0;
        }
    }

    class PSOCIndexData
    extends RuntimeData {
        long pred = 0L;
        long predCount = 0L;
        long predCountSum = 0L;
        long uniqueSubjects = 0L;
        long lastSubj = 0L;

        public PSOCIndexData(Preload this$0) {
            super(this$0);
        }

        public PSOCIndexData(Preload this$0, DataInputStream dis) throws IOException {
            super(this$0, dis);
            this.pred = dis.readLong();
            this.predCount = dis.readLong();
            this.predCountSum = dis.readLong();
            this.uniqueSubjects = dis.readLong();
            this.lastSubj = dis.readLong();
        }

        @Override
        public void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.pred);
            dos.writeLong(this.predCount);
            dos.writeLong(this.predCountSum);
            dos.writeLong(this.uniqueSubjects);
            dos.writeLong(this.lastSubj);
        }
    }

    class POSCIndexData
    extends RuntimeData {
        long pred = 0L;
        long uniqueObjects = 0L;
        long lastObj = 0L;

        POSCIndexData(Preload this$0) {
            super(this$0);
        }

        public POSCIndexData(Preload this$0, DataInputStream dis) throws IOException {
            super(this$0, dis);
            this.pred = dis.readLong();
            this.uniqueObjects = dis.readLong();
            this.lastObj = dis.readLong();
        }

        @Override
        public void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.pred);
            dos.writeLong(this.uniqueObjects);
            dos.writeLong(this.lastObj);
        }
    }

    class PSOTIndexData
    extends RuntimeData {
        long pred = 0L;
        long predCount = 0L;
        long predCountSum = 0L;
        long uniqueSubjects = 0L;
        long lastSubj = 0L;

        public PSOTIndexData(Preload this$0) {
            super(this$0);
        }

        public PSOTIndexData(Preload this$0, DataInputStream dis) throws IOException {
            super(this$0, dis);
            this.pred = dis.readLong();
            this.predCount = dis.readLong();
            this.predCountSum = dis.readLong();
            this.uniqueSubjects = dis.readLong();
            this.lastSubj = dis.readLong();
        }

        @Override
        public void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.pred);
            dos.writeLong(this.predCount);
            dos.writeLong(this.predCountSum);
            dos.writeLong(this.uniqueSubjects);
            dos.writeLong(this.lastSubj);
        }
    }

    class POSTIndexData
    extends RuntimeData {
        long pred = 0L;
        long uniqueObjects = 0L;
        long lastObj = 0L;

        POSTIndexData(Preload this$0) {
            super(this$0);
        }

        public POSTIndexData(Preload this$0, DataInputStream dis) throws IOException {
            super(this$0, dis);
            this.pred = dis.readLong();
            this.uniqueObjects = dis.readLong();
            this.lastObj = dis.readLong();
        }

        @Override
        public void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.pred);
            dos.writeLong(this.uniqueObjects);
            dos.writeLong(this.lastObj);
        }
    }

    class RuntimeData {
        boolean done = false;
        long count = 0L;
        PushPull adapter = null;
        Runnable commitAction = null;
        CompressedSortedChunksFileQueue q = null;

        RuntimeData(Preload this$0) {
        }

        RuntimeData(Preload this$0, DataInputStream dis) throws IOException {
            this.count = dis.readLong();
        }

        void write(DataOutputStream dos) throws IOException {
            dos.writeLong(this.count);
        }
    }

    class LiteralsIndexData
    extends RuntimeData {
        int mode = 0;

        LiteralsIndexData(Preload this$0) {
            super(this$0);
        }

        LiteralsIndexData(Preload this$0, DataInputStream dis) throws IOException {
            super(this$0, dis);
            this.mode = dis.readInt();
        }

        @Override
        void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeInt(this.mode);
        }
    }

    static class ItemToProcess {
        String absolutePath;
        boolean started;
        boolean completed;
        AtomicLong currentParsedTupple = new AtomicLong();

        public ItemToProcess(String name, boolean started, boolean completed, long count) {
            this.absolutePath = name;
            this.started = started;
            this.completed = completed;
            this.currentParsedTupple.set(count);
        }

        public ItemToProcess(File file, boolean started, boolean completed, long count) {
            this.absolutePath = file.getAbsolutePath();
            this.started = started;
            this.completed = completed;
            this.currentParsedTupple.set(count);
        }
    }

    class LocalHandler
    implements RDFHandler {
        long localCount = 0L;
        AtomicLong parsedcount;
        TripleBuffer tp;
        boolean bCheckManDirty;
        private FileSystemHealth.DiskChecker diskChecker;

        LocalHandler(AtomicLong counter) {
            this.parsedcount = counter;
            boolean bl = this.bCheckManDirty = counter.get() > 0L;
            if (this.bCheckManDirty) {
                BaseLoadTool.LOG.info("Skip already processed statements " + Formats.number((long)this.parsedcount.get()));
            } else {
                Preload.this.man.bDirty = true;
            }
        }

        public void startRDF() throws RDFHandlerException {
            this.diskChecker = FileSystemHealth.getInstance().createOperationBasedDiskCheck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatement(Statement st) throws RDFHandlerException {
            if (Preload.this.stopHandlers) {
                throw new Error("abort parsing ...");
            }
            if (st.getPredicate().equals((Object)SystemGraphs.SYSTEM_TRANSACTION.getUri())) {
                return;
            }
            this.diskChecker.check();
            if (this.localCount < this.parsedcount.get()) {
                if (Preload.this.man.enter.get()) {
                    Preload.this.man.lock.lock();
                    try {
                        BaseLoadTool.LOG.info("Pause parsing from {} ... while looping over already processed triples!", (Object)Thread.currentThread().getName());
                        Preload.this.man.parserEnterWait();
                        Preload.this.man.forParsers.awaitUninterruptibly();
                    }
                    finally {
                        Preload.this.man.parserLeaveWait();
                        Preload.this.man.lock.unlock();
                        BaseLoadTool.LOG.info("Resume parsing from {} ... while looping over already processed triples", (Object)Thread.currentThread().getName());
                    }
                }
                ++this.localCount;
                return;
            }
            if (this.tp == null) {
                while (true) {
                    try {
                        this.tp = Preload.this.statements.take();
                        long nano = System.currentTimeMillis();
                        boolean bLogResume = false;
                        if (Preload.this.man.enter.get()) {
                            Preload.this.man.lock.lock();
                            try {
                                BaseLoadTool.LOG.info("Pause parsing from {} ...", (Object)Thread.currentThread().getName());
                                bLogResume = true;
                                Preload.this.man.parserEnterWait();
                                Preload.this.man.forParsers.awaitUninterruptibly();
                            }
                            finally {
                                Preload.this.man.parserLeaveWait();
                                Preload.this.man.lock.unlock();
                            }
                        }
                        Preload.this.man.allocateSlot();
                        if (bLogResume) {
                            BaseLoadTool.LOG.info("Resume parsing from {} ...", (Object)Thread.currentThread().getName());
                        }
                        if (System.currentTimeMillis() - nano <= 500L) break;
                        BaseLoadTool.LOG.debug("Resume should start at " + String.valueOf(st));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            if (this.bCheckManDirty) {
                Preload.this.man.setDirtyInPhaseOne();
                BaseLoadTool.LOG.debug("Parse started handling at " + this.localCount + " statement! Current statement is " + String.valueOf(st));
                this.bCheckManDirty = false;
            }
            this.tp.add((Value)st.getSubject());
            this.tp.add((Value)st.getPredicate());
            this.tp.add(st.getObject());
            this.tp.add((Value)st.getContext());
            ++this.localCount;
            if (this.tp.pos >= this.tp.buffer.length) {
                Preload.this.passToResolver(this.tp);
                this.parsedcount.set(this.localCount);
                this.tp = null;
            }
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            Preload.this.handleNamespace(prefix, uri);
        }

        public void handleComment(String comment) throws RDFHandlerException {
        }

        public void endRDF() throws RDFHandlerException {
            if (this.tp != null) {
                Preload.this.passToResolver(this.tp);
                this.parsedcount.set(this.localCount);
                this.tp = null;
            } else {
                Preload.this.man.releaseSlot();
            }
        }
    }
}

