/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.graphdb.importrdf.BaseLoadTool;
import com.ontotext.graphdb.importrdf.Load;
import com.ontotext.graphdb.importrdf.Preload;
import com.ontotext.raft.config.ClusterRio;
import java.util.Arrays;
import picocli.CommandLine;

@CommandLine.Command(name="importrdf", subcommands={Load.class, Preload.class, CommandLine.HelpCommand.class}, separator=" ")
class ImportRDF
implements Runnable {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display this message and exit!"})
    boolean help;

    ImportRDF() {
    }

    @Override
    public void run() {
    }

    public static void main(String ... args) {
        if (ClusterRio.isClusterEnabled()) {
            System.err.println("ImportRDF tool not supported in cluster mode.");
            System.exit(2);
        }
        CommandLine cmd = new CommandLine((Object)new ImportRDF()).setCaseInsensitiveEnumValuesAllowed(true);
        if (args.length > 0) {
            System.exit(cmd.execute(args));
        } else {
            System.err.println("Missing command.");
            cmd.usage(System.err);
            System.exit(2);
        }
    }

    public static void preloadMainForTest(String ... args) throws Exception {
        ImportRDF.test("preload", args);
    }

    public static void loadMainForTest(String ... args) throws Exception {
        ImportRDF.test("load", args);
    }

    static void test(String subcommand, String ... args) throws Exception {
        block3: {
            BaseLoadTool.testing = true;
            int N = args.length;
            args = Arrays.copyOf(args, N + 1);
            System.arraycopy(args, 0, args, 1, N);
            args[0] = subcommand;
            CommandLine cmd = new CommandLine((Object)new ImportRDF()).setCaseInsensitiveEnumValuesAllowed(true);
            CommandLine.ParseResult[] parseResult = new CommandLine.ParseResult[1];
            cmd.clearExecutionResults();
            parseResult[0] = cmd.parseArgs(args);
            try {
                int result = cmd.getExecutionStrategy().execute(parseResult[0]);
                assert (result == 0) : "Got " + result + " from the child process";
            }
            catch (CommandLine.ExecutionException e) {
                if (!(e.getCause() instanceof Exception)) break block3;
                throw (Exception)e.getCause();
            }
        }
    }
}

