/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import com.ontotext.graphdb.importrdf.BaseLoadTool;
import com.ontotext.graphdb.importrdf.MemoryUtil;
import com.ontotext.graphdb.importrdf.Preload;
import com.ontotext.trree.util.Formats;

public class CheckMemory {
    Preload PD;
    long maxDirect;
    long freeDirect;
    long maxHeap;
    long freeHeap;
    long commonHeap;
    long tupleBytes = 40L;
    long pairBytes = 16L;
    long entIndex;
    long num_indexed;
    long nonheap;
    boolean isChunkFixed;
    boolean isIterCacheFixed;
    int MAX_CHUNK = 50000000;
    final int STEP_CHUNK = 100000;
    int NUM_CHUNK_PROBES;
    int NUM_ITERCACHE_PROBES;
    final int MAX_ITERCACHE = 128;
    final int STEP_ITERCACHE = 2;
    double WEIGHT_PER_IO = 5000.0;
    long queueMinHeap;
    long tupleIterMem;
    long pairIterMem;
    long globalMaxHeapFromChunk;
    int minGlobalChunk = -1;
    long bestICHeap = -1L;
    int globalIC = -1;

    public CheckMemory(Preload pd) {
        this.PD = pd;
    }

    public void initMemory() {
        long newIndex;
        MemoryUtil util = new MemoryUtil();
        util.gc();
        this.maxDirect = util.directMax();
        this.freeDirect = util.directFree();
        this.maxHeap = util.heapMax();
        this.freeHeap = util.heapFree();
        if (this.PD.estimatednumberOfTriples < (long)this.MAX_CHUNK) {
            this.MAX_CHUNK = 5000000;
        }
        this.entIndex = this.PD.entityIndexSize;
        while (this.entIndex * 4L < this.PD.estimatednumberOfEntities && this.entIndex < 0x1FFFFFFFL && (newIndex = this.entIndex * 16L) <= 0x1FFFFFFFL) {
            this.entIndex = newIndex;
        }
        this.num_indexed = this.PD.estimatednumberOfEntities * 15L / 100L;
        this.nonheap = this.PD.estimatednumberOfEntities * (long)(8 + this.PD.bytesPerEntity) + this.entIndex * (long)this.PD.bytesPerEntity;
        if (this.entIndex > (long)this.PD.entityIndexSize) {
            BaseLoadTool.LOG.info("Expected to end up with entityIndexSzie of {} starting with initial value of {}", (Object)Formats.number((long)this.entIndex), (Object)Formats.number((long)this.PD.entityIndexSize));
        }
        this.commonHeap = 0x70000000L;
        this.commonHeap += this.PD.globalCacheMemory;
        if (this.PD.isEntityPoolOnHeap) {
            Preload.LOG.warn("Entity pool was set to 'on-heap' no off-heap memory {} will be used!", (Object)Formats.number((long)this.nonheap));
            this.commonHeap += this.nonheap;
            this.nonheap = 0L;
        }
        if (this.nonheap > this.freeDirect) {
            throw new RuntimeException("Insufficient direct memory, need " + Formats.number((long)this.nonheap) + " but the amount avaliable is " + Formats.number((long)this.freeDirect));
        }
        this.isChunkFixed = Preload.chunkSize != -1;
        this.isIterCacheFixed = Preload.iteratorCache != -1;
        this.NUM_CHUNK_PROBES = this.isChunkFixed ? 1 : this.MAX_CHUNK / 100000;
        this.NUM_ITERCACHE_PROBES = this.isIterCacheFixed ? 1 : 64;
        Preload.LOG.info("FreeHeap=" + Formats.number((long)this.freeHeap) + "\tcommonHeap=" + Formats.number((long)this.commonHeap));
        this.queueMinHeap = this.freeHeap - this.commonHeap;
        this.tupleIterMem = 1024L * this.tupleBytes * 2L;
        this.pairIterMem = 1024L * this.pairBytes * 2L;
    }

    public int computeChunkSizeSimple() {
        this.globalMaxHeapFromChunk = -1L;
        long maxHeapFromChunk = -1L;
        int chunk_size = this.isChunkFixed ? Preload.chunkSize : 100000;
        int selected_chunk_size = -1;
        long memPerIndex = this.PD.estimatednumberOfTriples / 990L * 72L;
        long memForAllIndexes = 2L * memPerIndex * 2L;
        if (this.PD.buildContextIndex) {
            memForAllIndexes += 2L * memPerIndex;
        }
        if (this.PD.buildPredLists) {
            memForAllIndexes += 2L * memPerIndex;
        }
        this.commonHeap += memForAllIndexes;
        this.queueMinHeap -= memForAllIndexes;
        Preload.LOG.info("Set min heap requirements={}\tmem for indexes={}", (Object)Formats.number((long)this.queueMinHeap), (Object)Formats.number((long)memForAllIndexes));
        int ch = 0;
        while (ch < this.NUM_CHUNK_PROBES) {
            long tupleQueueHeapBytes = (2L * this.tupleBytes + 28L) * (long)chunk_size;
            long pairQueueHeapBytes = (2L * this.pairBytes + 28L) * (long)chunk_size;
            long memAllTupleQueues = tupleQueueHeapBytes;
            memAllTupleQueues = this.PD.buildContextIndex ? (memAllTupleQueues *= 5L) : (memAllTupleQueues *= 4L);
            long predlistsHeap = 0L;
            if (this.PD.buildPredLists) {
                predlistsHeap = pairQueueHeapBytes;
            }
            long literalIndexMem = 0L;
            if (this.PD.buildLiteralIndexCollections) {
                literalIndexMem = pairQueueHeapBytes * 2L;
            }
            long heap = memAllTupleQueues + predlistsHeap + literalIndexMem;
            if (this.globalMaxHeapFromChunk < 0L) {
                this.globalMaxHeapFromChunk = heap;
                this.minGlobalChunk = chunk_size;
            }
            if (heap < this.queueMinHeap && maxHeapFromChunk < heap) {
                maxHeapFromChunk = this.globalMaxHeapFromChunk = heap;
                selected_chunk_size = chunk_size;
            }
            ++ch;
            chunk_size += 100000;
        }
        return selected_chunk_size;
    }

    public int computeIterCacheSimple(int chunk_size) {
        int lit_iters;
        if (chunk_size <= 0) {
            return -1;
        }
        long num_iters = this.PD.estimatednumberOfTriples / (long)chunk_size;
        if (num_iters < 1L) {
            num_iters = 1L;
        }
        if ((lit_iters = (int)(this.num_indexed / (long)chunk_size)) < 1) {
            lit_iters = 1;
        }
        double complexityPerChunk = (double)this.PD.estimatednumberOfTriples * Math.log10((double)num_iters + 0.001) / Math.log10(2.0);
        double minComplexity = -1.0;
        int bestIC = -1;
        long globalMinHeap = -1L;
        double[] ioPerNumItersAndIterCache = new double[this.NUM_ITERCACHE_PROBES];
        int[] valueIterCache = new int[this.NUM_ITERCACHE_PROBES];
        if (this.isIterCacheFixed) {
            valueIterCache[0] = Preload.iteratorCache;
            ioPerNumItersAndIterCache[0] = this.PD.estimatednumberOfTriples / (long)(valueIterCache[0] * 1024);
        } else {
            int i = 0;
            int ic = 2;
            while (i < ioPerNumItersAndIterCache.length) {
                valueIterCache[i] = ic;
                ioPerNumItersAndIterCache[i] = this.PD.estimatednumberOfTriples / (long)(ic * 1024);
                ++i;
                ic += 2;
            }
        }
        for (int ic = 0; ic < this.NUM_ITERCACHE_PROBES; ++ic) {
            long tripleIterMem;
            int iter_cache = valueIterCache[ic];
            long iter_cache_per_tuple_q = (long)iter_cache * this.tupleIterMem;
            long memAllTupleQueues = num_iters * iter_cache_per_tuple_q;
            memAllTupleQueues = this.PD.buildContextIndex ? (memAllTupleQueues *= 3L) : (memAllTupleQueues *= 2L);
            long predlistsHeap = 0L;
            if (this.PD.buildPredLists) {
                predlistsHeap = 2L * num_iters * ((long)iter_cache * this.pairIterMem);
            }
            long literalIndexMem = 0L;
            long litIterMem = (long)(lit_iters * iter_cache) * this.pairIterMem;
            if (this.PD.buildLiteralIndexCollections) {
                literalIndexMem = litIterMem;
            }
            long tripleIndexMem = 0L;
            tripleIndexMem = tripleIterMem = (long)(lit_iters * iter_cache) * this.tupleIterMem;
            long heap = memAllTupleQueues + predlistsHeap + literalIndexMem + tripleIndexMem;
            double currentComplexity = complexityPerChunk + ioPerNumItersAndIterCache[ic] * this.WEIGHT_PER_IO;
            if (globalMinHeap < 0L) {
                globalMinHeap = heap;
                this.globalIC = iter_cache;
                this.bestICHeap = heap;
            } else if (globalMinHeap > heap) {
                globalMinHeap = heap;
                this.globalIC = iter_cache;
            }
            if (heap >= this.queueMinHeap) continue;
            if (minComplexity < 0.0) {
                minComplexity = currentComplexity;
                bestIC = iter_cache;
                this.bestICHeap = heap;
                continue;
            }
            if (!(currentComplexity <= minComplexity)) continue;
            minComplexity = currentComplexity;
            bestIC = iter_cache;
            this.bestICHeap = heap;
        }
        return bestIC;
    }

    public void checkMemorySimple() {
        long heap;
        this.initMemory();
        int chunk_size = this.computeChunkSizeSimple();
        int ic = -1;
        if (chunk_size > 0) {
            ic = this.computeIterCacheSimple(chunk_size);
        }
        if ((heap = this.globalMaxHeapFromChunk) < this.bestICHeap) {
            heap = this.bestICHeap;
        }
        BaseLoadTool.LOG.info("Memory estimation:\n\tfree heap\t{}\tmax heap\t{}\n\tfree non-heap\t{}\tmax non-heap\t{}\n\tneed heap\t{}\n\tneed non-heap\t{}", new Object[]{Formats.number((long)this.freeHeap), Formats.number((long)this.maxHeap), Formats.number((long)this.freeDirect), Formats.number((long)this.maxDirect), Formats.number((long)(this.commonHeap + heap)), Formats.number((long)this.nonheap)});
        if (ic <= 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Not enough heap, need at least ").append(Formats.number((long)(heap + this.commonHeap)));
            msg.append(" calculated with ").append(this.isChunkFixed ? "'fixed'" : "'auto'").append(" --chunk=").append(chunk_size > 0 ? chunk_size : this.minGlobalChunk);
            msg.append(" and ").append(this.isIterCacheFixed ? "'fixed'" : "'auto'").append(" --iter.cache=").append(this.globalIC);
            msg.append(" , free:").append(Formats.number((long)this.freeHeap));
            throw new RuntimeException(msg.toString());
        }
        BaseLoadTool.LOG.info("Calculated using {} --chunk={}, {} --iter.cache={}, heap for parsing {}, heap for indexing {}", new Object[]{this.isChunkFixed ? "'fixed" : "'auto'", Formats.number((long)chunk_size), this.isIterCacheFixed ? "'fixed" : "'auto'", Formats.number((long)ic), Formats.number((long)this.globalMaxHeapFromChunk), Formats.number((long)this.bestICHeap)});
        Preload.chunkSize = chunk_size;
        Preload.iteratorCache = ic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMemory() {
        this.initMemory();
        long[][] memPerChunkAndIter = new long[this.NUM_CHUNK_PROBES][];
        double[] complexityPerChunk = new double[this.NUM_CHUNK_PROBES];
        int[] valueChunk = new int[this.NUM_CHUNK_PROBES];
        double[] ioPerNumItersAndIterCache = new double[this.NUM_ITERCACHE_PROBES];
        int[] valueIterCache = new int[this.NUM_ITERCACHE_PROBES];
        if (this.isIterCacheFixed) {
            valueIterCache[0] = Preload.iteratorCache;
            ioPerNumItersAndIterCache[0] = this.PD.estimatednumberOfTriples / (long)(valueIterCache[0] * 1024);
        } else {
            int i = 0;
            int ic = 2;
            while (i < ioPerNumItersAndIterCache.length) {
                valueIterCache[i] = ic;
                ioPerNumItersAndIterCache[i] = this.PD.estimatednumberOfTriples / (long)(ic * 1024);
                ++i;
                ic += 2;
            }
        }
        double minComplexity = -1.0;
        int bestChIndex = 0;
        int bestIhIndex = 0;
        long globalMinHeap = -1L;
        int globalChIndex = 0;
        int globalIhIndex = 0;
        try {
            long chunk_size = this.isChunkFixed ? (long)Preload.chunkSize : 100000L;
            int ch = 0;
            while (ch < this.NUM_CHUNK_PROBES) {
                memPerChunkAndIter[ch] = new long[this.NUM_ITERCACHE_PROBES];
                valueChunk[ch] = (int)chunk_size;
                long tupleQueueHeapBytes = 2L * this.tupleBytes * chunk_size;
                long num_iters = this.PD.estimatednumberOfTriples / chunk_size;
                if (num_iters < 1L) {
                    num_iters = 1L;
                }
                complexityPerChunk[ch] = (double)this.PD.estimatednumberOfTriples * Math.log10(num_iters) / Math.log10(2.0);
                long pairQueueHeapBytes = 2L * this.pairBytes * chunk_size;
                int lit_iters = (int)(this.num_indexed / chunk_size);
                if (lit_iters < 1) {
                    lit_iters = 1;
                }
                for (int ic = 0; ic < this.NUM_ITERCACHE_PROBES; ++ic) {
                    long iter_cache = valueIterCache[ic];
                    long iter_cache_per_tuple_q = iter_cache * this.tupleIterMem;
                    long memAllTupleQueues = tupleQueueHeapBytes;
                    memAllTupleQueues += num_iters * iter_cache_per_tuple_q;
                    memAllTupleQueues = this.PD.buildContextIndex ? (memAllTupleQueues *= 3L) : (memAllTupleQueues *= 2L);
                    long predlistsHeap = 0L;
                    if (this.PD.buildPredLists) {
                        predlistsHeap = pairQueueHeapBytes;
                        predlistsHeap += 2L * num_iters * (iter_cache * this.pairIterMem);
                    }
                    long literalIndexMem = 0L;
                    long litIterMem = (long)lit_iters * iter_cache * this.pairIterMem;
                    if (this.PD.buildLiteralIndexCollections) {
                        literalIndexMem = pairQueueHeapBytes * 2L;
                        literalIndexMem += litIterMem;
                    }
                    long heap = memAllTupleQueues + predlistsHeap + literalIndexMem;
                    double currentComplexity = complexityPerChunk[ch] + ioPerNumItersAndIterCache[ic] * this.WEIGHT_PER_IO;
                    if (globalMinHeap < 0L || heap < globalMinHeap) {
                        globalMinHeap = heap;
                        globalChIndex = ch;
                        globalIhIndex = ic;
                    }
                    if (heap < this.queueMinHeap && (minComplexity < 0.0 || currentComplexity < minComplexity)) {
                        minComplexity = currentComplexity;
                        bestChIndex = ch;
                        bestIhIndex = ic;
                    }
                    memPerChunkAndIter[ch][ic] = heap;
                }
                ++ch;
                chunk_size += 100000L;
            }
        }
        catch (Throwable throwable) {
            long heap = minComplexity <= 0.0 ? memPerChunkAndIter[globalChIndex][globalIhIndex] : memPerChunkAndIter[bestChIndex][bestIhIndex];
            BaseLoadTool.LOG.info("Memory estimation:\n\tfree heap\t{}\tmax heap\t{}\n\tfree non-heap\t{}\tmax non-heap\t{}\n\tneed heap\t{}\n\tneed non-heap\t{}", new Object[]{Formats.number((long)this.freeHeap), Formats.number((long)this.maxHeap), Formats.number((long)this.freeDirect), Formats.number((long)this.maxDirect), Formats.number((long)(this.commonHeap + heap)), Formats.number((long)this.nonheap)});
            if (minComplexity <= 0.0) {
                StringBuilder msg = new StringBuilder();
                msg.append("Not enough heap, need at least ").append(Formats.number((long)(globalMinHeap + this.commonHeap)));
                msg.append(" calculated with ").append(this.isChunkFixed ? "'fixed'" : "'auto'").append(" --chunk=").append(valueChunk[globalChIndex]);
                msg.append(" and ").append(this.isIterCacheFixed ? "'fixed'" : "'auto'").append(" --iter.cache=").append(valueIterCache[globalIhIndex]);
                msg.append(" , free:").append(Formats.number((long)this.freeHeap));
                throw new RuntimeException(msg.toString());
            }
            BaseLoadTool.LOG.info("Calculated using {} --chunk={}, {} --iterator-cache={}", new Object[]{this.isChunkFixed ? "'fixed" : "'auto'", Formats.number((long)valueChunk[bestChIndex]), this.isIterCacheFixed ? "'fixed" : "'auto'", Formats.number((long)valueIterCache[bestIhIndex])});
            Preload.chunkSize = valueChunk[bestChIndex];
            Preload.iteratorCache = valueIterCache[bestIhIndex];
            throw throwable;
        }
        long heap = minComplexity <= 0.0 ? memPerChunkAndIter[globalChIndex][globalIhIndex] : memPerChunkAndIter[bestChIndex][bestIhIndex];
        BaseLoadTool.LOG.info("Memory estimation:\n\tfree heap\t{}\tmax heap\t{}\n\tfree non-heap\t{}\tmax non-heap\t{}\n\tneed heap\t{}\n\tneed non-heap\t{}", new Object[]{Formats.number((long)this.freeHeap), Formats.number((long)this.maxHeap), Formats.number((long)this.freeDirect), Formats.number((long)this.maxDirect), Formats.number((long)(this.commonHeap + heap)), Formats.number((long)this.nonheap)});
        if (minComplexity <= 0.0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Not enough heap, need at least ").append(Formats.number((long)(globalMinHeap + this.commonHeap)));
            msg.append(" calculated with ").append(this.isChunkFixed ? "'fixed'" : "'auto'").append(" --chunk=").append(valueChunk[globalChIndex]);
            msg.append(" and ").append(this.isIterCacheFixed ? "'fixed'" : "'auto'").append(" --iter.cache=").append(valueIterCache[globalIhIndex]);
            msg.append(" , free:").append(Formats.number((long)this.freeHeap));
            throw new RuntimeException(msg.toString());
        }
        BaseLoadTool.LOG.info("Calculated using {} --chunk={}, {} --iterator-cache={}", new Object[]{this.isChunkFixed ? "'fixed" : "'auto'", Formats.number((long)valueChunk[bestChIndex]), this.isIterCacheFixed ? "'fixed" : "'auto'", Formats.number((long)valueIterCache[bestIhIndex])});
        Preload.chunkSize = valueChunk[bestChIndex];
        Preload.iteratorCache = valueIterCache[bestIhIndex];
    }
}

