/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.types;

import com.useekm.indexing.GeoConstants;
import com.useekm.types.AbstractGeo;
import com.useekm.types.AbstractGeoSerializer;
import com.useekm.types.GeoConvert;
import com.useekm.types.GeoWktGz;
import com.useekm.types.exception.InvalidGeometryException;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.rdf4j.model.IRI;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public final class WktGzSerializer
extends AbstractGeoSerializer {
    public static final WktGzSerializer INTANCE = new WktGzSerializer();

    private WktGzSerializer() {
    }

    @Override
    public String toLiteral(Geometry geometry) {
        return new String(Base64.encodeBase64((byte[])AbstractGeo.gzip(new WKTWriter().write(geometry).getBytes())));
    }

    @Override
    public Geometry toGeometry(String value) throws InvalidGeometryException {
        return value.isEmpty() ? GeoConvert.getEmptyGeometry() : GeoConvert.wktToGeometry(new String(AbstractGeo.gunzip(Base64.decodeBase64((byte[])value.getBytes()))));
    }

    @Override
    public AbstractGeo toGeo(String value) {
        return new GeoWktGz(value);
    }

    @Override
    public IRI getDatatype() {
        return GeoConstants.XMLSCHEMA_SPATIAL_TEXTGZ;
    }

    @Override
    public Class<? extends AbstractGeo> getGeoClass() {
        return GeoWktGz.class;
    }
}

