/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.types;

import com.useekm.indexing.GeoConstants;
import com.useekm.types.AbstractGeo;
import com.useekm.types.AbstractGeoSerializer;
import com.useekm.types.GeoConvert;
import com.useekm.types.GeoWkb;
import com.useekm.types.exception.InvalidGeometryException;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.rdf4j.model.IRI;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;

public final class WkbSerializer
extends AbstractGeoSerializer {
    public static final WkbSerializer INTANCE = new WkbSerializer();

    private WkbSerializer() {
    }

    @Override
    public String toLiteral(Geometry geometry) {
        return new String(Base64.encodeBase64((byte[])new WKBWriter().write(geometry)));
    }

    @Override
    public Geometry toGeometry(String value) throws InvalidGeometryException {
        return value.isEmpty() ? GeoConvert.getEmptyGeometry() : AbstractGeo.binaryToGeometry(Base64.decodeBase64((byte[])value.getBytes()));
    }

    @Override
    public AbstractGeo toGeo(String value) {
        return new GeoWkb(value);
    }

    @Override
    public IRI getDatatype() {
        return GeoConstants.XMLSCHEMA_SPATIAL_BIN;
    }

    @Override
    public Class<? extends AbstractGeo> getGeoClass() {
        return GeoWkb.class;
    }
}

