/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.types;

import com.useekm.indexing.GeoFactory;
import com.useekm.types.GeoConvert;
import com.useekm.types.exception.InvalidGeometryException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.Validate;
import org.eclipse.rdf4j.model.IRI;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public abstract class AbstractGeo {
    private String value;
    private static final String HEXES = "0123456789ABCDEF";

    protected AbstractGeo(String value) {
        Validate.notNull((Object)value);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public abstract IRI getType();

    public abstract Geometry getGeo() throws InvalidGeometryException;

    public Geometry getSafeGeo() {
        try {
            return this.getGeo();
        }
        catch (InvalidGeometryException e) {
            return GeoConvert.getEmptyGeometry();
        }
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractGeo) {
            return this.value.equals(((AbstractGeo)other).value) && this.getType().equals((Object)((AbstractGeo)other).getType());
        }
        return false;
    }

    public String toString() {
        try {
            return this.getGeo().toText();
        }
        catch (InvalidGeometryException e) {
            return "Invalid geometry: " + e.getMessage();
        }
    }

    public static byte[] gunzip(byte[] bytes) {
        try {
            int len;
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            BufferedInputStream bufis = new BufferedInputStream(new GZIPInputStream(bis));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = bufis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            byte[] result = bos.toByteArray();
            bufis.close();
            bos.close();
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException on inmemory gunzip", e);
        }
    }

    public static byte[] gzip(byte[] bytes) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedOutputStream bufos = new BufferedOutputStream(new GZIPOutputStream(bos));
            bufos.write(bytes);
            bufos.close();
            byte[] retval = bos.toByteArray();
            bos.close();
            return retval;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException on inmemory gzip", e);
        }
    }

    static String asHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    static Geometry binaryToGeometry(byte[] bytes) throws InvalidGeometryException {
        WKBReader reader = new WKBReader(GeoFactory.getDefaultGeometryFactory());
        try {
            return reader.read(bytes);
        }
        catch (ParseException e) {
            throw new InvalidGeometryException("Invalid geo WKB: " + AbstractGeo.asHex(bytes), e);
        }
    }
}

