/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.geosparql;

import com.useekm.geosparql.AbstractLiteralBinaryFunction;
import com.useekm.geosparql.GeometryFunction;
import com.useekm.indexing.GeoConstants;
import com.useekm.indexing.GeoFactory;
import com.useekm.types.GeoConvert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.distance.DistanceOp;

public class ShortestLine
extends AbstractLiteralBinaryFunction
implements GeometryFunction {
    public String getURI() {
        return GeoConstants.EXT_SHORTEST_LINE.stringValue();
    }

    @Override
    protected Literal evaluate(ValueFactory valueFactory, IRI geotype, Geometry geom1, Geometry geom2, Value ... originals) {
        DistanceOp distOp = new DistanceOp(geom1, geom2);
        LineString result = GeoFactory.getDefaultGeometryFactory().createLineString(distOp.nearestPoints());
        return GeoConvert.toLiteralExpr(valueFactory, (Geometry)result, geotype);
    }
}

