/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql.lucene;

import com.ontotext.trree.geosparql.EntityGeometryIterator;
import com.ontotext.trree.geosparql.GeoSparqlConfig;
import com.ontotext.trree.geosparql.GeoSparqlIndexer;
import com.ontotext.trree.geosparql.GeoSparqlPlugin;
import com.ontotext.trree.geosparql.lucene.LuceneEntityGeometryIterator;
import com.ontotext.trree.sdk.PluginException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.slf4j.Logger;

public class LuceneGeoIndexer
implements GeoSparqlIndexer {
    private static final FieldType GEO_DATA_FIELD_TYPE = new FieldType();
    private GeoSparqlPlugin parent;
    private JtsSpatialContext ctx;
    private SpatialStrategy strategy;
    private Path indexDir;
    private Directory directory;
    private IndexWriterConfig iwConfig;
    private IndexWriter indexWriter;
    private Logger logger;

    public LuceneGeoIndexer(GeoSparqlPlugin parent) {
        this.parent = parent;
    }

    @Override
    public void initialize() throws Exception {
        this.logger = this.parent.getLogger();
        this.ctx = JtsSpatialContext.GEO;
        this.indexDir = GeoSparqlConfig.resolveIndexPath(this.parent.getDataDir().toPath());
        this.directory = FSDirectory.open((Path)this.indexDir);
        this.initSettings();
    }

    private Document newGeoDocument(long id, Geometry geometry) {
        Document doc = new Document();
        doc.add((IndexableField)new LongPoint("id", new long[]{id}));
        doc.add((IndexableField)new StoredField("id", id));
        JtsGeometry shape = new JtsGeometry(geometry, this.ctx, true, true);
        shape.index();
        for (Field f : this.strategy.createIndexableFields((Shape)shape)) {
            doc.add((IndexableField)f);
        }
        doc.add((IndexableField)LuceneGeoIndexer.geometryToField(geometry));
        return doc;
    }

    @Override
    public void initSettings() {
        QuadPrefixTree grid;
        GeoSparqlConfig.PrefixTree prefixTree = this.parent.getConfig().getCurrentPrefixTree();
        int precision = this.parent.getConfig().getCurrentPrecision();
        if (prefixTree == GeoSparqlConfig.PrefixTree.QUAD) {
            grid = new QuadPrefixTree((SpatialContext)this.ctx, precision);
        } else if (prefixTree == GeoSparqlConfig.PrefixTree.GEOHASH) {
            grid = new GeohashPrefixTree((SpatialContext)this.ctx, precision);
        } else {
            throw new PluginException("Unexpected prefix tree type: " + String.valueOf((Object)prefixTree));
        }
        RecursivePrefixTreeStrategy rptStrategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)grid, "geoData1");
        SerializedDVStrategy sdvStrategy = new SerializedDVStrategy((SpatialContext)this.ctx, "geoData2");
        this.strategy = new CompositeSpatialStrategy("geoData", rptStrategy, sdvStrategy);
    }

    @Override
    public void begin() throws Exception {
        this.iwConfig = new IndexWriterConfig();
        this.iwConfig.setUseCompoundFile(false);
        this.iwConfig.setMaxBufferedDocs(this.parent.getConfig().getMaxBufferedDocs());
        this.iwConfig.setRAMBufferSizeMB(this.parent.getConfig().getRamBufferSizeMb());
        this.indexWriter = new IndexWriter(this.directory, this.iwConfig);
    }

    @Override
    public void commit() throws Exception {
        this.indexWriter.close();
    }

    @Override
    public void rollback() throws Exception {
        this.indexWriter.rollback();
    }

    @Override
    public void freshIndex() throws Exception {
        this.indexWriter.deleteAll();
    }

    @Override
    public void indexGeometryList(long subject, Function<Long, String> subjectMapper, List<Geometry> geometries) {
        try {
            this.indexWriter.deleteDocuments(new Query[]{LongPoint.newExactQuery((String)"id", (long)subject)});
            if (!geometries.isEmpty()) {
                for (Geometry geometry : geometries) {
                    this.indexWriter.addDocument((Iterable)this.newGeoDocument(subject, geometry));
                }
            }
        }
        catch (Exception e) {
            this.handleCreateDocumentUnhandledException(subject, subjectMapper, e);
        }
    }

    @Override
    public void indexGeometry(long subject, Function<Long, String> subjectMapper, Geometry geometry) {
        try {
            this.indexWriter.addDocument((Iterable)this.newGeoDocument(subject, geometry));
        }
        catch (Exception e) {
            this.handleCreateDocumentUnhandledException(subject, subjectMapper, e);
        }
    }

    private EntityGeometryIterator getDisjointObjects(Geometry geometry) {
        JtsGeometry shape = new JtsGeometry(geometry, this.ctx, true, true);
        shape.index();
        SpatialArgs args = new SpatialArgs(SpatialOperation.Intersects, (Shape)shape);
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST).add(this.strategy.makeQuery(args), BooleanClause.Occur.MUST_NOT).build();
        return this.getIteratorForQuery((Query)query);
    }

    @Override
    public EntityGeometryIterator getMatchingObjects(Geometry geometry, SpatialOperation spatialOperation) {
        if (spatialOperation == SpatialOperation.IsDisjointTo) {
            return this.getDisjointObjects(geometry);
        }
        JtsGeometry shape = new JtsGeometry(geometry, this.ctx, true, true);
        shape.index();
        SpatialArgs args = new SpatialArgs(spatialOperation, (Shape)shape);
        Query query = this.strategy.makeQuery(args);
        return this.getIteratorForQuery(query);
    }

    @Override
    public EntityGeometryIterator getGeometriesFor(long subject) {
        Object query = subject > 0L ? LongPoint.newExactQuery((String)"id", (long)subject) : new MatchAllDocsQuery();
        return this.getIteratorForQuery((Query)query);
    }

    private EntityGeometryIterator getIteratorForQuery(Query query) {
        DirectoryReader indexReader = null;
        try {
            indexReader = DirectoryReader.open((Directory)this.directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            return new LuceneEntityGeometryIterator(indexSearcher, query);
        }
        catch (Exception e) {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new PluginException("Unable to execute Lucene query.", (Throwable)e);
        }
    }

    private static Field geometryToField(Geometry geometry) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(geometry);
            oos.close();
            return new Field("geoData", bos.toByteArray(), (IndexableFieldType)GEO_DATA_FIELD_TYPE);
        }
        catch (Exception e) {
            throw new PluginException("Unable to create field from geometry.", (Throwable)e);
        }
    }

    private void handleCreateDocumentUnhandledException(long subject, Function<Long, String> subjectMapper, Exception e) {
        String subjectIri = subjectMapper.apply(subject);
        if (!this.parent.getConfig().isIgnoreErrors()) {
            throw new PluginException("Could not create GeoDocument for subject " + subjectIri + "\nIf you want to ignore this message and still build the index configure ignoreErrors = true (refer to documentation) and rebuild the index", (Throwable)e);
        }
        this.logger.warn("Could not create GeoDocument for subject " + subjectIri, (Throwable)e);
    }

    static Geometry fieldValueToGeometry(byte[] fieldValue) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValue);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Geometry)ois.readObject();
        }
        catch (Exception e) {
            throw new PluginException("Unable to create geometry from field value.", (Throwable)e);
        }
    }

    static {
        GEO_DATA_FIELD_TYPE.setStored(true);
        GEO_DATA_FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
        GEO_DATA_FIELD_TYPE.freeze();
    }
}

