/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.ontotext.trree.geosparql.GeoSparqlConfig;
import com.ontotext.trree.geosparql.GeoSparqlPlugin;
import com.ontotext.trree.geosparql.util.GeoSparqlUtils;
import com.ontotext.trree.sdk.ParallelTransactionListener;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.locationtech.jts.geom.Geometry;

class GeoSparqlUpdateListener
implements ParallelTransactionListener,
StatementListener {
    private final GeoSparqlPlugin parent;
    private final long asWKT;
    private final long asGML;
    private final long hasDefaultGeometry;
    private TLongHashSet geometriesToUpdate = new TLongHashSet();
    private TLongHashSet featuresToUpdate = new TLongHashSet();

    GeoSparqlUpdateListener(GeoSparqlPlugin parent, long asWKT, long asGML, long hasDefaultGeometry) {
        this.parent = parent;
        this.asWKT = asWKT;
        this.asGML = asGML;
        this.hasDefaultGeometry = hasDefaultGeometry;
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        if (!this.parent.getConfig().isEnabled()) {
            return false;
        }
        if (predicate == this.asWKT || predicate == this.asGML) {
            this.geometriesToUpdate.add(subject);
        } else if (predicate == this.hasDefaultGeometry) {
            this.featuresToUpdate.add(subject);
        }
        return false;
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        if (!this.parent.getConfig().isEnabled()) {
            return false;
        }
        if (predicate == this.asWKT || predicate == this.asGML) {
            this.geometriesToUpdate.add(subject);
        } else if (predicate == this.hasDefaultGeometry) {
            this.featuresToUpdate.add(subject);
        }
        return false;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.parent.tmpPrefixTree = null;
        this.parent.tmpPrecision = 0;
        if (!this.parent.getConfig().isEnabled()) {
            return;
        }
        try {
            this.parent.indexer.begin();
        }
        catch (Exception e) {
            throw new PluginException("Unable to start indexer transaction.", (Throwable)e);
        }
    }

    public void transactionCommit(final PluginConnection pluginConnection) {
        if (this.parent.tmpPrefixTree != null || this.parent.tmpPrecision != 0) {
            GeoSparqlConfig config = this.parent.getConfig();
            GeoSparqlConfig.PrefixTree prefixTree = this.parent.tmpPrefixTree != null ? this.parent.tmpPrefixTree : config.getPrefixTree();
            int precision = this.parent.tmpPrecision != 0 ? this.parent.tmpPrecision : config.getPrecision();
            GeoSparqlUtils.validateParams(prefixTree, precision);
            config.setPrefixTree(prefixTree);
            config.setPrecision(precision);
            GeoSparqlUtils.saveConfig(config, this.parent.getDataDir().toPath());
        }
        if (!this.parent.getConfig().isEnabled()) {
            return;
        }
        final TLongHashSet processedFeatures = new TLongHashSet();
        final Function<Long, String> subjectMapper = subject -> pluginConnection.getEntities().get(subject.longValue()).stringValue();
        this.geometriesToUpdate.forEach(new TLongProcedure(){
            final List<Geometry> geometries = new ArrayList<Geometry>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void processGeometryWithPredicate(long value, long predicate) {
                try (StatementIterator sit = pluginConnection.getStatements().get(value, predicate, 0L);){
                    while (sit.next()) {
                        Geometry geometry = GeoSparqlUpdateListener.this.parent.getGeometryFromLiteralId(sit.object, predicate, pluginConnection.getEntities());
                        if (geometry == null) continue;
                        this.geometries.add(geometry);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(long value) {
                this.processGeometryWithPredicate(value, GeoSparqlUpdateListener.this.asWKT);
                this.processGeometryWithPredicate(value, GeoSparqlUpdateListener.this.asGML);
                GeoSparqlUpdateListener.this.parent.indexer.indexGeometryList(value, subjectMapper, this.geometries);
                try (StatementIterator sit = pluginConnection.getStatements().get(0L, GeoSparqlUpdateListener.this.hasDefaultGeometry, value);){
                    while (sit.next()) {
                        GeoSparqlUpdateListener.this.parent.indexer.indexGeometryList(sit.subject, subjectMapper, this.geometries);
                        processedFeatures.add(sit.subject);
                    }
                }
                this.geometries.clear();
                return true;
            }
        });
        this.featuresToUpdate.forEach(new TLongProcedure(){
            final List<Geometry> geometries = new ArrayList<Geometry>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void processGeometryWithPredicate(long value, long predicate) {
                try (StatementIterator sit = pluginConnection.getStatements().get(value, predicate, 0L);){
                    while (sit.next()) {
                        Geometry geometry = GeoSparqlUpdateListener.this.parent.getGeometryFromLiteralId(sit.object, predicate, pluginConnection.getEntities());
                        if (geometry == null) continue;
                        this.geometries.add(geometry);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void processFeatureWithPredicate(long value, long predicate) {
                try (StatementIterator sit = pluginConnection.getStatements().get(value, GeoSparqlUpdateListener.this.hasDefaultGeometry, 0L);){
                    while (sit.next()) {
                        this.processGeometryWithPredicate(sit.object, predicate);
                    }
                }
            }

            public boolean execute(long value) {
                if (!processedFeatures.contains(value)) {
                    this.processFeatureWithPredicate(value, GeoSparqlUpdateListener.this.asWKT);
                    this.processFeatureWithPredicate(value, GeoSparqlUpdateListener.this.asGML);
                    GeoSparqlUpdateListener.this.parent.indexer.indexGeometryList(value, subjectMapper, this.geometries);
                }
                this.geometries.clear();
                return true;
            }
        });
        this.cleanupAfterTransaction();
        try {
            this.parent.indexer.commit();
        }
        catch (Exception e) {
            this.parent.getLogger().warn("Unable to commit indexer transaction.", (Throwable)e);
        }
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        if (!this.parent.getConfig().isEnabled()) {
            return;
        }
        this.cleanupAfterTransaction();
        try {
            this.parent.indexer.rollback();
        }
        catch (Exception e) {
            this.parent.getLogger().warn("Unable to rollback indexer transaction.", (Throwable)e);
        }
    }

    private void cleanupAfterTransaction() {
        this.geometriesToUpdate.clear();
        this.featuresToUpdate.clear();
    }
}

